/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.web.rest.objects.resultset;

import java.util.List;
import org.saiku.olap.dto.resultset.CellDataSet;
import org.saiku.olap.query2.ThinQuery;
import org.saiku.service.util.ISaikuQuery;
import org.saiku.web.rest.objects.resultset.Cell;
import org.saiku.web.rest.objects.resultset.Total;
import org.saiku.web.rest.util.RestUtil;

public class QueryResult {
    private List<Cell[]> cellset;
    private Total[][] rowTotalsLists;
    private Total[][] colTotalsLists;
    private Integer runtime;
    private String error;
    private Integer height;
    private Integer width;
    private ISaikuQuery query;
    private int topOffset;
    private int leftOffset;

    public QueryResult(List<Cell[]> cellset, CellDataSet cellDataSet) {
        this(cellset, cellDataSet.getRuntime(), cellDataSet.getWidth(), cellDataSet.getHeight(), cellDataSet.getLeftOffset(), cellDataSet.getTopOffset(), RestUtil.convertTotals(cellDataSet.getRowTotalsLists()), RestUtil.convertTotals(cellDataSet.getColTotalsLists()));
    }

    private QueryResult(List<Cell[]> cellset, int runtime, int width, int height, int leftOffset, int topOffset, Total[][] rowTotalsLists, Total[][] colTotalsLists) {
        this(cellset, runtime, width, height);
        this.rowTotalsLists = rowTotalsLists;
        this.colTotalsLists = colTotalsLists;
        this.topOffset = topOffset;
        this.leftOffset = leftOffset;
    }

    public QueryResult(List<Cell[]> cellset, int runtime, int width, int height) {
        this.cellset = cellset;
        this.runtime = runtime;
        this.height = height;
        this.width = width;
    }

    public QueryResult(String error) {
        this.error = error;
    }

    public List<Cell[]> getCellset() {
        return this.cellset;
    }

    public Integer getRuntime() {
        return this.runtime;
    }

    public String getError() {
        return this.error;
    }

    public Integer getHeight() {
        return this.height;
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setRuntime(Integer runtime) {
        this.runtime = runtime;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public void setQuery(ThinQuery query) {
        this.query = query;
    }

    public ISaikuQuery getQuery() {
        return this.query;
    }

    public Total[][] getRowTotalsLists() {
        return this.rowTotalsLists;
    }

    public void setRowTotalsLists(Total[][] rowTotalsLists) {
        this.rowTotalsLists = rowTotalsLists;
    }

    public Total[][] getColTotalsLists() {
        return this.colTotalsLists;
    }

    public void setColTotalsLists(Total[][] colTotalsLists) {
        this.colTotalsLists = colTotalsLists;
    }

    public int getTopOffset() {
        return this.topOffset;
    }

    public int getLeftOffset() {
        return this.leftOffset;
    }
}

