/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.web.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mondrian.olap4j.SaikuMondrianHelper;
import org.apache.commons.lang.StringUtils;
import org.olap4j.OlapConnection;
import org.olap4j.OlapException;
import org.saiku.datasources.connection.AbstractConnectionManager;
import org.saiku.datasources.connection.ISaikuConnection;
import org.saiku.datasources.connection.SaikuConnectionFactory;
import org.saiku.datasources.datasource.SaikuDatasource;
import org.saiku.olap.util.exception.SaikuOlapException;
import org.saiku.service.ISessionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

public class SecurityAwareConnectionManager
extends AbstractConnectionManager
implements Serializable {
    private static final long serialVersionUID = -5912836681963684201L;
    private transient Map<String, ISaikuConnection> connections = new HashMap<String, ISaikuConnection>();
    private final List<String> errorConnections = new ArrayList<String>();
    private ISessionService sessionService;
    private static final Logger log = LoggerFactory.getLogger(SecurityAwareConnectionManager.class);

    public void setSessionService(ISessionService ss) {
        this.sessionService = ss;
    }

    public void init() {
        try {
            this.connections = this.getAllConnections();
        }
        catch (SaikuOlapException e) {
            log.error("Error getting connections", (Throwable)e);
        }
    }

    public void destroy() {
        if (this.connections != null && !this.connections.isEmpty()) {
            for (ISaikuConnection con : this.connections.values()) {
                try {
                    Connection c = con.getConnection();
                    if (c.isClosed()) continue;
                    c.close();
                }
                catch (Exception e) {
                    log.error("Error destroying connections", (Throwable)e);
                }
            }
        }
        if (this.connections != null) {
            this.connections.clear();
        }
    }

    protected ISaikuConnection getInternalConnection(String name, SaikuDatasource datasource) {
        Map session;
        String username;
        ISaikuConnection con = null;
        if (this.isDatasourceSecurity(datasource, "passthrough") && this.sessionService != null) {
            datasource = this.handlePassThrough(datasource);
        }
        String newName = name;
        if (this.isDatasourceSecurityEnabled(datasource) && this.sessionService != null && (username = (String)(session = this.sessionService.getAllSessionObjects()).get("username")) != null) {
            newName = name + "-" + username;
        }
        if (!this.connections.containsKey(newName)) {
            con = this.connect(name, datasource);
            if (con != null) {
                this.connections.put(newName, con);
            } else if (!this.errorConnections.contains(newName)) {
                this.errorConnections.add(newName);
            }
        } else {
            con = this.connections.get(newName);
        }
        if (con != null && !this.isDatasourceSecurity(datasource, "passthrough")) {
            con = this.applySecurity(con, datasource);
        }
        return con;
    }

    protected ISaikuConnection refreshInternalConnection(String name, SaikuDatasource datasource) {
        try {
            ISaikuConnection con;
            Map session;
            String username;
            String newName = name;
            if (this.isDatasourceSecurityEnabled(datasource) && this.sessionService != null && (username = (String)(session = this.sessionService.getAllSessionObjects()).get("username")) != null) {
                newName = name + "-" + username;
            }
            if ((con = this.connections.remove(newName)) != null) {
                con.clearCache();
            }
            return this.getInternalConnection(name, datasource);
        }
        catch (Exception e) {
            log.error("Error refreshing connection: " + name, (Throwable)e);
            return null;
        }
    }

    private SaikuDatasource handlePassThrough(SaikuDatasource datasource) {
        Map session = this.sessionService.getAllSessionObjects();
        String username = (String)session.get("username");
        if (username != null) {
            String password = (String)session.get("password");
            datasource.getProperties().setProperty("username", username);
            if (password != null) {
                datasource.getProperties().setProperty("password", password);
            }
            return datasource;
        }
        return null;
    }

    private ISaikuConnection applySecurity(ISaikuConnection con, SaikuDatasource datasource) {
        if (con == null) {
            throw new IllegalArgumentException("Cannot apply Security to NULL connection object");
        }
        if (this.isDatasourceSecurity(datasource, "one2one")) {
            List<String> springRoles = this.getSpringRoles();
            List<String> conRoles = this.getConnectionRoles(con);
            String roleName = null;
            for (String sprRole : springRoles) {
                if (!conRoles.contains(sprRole)) continue;
                if (roleName == null) {
                    roleName = sprRole;
                    continue;
                }
                roleName = roleName + "," + sprRole;
            }
            if (this.setRole(con, roleName, datasource)) {
                return con;
            }
        } else if (this.isDatasourceSecurity(datasource, "lookup")) {
            Map<String, List<String>> mapping = this.getRoleMapping(datasource);
            List<String> springRoles = this.getSpringRoles();
            String roleName = null;
            for (String sprRole : springRoles) {
                if (!mapping.containsKey(sprRole)) continue;
                List<String> roles = mapping.get(sprRole);
                for (String role : roles) {
                    if (roleName == null) {
                        roleName = role;
                        continue;
                    }
                    roleName = roleName + "," + role;
                }
            }
            if (this.setRole(con, roleName, datasource)) {
                return con;
            }
        }
        return con;
    }

    private boolean setRole(ISaikuConnection con, String roleName, SaikuDatasource datasource) {
        if (con.getConnection() instanceof OlapConnection) {
            OlapConnection c = (OlapConnection)con.getConnection();
            log.info("Setting role to datasource:" + datasource.getName() + " role:" + roleName);
            try {
                if (StringUtils.isNotBlank((String)roleName) && SaikuMondrianHelper.isMondrianConnection((OlapConnection)c) && roleName.split(",").length > 1) {
                    SaikuMondrianHelper.setRoles((OlapConnection)c, (String[])roleName.split(","));
                } else {
                    c.setRoleName(roleName);
                }
                return true;
            }
            catch (Exception e) {
                log.error("Error setting role: " + roleName, (Throwable)e);
            }
        }
        return false;
    }

    private List<String> getSpringRoles() {
        ArrayList<String> roles = new ArrayList<String>();
        if (SecurityContextHolder.getContext() != null && SecurityContextHolder.getContext().getAuthentication() != null) {
            Collection auths = SecurityContextHolder.getContext().getAuthentication().getAuthorities();
            for (GrantedAuthority a : auths) {
                roles.add(a.getAuthority());
            }
        }
        return roles;
    }

    private List<String> getConnectionRoles(ISaikuConnection con) {
        if (con.getDatasourceType().equals("OLAP") && con.getConnection() instanceof OlapConnection) {
            OlapConnection c = (OlapConnection)con.getConnection();
            try {
                return c.getAvailableRoleNames();
            }
            catch (OlapException e) {
                log.error("Error getting connection roles", (Throwable)e);
            }
        }
        return new ArrayList<String>();
    }

    private Map<String, List<String>> getRoleMapping(SaikuDatasource datasource) {
        String mappings;
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        if (datasource.getProperties().containsKey("security.mapping") && (mappings = datasource.getProperties().getProperty("security.mapping")) != null) {
            String[] maps;
            for (String map : maps = mappings.split(";")) {
                String[] m = map.split("=");
                if (m.length != 2) continue;
                if (!result.containsKey(m[0])) {
                    result.put(m[0], new ArrayList());
                }
                ((List)result.get(m[0])).add(m[1]);
            }
        }
        return result;
    }

    private ISaikuConnection connect(String name, SaikuDatasource datasource) {
        try {
            ISaikuConnection con = SaikuConnectionFactory.getConnection((SaikuDatasource)datasource);
            if (con.initialized()) {
                return con;
            }
        }
        catch (Exception e) {
            log.error("Error connecting: " + name, (Throwable)e);
        }
        return null;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.connections = new HashMap<String, ISaikuConnection>();
    }
}

