/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.service.util;

import java.sql.Connection;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.olap4j.CellSet;
import org.saiku.olap.query2.ThinQuery;
import org.saiku.service.util.ISaikuQuery;
import org.saiku.service.util.exception.SaikuServiceException;

public class QueryContext {
    private final String id = UUID.randomUUID().toString();
    private final Type type;
    private final Map<ObjectKey, Object> objects = new HashMap<ObjectKey, Object>();

    public QueryContext(Type type, ISaikuQuery query) {
        this.type = type;
        this.objects.put(ObjectKey.QUERY, query);
    }

    public String id() {
        return this.id;
    }

    public Type getType() {
        return this.type;
    }

    private Connection getConnection() {
        if (this.objects.containsKey((Object)ObjectKey.CONNECTION)) {
            return (Connection)this.objects.get((Object)ObjectKey.CONNECTION);
        }
        throw new SaikuServiceException("Context: " + this.id + " does not contain a connection object");
    }

    public ThinQuery getOlapQuery() {
        Object o;
        if (this.objects.containsKey((Object)ObjectKey.QUERY) && (o = this.objects.get((Object)ObjectKey.QUERY)) instanceof ThinQuery) {
            return (ThinQuery)this.objects.get((Object)ObjectKey.QUERY);
        }
        throw new SaikuServiceException("Context: " + this.id + " does not contain a query object");
    }

    public CellSet getOlapResult() {
        Object o;
        if (this.objects.containsKey((Object)ObjectKey.RESULT) && (o = this.objects.get((Object)ObjectKey.RESULT)) instanceof CellSet) {
            return (CellSet)this.objects.get((Object)ObjectKey.RESULT);
        }
        return null;
    }

    public Statement getStatement() {
        if (this.objects.containsKey((Object)ObjectKey.STATEMENT)) {
            return (Statement)this.objects.get((Object)ObjectKey.STATEMENT);
        }
        throw new SaikuServiceException("Context: " + this.id + " does not contain a statement object");
    }

    public void store(ObjectKey key, Object value) {
        this.objects.put(key, value);
    }

    public boolean contains(ObjectKey key) {
        return this.objects.containsKey((Object)key);
    }

    public void remove(ObjectKey key) {
        if (this.contains(key)) {
            this.objects.remove((Object)key);
        }
    }

    public void destroy() throws Exception {
        if (this.contains(ObjectKey.STATEMENT)) {
            Statement stmt = this.getStatement();
            stmt.close();
            stmt = null;
        }
        if (this.contains(ObjectKey.CONNECTION)) {
            Connection con = this.getConnection();
            con.close();
            Object var1_1 = null;
        }
        this.objects.clear();
    }

    public static enum ObjectKey {
        CONTEXT_TYPE,
        CONNECTION,
        RESULT,
        CACHE,
        STATEMENT,
        QUERY;

    }

    public static enum Type {
        OLAP;

    }
}

