/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.service.olap.totals.aggregators;

import java.util.Set;
import mondrian.util.Format;
import org.olap4j.Cell;
import org.olap4j.OlapException;
import org.olap4j.metadata.Datatype;
import org.olap4j.metadata.Measure;
import org.olap4j.metadata.Property;
import org.saiku.service.olap.totals.aggregators.TotalAggregator;

public class AvgAggregator
extends TotalAggregator {
    private static final Property DRILLTHROUGH_COUNT = new Property(){

        public String getCaption() {
            return null;
        }

        public String getDescription() {
            return null;
        }

        public String getName() {
            return "DRILLTHROUGH_COUNT";
        }

        public String getUniqueName() {
            return null;
        }

        public boolean isVisible() {
            return false;
        }

        public Property.ContentType getContentType() {
            return null;
        }

        public Datatype getDatatype() {
            return null;
        }

        public Set<Property.TypeFlag> getType() {
            return null;
        }
    };
    private double accumulator = 0.0;
    private long count = 0L;

    AvgAggregator(Format format) {
        super(format);
    }

    @Override
    public void addData(Cell cell) {
        Object value = cell.getValue();
        if (value instanceof Number) {
            double doubleVal;
            Integer count = (Integer)cell.getPropertyValue(DRILLTHROUGH_COUNT);
            try {
                doubleVal = cell.getDoubleValue();
            }
            catch (OlapException e) {
                throw new RuntimeException(e);
            }
            if (count.longValue() > -1L) {
                this.count += count.longValue();
                this.accumulator += doubleVal * count.doubleValue();
            } else {
                ++this.count;
                this.accumulator += doubleVal;
            }
        }
    }

    @Override
    public void addData(double data) {
    }

    @Override
    public Double getValue() {
        if (this.count > 0L) {
            return this.accumulator / (double)this.count;
        }
        return null;
    }

    @Override
    public TotalAggregator newInstance(Format format, Measure measure) {
        return new AvgAggregator(format);
    }
}

