/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.service.olap.drillthrough;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import org.saiku.olap.dto.SaikuHierarchy;
import org.saiku.olap.dto.SaikuLevel;
import org.saiku.olap.dto.SaikuMember;
import org.saiku.service.olap.drillthrough.DimensionResultInfo;
import org.saiku.service.olap.drillthrough.MeasureResultInfo;
import org.saiku.service.olap.drillthrough.ResultInfo;

public class DrillthroughUtils {
    public static SaikuMember findMeasure(List<SaikuMember> measures, final String measureName) {
        return (SaikuMember)Iterables.find(measures, (Predicate)new Predicate<SaikuMember>(){

            public boolean apply(SaikuMember input) {
                return input.getName().equals(measureName);
            }
        });
    }

    public static SaikuHierarchy findHierarchy(List<SaikuHierarchy> hierarchies, final String hierarchyName) {
        return (SaikuHierarchy)Iterables.find(hierarchies, (Predicate)new Predicate<SaikuHierarchy>(){

            public boolean apply(SaikuHierarchy input) {
                return input.getName().equals(hierarchyName);
            }
        });
    }

    public static SaikuLevel findLevel(List<SaikuLevel> levels, final String levelName) {
        return (SaikuLevel)Iterables.find(levels, (Predicate)new Predicate<SaikuLevel>(){

            public boolean apply(SaikuLevel input) {
                return input.getName().equals(levelName);
            }
        });
    }

    public static List<ResultInfo> extractResultInfo(String returns) {
        String[] split = returns.split(",");
        ArrayList<ResultInfo> results = new ArrayList<ResultInfo>();
        for (String column : split) {
            String[] split2 = column.trim().split("\\.");
            ArrayList<String> els = new ArrayList<String>();
            for (int i = 0; i < split2.length; ++i) {
                String token = split2[i];
                els.add(token.trim().replaceAll("[\\[\\]]", ""));
            }
            if (((String)els.get(0)).equalsIgnoreCase("Measures")) {
                results.add(new MeasureResultInfo((String)els.get(1)));
                continue;
            }
            if (els.size() >= 3) {
                results.add(new DimensionResultInfo((String)els.get(0), (String)els.get(1), (String)els.get(2)));
                continue;
            }
            results.add(new DimensionResultInfo((String)els.get(0), (String)els.get(0), (String)els.get(1)));
        }
        return results;
    }
}

