/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.repository;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.jcr.LoginException;
import javax.jcr.Repository;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.server.BasicCredentialsProvider;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavMethods;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavServletRequest;
import org.apache.jackrabbit.webdav.DavServletResponse;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.apache.jackrabbit.webdav.WebdavRequestImpl;
import org.apache.jackrabbit.webdav.WebdavResponse;
import org.apache.jackrabbit.webdav.WebdavResponseImpl;
import org.apache.jackrabbit.webdav.simple.SimpleWebdavServlet;
import org.apache.jackrabbit.webdav.util.CSRFUtil;
import org.saiku.database.dto.SaikuUser;
import org.saiku.repository.SaikuSessionProvider;
import org.saiku.service.datasource.RepositoryDatasourceManager;
import org.saiku.service.user.UserService;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public final class SaikuWebdavServlet
extends SimpleWebdavServlet {
    private RepositoryDatasourceManager bean;
    private CSRFUtil csrfUtil;
    private UserService us;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String csrfParam = this.getInitParameter("csrf-protection");
        this.csrfUtil = new CSRFUtil(csrfParam);
        ServletContext context = this.getServletContext();
        WebApplicationContext applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)context);
        this.bean = (RepositoryDatasourceManager)applicationContext.getBean("repositoryDsManager");
        this.us = (UserService)applicationContext.getBean("userServiceBean");
    }

    private boolean checkUserRole(HttpServletRequest request) {
        for (SaikuUser u : this.us.getUsers()) {
            String req = request.getRemoteUser();
            BasicCredentialsProvider b = new BasicCredentialsProvider(null);
            SimpleCredentials creds = null;
            try {
                creds = (SimpleCredentials)b.getCredentials(request);
            }
            catch (ServletException | LoginException e) {
                e.printStackTrace();
            }
            if (!u.getUsername().equals(creds.getUserID())) continue;
            String[] roles = this.us.getRoles(u);
            List<String> admin = this.us.getAdminRoles();
            for (String r : roles) {
                if (!admin.contains(r)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkUnsecured(HttpServletRequest request) {
        return request.getRequestURI().contains("/etc/theme");
    }

    private boolean checkSecret(HttpServletRequest request) {
        if (request.getRequestURI().contains("/datasources")) {
            return this.checkUserRole(request);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        WebdavResponseImpl webdavResponse;
        int methodCode;
        WebdavRequestImpl webdavRequest;
        block23: {
            webdavRequest = new WebdavRequestImpl(request, this.getLocatorFactory(), this.isCreateAbsoluteURI());
            methodCode = DavMethods.getMethodCode((String)request.getMethod());
            boolean noCache = DavMethods.isDeltaVMethod((DavServletRequest)webdavRequest) && 20 != methodCode && 19 != methodCode;
            webdavResponse = new WebdavResponseImpl(response, noCache);
            try {
                if (this.checkUnsecured(request) && !this.getDavSessionProvider().attachSession((WebdavRequest)webdavRequest)) {
                    request.setAttribute("org.apache.jackrabbit.server.SessionProvider", (Object)new SaikuSessionProvider());
                }
            }
            catch (DavException e) {
                if (!this.checkUnsecured(request)) break block23;
                request.setAttribute("org.apache.jackrabbit.server.SessionProvider", (Object)new SaikuSessionProvider());
            }
        }
        try {
            if (!this.getDavSessionProvider().attachSession((WebdavRequest)webdavRequest)) {
                return;
            }
            if (!this.checkUnsecured((HttpServletRequest)webdavRequest) && !this.checkUserRole((HttpServletRequest)webdavRequest)) {
                return;
            }
            if (!this.checkSecret(request)) {
                webdavResponse.sendError(403);
                return;
            }
            if (!this.csrfUtil.isValidRequest((HttpServletRequest)webdavRequest)) {
                webdavResponse.sendError(403);
                return;
            }
            DavResource resource = this.getResourceFactory().createResource(webdavRequest.getRequestLocator(), (DavServletRequest)webdavRequest, (DavServletResponse)webdavResponse);
            if (!this.isPreconditionValid((WebdavRequest)webdavRequest, resource)) {
                webdavResponse.sendError(412);
                return;
            }
            if (!this.execute((WebdavRequest)webdavRequest, (WebdavResponse)webdavResponse, methodCode, resource)) {
                super.service(request, response);
            }
        }
        catch (DavException e) {
            if (e.getErrorCode() == 401) {
                this.sendUnauthorized((WebdavRequest)webdavRequest, (WebdavResponse)webdavResponse, e);
            } else {
                webdavResponse.sendError(e);
            }
        }
        catch (Exception e) {
            this.log("Exception:", e.getCause());
        }
        finally {
            this.getDavSessionProvider().releaseSession((WebdavRequest)webdavRequest);
        }
    }

    public Repository getRepository() {
        return (Repository)this.bean.getRepository();
    }

    public void doPost(WebdavRequest request, WebdavResponse response, DavResource resource) throws IOException, DavException {
        DavResource parentResource = resource.getCollection();
        if (parentResource == null || !parentResource.exists()) {
            response.sendError(409);
            return;
        }
        int status = resource.exists() ? 204 : 201;
        parentResource.addMember(resource, this.getInputContext((DavServletRequest)request, (InputStream)request.getInputStream()));
        response.setStatus(status);
    }

    public void doPut(WebdavRequest request, WebdavResponse response, DavResource resource) throws IOException, DavException {
        super.doPut(request, response, resource);
    }
}

