/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.repository;

import com.marklogic.xcc.AdhocQuery;
import com.marklogic.xcc.Content;
import com.marklogic.xcc.ContentCreateOptions;
import com.marklogic.xcc.ContentFactory;
import com.marklogic.xcc.ContentSource;
import com.marklogic.xcc.ContentSourceFactory;
import com.marklogic.xcc.DocumentFormat;
import com.marklogic.xcc.Request;
import com.marklogic.xcc.RequestOptions;
import com.marklogic.xcc.ResultItem;
import com.marklogic.xcc.ResultSequence;
import com.marklogic.xcc.Session;
import com.marklogic.xcc.exceptions.RequestException;
import com.marklogic.xcc.exceptions.XccConfigException;
import jakarta.servlet.http.HttpSession;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.saiku.database.dto.MondrianSchema;
import org.saiku.datasources.connection.RepositoryFile;
import org.saiku.repository.Acl2;
import org.saiku.repository.AclEntry;
import org.saiku.repository.AclMethod;
import org.saiku.repository.AclType;
import org.saiku.repository.DataSource;
import org.saiku.repository.IRepositoryManager;
import org.saiku.repository.IRepositoryObject;
import org.saiku.repository.RepositoryFileObject;
import org.saiku.repository.RepositoryFolderObject;
import org.saiku.repository.ScopedRepo;
import org.saiku.service.user.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkLogicRepositoryManager
implements IRepositoryManager {
    private static final String SAIKU_AUTH_PRINCIPAL = "SAIKU_AUTH_PRINCIPAL";
    private static final Logger log = LoggerFactory.getLogger(MarkLogicRepositoryManager.class);
    private static final String[] PARAMETER_DELIMITER = new String[]{"%(", ")"};
    private static final String HOMES_DIRECTORY = "/homes/";
    private static final String DATASOURCES_DIRECTORY = "/datasources/";
    private static final String SCHEMAS_DIRECTORY = "/datasources/";
    private String host = "localhost";
    private int port = 8070;
    private String username = "DEFAULT_USERNAME";
    private String password = "DEFAULT_PASSWORD";
    private String database = "DEFAULT_DATABASE";
    private String connectionUrl;
    private ContentSource contentSource;
    private UserService userService;
    private static MarkLogicRepositoryManager instance;
    private String sep = "/";
    private String append;
    private ScopedRepo sessionRegistry;
    private boolean workspaces;

    public MarkLogicRepositoryManager(String host, int port, String username, String password, String database, String data, ScopedRepo sessionRegistry, boolean workspaces) {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.database = database;
        this.append = this.cleanse(data);
        this.sessionRegistry = sessionRegistry;
        this.workspaces = workspaces;
        this.init();
    }

    public static synchronized MarkLogicRepositoryManager getMarkLogicRepositoryManager(String host, int port, String username, String password, String database, String data, ScopedRepo sessionRegistry, boolean workspaces) {
        if (instance == null) {
            instance = new MarkLogicRepositoryManager(host, port, username, password, database, data, sessionRegistry, workspaces);
        }
        return instance;
    }

    @Override
    public void init() {
        Map<String, String> values = ParamsMap.init().put("host", this.host).put("port", Integer.toString(this.port)).put("username", this.username).put("password", this.password).put("database", this.database).build();
        StrSubstitutor sub = MarkLogicRepositoryManager.createStrSubstitutor(values);
        this.connectionUrl = sub.replace("xcc://%(username):%(password)@%(host):%(port)/%(database)");
        this.connect();
    }

    @Override
    public boolean start(UserService userService) throws RepositoryException {
        this.userService = userService;
        if (!this.folderExists(HOMES_DIRECTORY)) {
            this.createFolder(HOMES_DIRECTORY);
        }
        if (!this.folderExists("/datasources/")) {
            this.createFolder("/datasources/");
        }
        if (!this.folderExists("/datasources/")) {
            this.createFolder("/datasources/");
        }
        this.createFolder(this.sep + "etc");
        if (new File(this.append + "/etc/license.lic").exists()) {
            try {
                this.saveBinaryInternalFile(new FileInputStream(this.append + "/etc/license.lic"), "/etc/license.lic", "");
            }
            catch (IOException e1) {
                log.debug("Failed to find license 1");
                try {
                    this.saveBinaryInternalFile(new FileInputStream(this.append + "/unknown/etc/license.lic"), "/etc/license.lic", "");
                }
                catch (IOException e2) {
                    log.debug("failed to find any licenses. Giving up");
                }
            }
        }
        return true;
    }

    @Override
    public void createUser(String u) throws RepositoryException {
        this.createFolder(HOMES_DIRECTORY + u + "/");
    }

    @Override
    public Object getHomeFolders() throws RepositoryException {
        return this.getFilesFromFolder(HOMES_DIRECTORY, true);
    }

    @Override
    public Object getHomeFolder(String directory) throws RepositoryException {
        return this.getFilesFromFolder(HOMES_DIRECTORY + directory, false);
    }

    @Override
    public Object getFolder(String user, String directory) throws RepositoryException {
        return this.getFilesFromFolder(HOMES_DIRECTORY + user + "/" + directory + "/", false);
    }

    @Override
    public void shutdown() {
    }

    @Override
    public boolean createFolder(String username, String folder) throws RepositoryException {
        this.createFolder(HOMES_DIRECTORY + username + "/" + folder + "/");
        return true;
    }

    @Override
    public boolean deleteFolder(String folder) throws RepositoryException {
        if (!folder.endsWith("/")) {
            this.deleteFile(folder);
        } else {
            this.executeUpdate("xdmp:directory-delete('%(folder)')", ParamsMap.init().put("folder", folder).build());
        }
        return true;
    }

    @Override
    public void deleteRepository() throws RepositoryException {
    }

    @Override
    public boolean moveFolder(String user, String folder, String source, String target) throws RepositoryException {
        return false;
    }

    @Override
    public Object saveFile(Object file, String path, String user, String type, List<String> roles) throws RepositoryException {
        if (file != null) {
            Session session = this.createUpdateSession();
            ContentCreateOptions options = new ContentCreateOptions();
            options.setFormat(DocumentFormat.TEXT);
            Content content = ContentFactory.newContent((String)path, (String)((String)file), (ContentCreateOptions)options);
            try {
                session.insertContent(content);
                session.commit();
            }
            catch (RequestException e) {
                log.error("Error while trying to save the file: " + path, (Throwable)e);
                throw new RepositoryException((Throwable)e);
            }
            return new File(path);
        }
        this.createFolder(user, path);
        return null;
    }

    @Override
    public void removeFile(String path, String user, List<String> roles) throws RepositoryException {
        Map<String, String> params = ParamsMap.init().put("doc_uri", HOMES_DIRECTORY + user + "/" + path).build();
        this.executeUpdate("xdmp:document-delete('%(doc_uri)')", params);
    }

    @Override
    public void moveFile(String source, String target, String user, List<String> roles) throws RepositoryException {
    }

    @Override
    public Object saveInternalFile(Object file, String path, String type) throws RepositoryException {
        if (file != null) {
            Session session = this.createUpdateSession();
            ContentCreateOptions options = new ContentCreateOptions();
            options.setFormat(DocumentFormat.TEXT);
            Content content = ContentFactory.newContent((String)path, (String)((String)file), (ContentCreateOptions)options);
            try {
                session.insertContent(content);
                session.commit();
                return new File(path);
            }
            catch (RequestException e) {
                log.error("Could not save the internal file: " + file, (Throwable)e);
                throw new RepositoryException((Throwable)e);
            }
        }
        this.createFolder(path);
        return null;
    }

    @Override
    public Object saveBinaryInternalFile(InputStream file, String path, String type) throws RepositoryException {
        Session session = this.createUpdateSession();
        ContentCreateOptions options = new ContentCreateOptions();
        options.setFormat(DocumentFormat.BINARY);
        try {
            Content content = ContentFactory.newContent((String)path, (InputStream)file, (ContentCreateOptions)options);
            session.insertContent(content);
            session.commit();
            return new File(path);
        }
        catch (IOException ex) {
            log.error("Error while trying to save the file", (Throwable)ex);
            throw new RepositoryException((Throwable)ex);
        }
        catch (RequestException ex) {
            log.error("Error while trying to save the file", (Throwable)ex);
            throw new RepositoryException((Throwable)ex);
        }
    }

    @Override
    public String getFile(String s, String username, List<String> roles) throws RepositoryException {
        Session session = this.contentSource.newSession();
        RequestOptions options = new RequestOptions();
        options.setCacheResult(false);
        if (s != null && !(s = s.replace('\\', '/')).startsWith("/")) {
            s = "/" + s;
        }
        AdhocQuery request = session.newAdhocQuery("doc('" + s + "')", options);
        try {
            ResultSequence rs = session.submitRequest((Request)request);
            ResultItem item = rs.next();
            if (item == null) {
                throw new RepositoryException("No document found with URI '" + s + "'");
            }
            StringWriter writer = new StringWriter();
            item.writeTo((Writer)writer);
            return writer.toString();
        }
        catch (RequestException e) {
            log.error("Error whilte trying to fetch the file " + s, (Throwable)e);
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            log.error("Error whilte trying to fetch the file " + s, (Throwable)e);
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public String getInternalFile(String s) throws RepositoryException {
        return this.getFile(s, null, null);
    }

    @Override
    public InputStream getBinaryInternalFile(String s) throws RepositoryException {
        if (s != null) {
            s = s.replace('\\', '/');
        }
        Session session = this.contentSource.newSession();
        RequestOptions options = new RequestOptions();
        options.setCacheResult(false);
        AdhocQuery request = session.newAdhocQuery("doc('" + s + "')", options);
        try {
            ResultSequence rs = session.submitRequest((Request)request);
            ResultItem item = rs.next();
            if (item == null) {
                throw new RepositoryException("No document found with URI '" + s + "'");
            }
            return item.asInputStream();
        }
        catch (RequestException e) {
            log.error("Error whilte trying to fetch the binary file " + s, (Throwable)e);
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public void removeInternalFile(String s) throws RepositoryException {
        if (s.contains("\\")) {
            s = s.replace('\\', '/');
        }
        Map<String, String> params = ParamsMap.init().put("doc_uri", s).build();
        this.executeUpdate("xdmp:document-delete('%(doc_uri)')", params);
    }

    @Override
    public List<MondrianSchema> getAllSchema() throws RepositoryException {
        ArrayList<MondrianSchema> schemas = new ArrayList<MondrianSchema>();
        for (File file : this.getFilesFromFolder("/datasources/", false)) {
            if (file == null || file.getName() == null || !file.getName().toLowerCase().endsWith("xml")) continue;
            MondrianSchema ms = new MondrianSchema();
            ms.setName(file.getName());
            ms.setPath(file.getPath());
            schemas.add(ms);
        }
        return schemas;
    }

    @Override
    public List<DataSource> getAllDataSources() throws RepositoryException {
        ArrayList<DataSource> dataSources = new ArrayList<DataSource>();
        JAXBContext jaxbContext = null;
        Unmarshaller jaxbMarshaller = null;
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{DataSource.class});
        }
        catch (JAXBException e) {
            log.error("Could instantiate the JAXBContent", (Throwable)e);
        }
        try {
            jaxbMarshaller = jaxbContext != null ? jaxbContext.createUnmarshaller() : null;
        }
        catch (JAXBException e) {
            log.error("Could not create the XML unmarshaller", (Throwable)e);
        }
        if (jaxbMarshaller != null) {
            for (File file : this.getFilesFromFolder("/datasources/", false)) {
                if (file == null || file.getName() == null || !file.getName().toLowerCase().endsWith("sds")) continue;
                DataSource d = null;
                try {
                    InputStream stream = this.getBinaryInternalFile(file.getPath());
                    d = (DataSource)jaxbMarshaller.unmarshal(stream);
                }
                catch (JAXBException e) {
                    log.error("Could not unmarshall the XML file", (Throwable)e);
                }
                catch (Exception e) {
                    log.error("Unexpected error while trying to unmarshall the XML file", (Throwable)e);
                }
                if (d == null) continue;
                d.setPath(file.getPath());
                if (this.getCookieUsername() != null) {
                    if (!this.getCookieUsername().equals(d.getUsername())) continue;
                    dataSources.add(d);
                    continue;
                }
                dataSources.add(d);
            }
        }
        return dataSources;
    }

    private String getCookieUsername() {
        String cookieUsername = null;
        HttpSession session = this.getSession();
        if (session != null && this.workspaces && session.getAttribute(SAIKU_AUTH_PRINCIPAL) != null) {
            cookieUsername = (String)session.getAttribute(SAIKU_AUTH_PRINCIPAL);
        }
        if (cookieUsername != null && cookieUsername.trim().length() == 0) {
            cookieUsername = null;
        }
        return cookieUsername;
    }

    private HttpSession getSession() {
        try {
            return this.sessionRegistry.getSession();
        }
        catch (Exception e) {
            log.debug("Error while fetching the HTTPSession", (Throwable)e);
            return null;
        }
    }

    @Override
    public void saveDataSource(DataSource ds, String path, String user) throws RepositoryException {
        Session session = this.createUpdateSession();
        ContentCreateOptions options = new ContentCreateOptions();
        options.setFormat(DocumentFormat.BINARY);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{DataSource.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshaller.marshal((Object)ds, (OutputStream)baos);
            ByteArrayInputStream bis = new ByteArrayInputStream(baos.toByteArray());
            Content content = ContentFactory.newContent((String)path, (InputStream)bis, (ContentCreateOptions)options);
            session.insertContent(content);
            session.commit();
        }
        catch (JAXBException e) {
            log.error("Could not marshall the datasource", (Throwable)e);
            throw new RepositoryException((Throwable)e);
        }
        catch (RequestException e) {
            log.error("Could not marshall the datasource", (Throwable)e);
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            log.error("Could not marshall the datasource", (Throwable)e);
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public byte[] exportRepository() throws RepositoryException, IOException {
        return null;
    }

    @Override
    public void restoreRepository(byte[] xml) throws RepositoryException, IOException {
    }

    @Override
    public RepositoryFile getFile(String fileUrl) {
        File f = new File(fileUrl);
        return new RepositoryFile(f.getName(), null, null, f.getPath());
    }

    @Override
    public List<IRepositoryObject> getAllFiles(List<String> type, String username, List<String> roles) {
        try {
            return this.getAllFiles(type, username, roles, "/");
        }
        catch (Exception ex) {
            return new ArrayList<IRepositoryObject>();
        }
    }

    @Override
    public List<IRepositoryObject> getAllFiles(List<String> type, String username, List<String> roles, String path) throws RepositoryException {
        ArrayList<IRepositoryObject> files = new ArrayList<IRepositoryObject>();
        Acl2 acl = new Acl2(new File(path));
        ArrayList<String> dirUris = new ArrayList<String>();
        this.getRecursiveDirectories(path, dirUris);
        for (String dirUri : dirUris) {
            ArrayList<IRepositoryObject> dirFiles = new ArrayList();
            if (dirUri.equals(path)) {
                dirFiles = files;
            }
            for (File f : this.getFilesFromFolder(path, false)) {
                for (String fileType : type) {
                    if (!f.getName().toLowerCase().endsWith(fileType.toLowerCase())) continue;
                    List<AclMethod> acls = acl.getMethods(f, username, roles);
                    dirFiles.add(new RepositoryFileObject(f.getName(), "#" + f.getPath(), fileType, f.getPath(), acls));
                }
            }
            if (dirUri.equals(path)) continue;
            this.sortFiles(dirFiles);
            List<AclMethod> acls = acl.getMethods(new File(dirUri), username, roles);
            files.add(new RepositoryFolderObject(dirUri, "#" + dirUri, dirUri, acls, dirFiles));
        }
        this.sortFiles(files);
        return files;
    }

    private void getRecursiveDirectories(String root, List<String> foundSoFar) throws RepositoryException {
        if (foundSoFar.contains(root)) {
            return;
        }
        foundSoFar.add(root);
        for (File f : this.getFilesFromFolder(root, true)) {
            this.getRecursiveDirectories(f.getPath(), foundSoFar);
        }
    }

    private void sortFiles(List<IRepositoryObject> files) {
        Collections.sort(files, new Comparator<IRepositoryObject>(){

            @Override
            public int compare(IRepositoryObject o1, IRepositoryObject o2) {
                if (o1.getType().equals((Object)IRepositoryObject.Type.FOLDER) && o2.getType().equals((Object)IRepositoryObject.Type.FILE)) {
                    return -1;
                }
                if (o1.getType().equals((Object)IRepositoryObject.Type.FILE) && o2.getType().equals((Object)IRepositoryObject.Type.FOLDER)) {
                    return 1;
                }
                return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
            }
        });
    }

    @Override
    public void deleteFile(String datasourcePath) {
        try {
            this.removeInternalFile(datasourcePath);
        }
        catch (RepositoryException e) {
            log.error("Error while trying to delete the file: " + datasourcePath, (Throwable)e);
        }
    }

    @Override
    public AclEntry getACL(String object, String username, List<String> roles) {
        try {
            if (this.folderExists(HOMES_DIRECTORY + username + "/" + object + "/")) {
                HashMap<String, List<AclMethod>> generalRolesMap = new HashMap<String, List<AclMethod>>();
                HashMap<String, List<AclMethod>> userRolesMap = new HashMap<String, List<AclMethod>>();
                return new AclEntry(username, AclType.PUBLIC, generalRolesMap, userRolesMap);
            }
        }
        catch (RepositoryException e) {
            return null;
        }
        return null;
    }

    @Override
    public void setACL(String object, String acl, String username, List<String> roles) throws RepositoryException {
    }

    @Override
    public List<MondrianSchema> getInternalFilesOfFileType(String type) throws RepositoryException {
        return this.getAllSchema();
    }

    @Override
    public void createFileMixin(String type) throws RepositoryException {
    }

    @Override
    public Object getRepositoryObject() {
        return null;
    }

    private void connect() {
        try {
            URI uri = new URI(this.connectionUrl);
            this.contentSource = ContentSourceFactory.newContentSource((URI)uri);
        }
        catch (URISyntaxException e) {
            log.error("Incorrect URI syntax: " + this.connectionUrl, (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (XccConfigException e) {
            log.error("Wrong XCC configuration", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File[] getFilesFromFolder(String path, boolean directories) throws RepositoryException {
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        String regexEnd = directories ? ".+/$" : ".+[^/]$";
        Session session = this.contentSource.newSession();
        AdhocQuery request = session.newAdhocQuery("cts:uris()[matches(., '^" + path + regexEnd + "')]");
        try {
            ResultSequence rs = session.submitRequest((Request)request);
            File[] folders = new File[rs.size()];
            int i = 0;
            while (rs.hasNext()) {
                folders[i++] = new File(rs.next().asString());
            }
            File[] fileArray = folders;
            return fileArray;
        }
        catch (RequestException e) {
            log.error("Error while trying to fetch the home folders", (Throwable)e);
            File[] fileArray = new File[]{};
            return fileArray;
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFolder(String path) throws RepositoryException {
        if (path == null) {
            return;
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        Session session = this.createUpdateSession();
        Map<String, String> parameters = ParamsMap.init().put("path", path).build();
        String update = "xdmp:directory-create('%(path)')";
        StrSubstitutor sub = MarkLogicRepositoryManager.createStrSubstitutor(parameters);
        AdhocQuery request = session.newAdhocQuery(sub.replace(update));
        try {
            session.submitRequest((Request)request);
            session.commit();
        }
        catch (RequestException requestException) {
        }
        finally {
            session.close();
        }
    }

    private boolean folderExists(String directory) throws RepositoryException {
        Session session = this.contentSource.newSession();
        AdhocQuery request = session.newAdhocQuery("xdmp:exists(xdmp:directory-properties('" + directory + "','1'))");
        try {
            ResultSequence rs = session.submitRequest((Request)request);
            return Boolean.parseBoolean(rs.next().asString());
        }
        catch (Exception ex) {
            return false;
        }
    }

    private Session createUpdateSession() {
        Session session = this.contentSource.newSession();
        session.setTransactionMode(Session.TransactionMode.UPDATE);
        return session;
    }

    private void executeUpdate(String update, Map<String, String> parameters) throws RepositoryException {
        this.executeUpdate(update, parameters, null);
    }

    private void executeUpdate(String update, Map<String, String> parameters, String errorMsg) throws RepositoryException {
        Session session = this.createUpdateSession();
        AdhocQuery request = null;
        if (parameters != null) {
            StrSubstitutor sub = MarkLogicRepositoryManager.createStrSubstitutor(parameters);
            request = session.newAdhocQuery(sub.replace(update));
        } else {
            request = session.newAdhocQuery(update);
        }
        try {
            session.submitRequest((Request)request);
            session.commit();
        }
        catch (RequestException e) {
            log.error(errorMsg != null ? errorMsg : "Error on update", (Throwable)e);
            throw new RepositoryException((Throwable)e);
        }
        finally {
            session.close();
        }
    }

    private static StrSubstitutor createStrSubstitutor(Map<String, String> values) {
        return new StrSubstitutor(values, PARAMETER_DELIMITER[0], PARAMETER_DELIMITER[1]);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = Integer.parseInt(port);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    private String cleanse(String workspace) {
        if (!(workspace = workspace.replace("\\", "/")).endsWith("/")) {
            return workspace + "/";
        }
        return workspace + "/";
    }

    private static class ParamsMap {
        private Map<String, String> params = new HashMap<String, String>();

        private ParamsMap() {
        }

        public static ParamsMap init() {
            return new ParamsMap();
        }

        public ParamsMap put(String key, String value) {
            this.params.put(key, value);
            return this;
        }

        public Map<String, String> build() {
            return this.params;
        }
    }
}

