/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.olap.util;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import mondrian.xmla.XmlaHandler;
import mondrian.xmla.XmlaRequest;
import mondrian.xmla.impl.Olap4jXmlaServlet;
import org.olap4j.OlapConnection;
import org.olap4j.OlapException;
import org.olap4j.impl.Olap4jUtil;
import org.olap4j.metadata.Database;
import org.saiku.datasources.connection.IConnectionManager;
import org.saiku.olap.util.exception.SaikuOlapException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SaikuXmlaServlet
extends Olap4jXmlaServlet {
    private static IConnectionManager connections;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        ServletContext context = this.getServletContext();
        WebApplicationContext applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)context);
        connections = (IConnectionManager)applicationContext.getBean("connectionManager");
    }

    protected XmlaHandler.ConnectionFactory createConnectionFactory(ServletConfig servletConfig) throws ServletException {
        return new XmlaHandler.ConnectionFactory(){
            private final XmlaHandler.XmlaExtra extra = new SaikuXmlaExtraImpl();

            public OlapConnection getConnection(String s, String s1, String s2, Properties properties) throws SQLException {
                try {
                    if (s != null) {
                        for (Map.Entry<String, OlapConnection> entry : connections.getAllOlapConnections().entrySet()) {
                            if (!entry.getKey().toLowerCase().equals(s.toLowerCase())) continue;
                            return entry.getValue();
                        }
                        return connections.getOlapConnection(s);
                    }
                    Iterator<Map.Entry<String, OlapConnection>> iterator = connections.getAllOlapConnections().entrySet().iterator();
                    if (iterator.hasNext()) {
                        Map.Entry<String, OlapConnection> entry = iterator.next();
                        return entry.getValue();
                    }
                }
                catch (SaikuOlapException e) {
                    e.printStackTrace();
                }
                return null;
            }

            public Map<String, Object> getPreConfiguredDiscoverDatasourcesResponse() {
                return null;
            }

            public XmlaHandler.Request startRequest(XmlaRequest xmlaRequest, OlapConnection olapConnection) {
                return null;
            }

            public void endRequest(XmlaHandler.Request request) {
            }

            public XmlaHandler.XmlaExtra getExtra() {
                return this.extra;
            }
        };
    }

    private Map<String, Object> getDataSources() {
        ArrayList lret = new ArrayList();
        try {
            Map<String, OlapConnection> conns = connections.getAllOlapConnections();
            Iterator<Map.Entry<String, OlapConnection>> iterator = conns.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry<String, OlapConnection> c = iterator.next();
                Database olapDb = c.getValue().getOlapDatabase();
                String modes = SaikuXmlaServlet.createCsv(olapDb.getAuthenticationModes());
                String providerTypes = SaikuXmlaServlet.createCsv(olapDb.getProviderTypes());
                List<Map> l = Collections.singletonList(Olap4jUtil.mapOf((Object)"DataSourceName", (Object)c.getKey(), (Object[])new Object[]{"DataSourceDescription", olapDb.getDescription(), "URL", olapDb.getURL(), "DataSourceInfo", olapDb.getDataSourceInfo(), "ProviderName", olapDb.getProviderName(), "ProviderType", providerTypes, "AuthenticationMode", modes}));
                return l.get(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static String createCsv(Iterable<? extends Object> iterable) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Object object : iterable) {
            if (!first) {
                sb.append(',');
            }
            sb.append(object);
            first = false;
        }
        return sb.toString();
    }

    private static class SaikuXmlaExtraImpl
    extends XmlaHandler.XmlaExtraImpl {
        private SaikuXmlaExtraImpl() {
        }

        public List<Map<String, Object>> getDataSources(OlapConnection connection) throws OlapException {
            ArrayList<Map<String, Object>> lret = new ArrayList<Map<String, Object>>();
            try {
                Map<String, OlapConnection> conns = connections.getAllOlapConnections();
                for (Map.Entry<String, OlapConnection> c : conns.entrySet()) {
                    Database olapDb = c.getValue().getOlapDatabase();
                    String modes = SaikuXmlaServlet.createCsv(olapDb.getAuthenticationModes());
                    String providerTypes = SaikuXmlaServlet.createCsv(olapDb.getProviderTypes());
                    List<Map> l = Collections.singletonList(Olap4jUtil.mapOf((Object)"DataSourceName", (Object)c.getKey(), (Object[])new Object[]{"DataSourceDescription", olapDb.getDescription(), "URL", olapDb.getURL(), "DataSourceInfo", olapDb.getDataSourceInfo(), "ProviderName", olapDb.getProviderName(), "ProviderType", providerTypes, "AuthenticationMode", modes}));
                    lret.addAll(l);
                }
                return lret;
            }
            catch (SaikuOlapException e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

