/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.olap.util;

import java.lang.reflect.Constructor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mondrian.olap.Annotation;
import mondrian.olap4j.Checker;
import mondrian.olap4j.LevelInterface;
import mondrian.olap4j.SaikuMondrianHelper;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.olap4j.Axis;
import org.olap4j.OlapException;
import org.olap4j.metadata.Cube;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.Measure;
import org.olap4j.metadata.Member;
import org.olap4j.metadata.MetadataElement;
import org.olap4j.metadata.NamedList;
import org.olap4j.query.QueryAxis;
import org.olap4j.query.QueryDimension;
import org.olap4j.query.Selection;
import org.saiku.olap.dto.SaikuAxis;
import org.saiku.olap.dto.SaikuCube;
import org.saiku.olap.dto.SaikuDimension;
import org.saiku.olap.dto.SaikuDimensionSelection;
import org.saiku.olap.dto.SaikuHierarchy;
import org.saiku.olap.dto.SaikuLevel;
import org.saiku.olap.dto.SaikuMeasure;
import org.saiku.olap.dto.SaikuMember;
import org.saiku.olap.dto.SaikuQuery;
import org.saiku.olap.dto.SaikuSelection;
import org.saiku.olap.dto.SimpleCubeElement;
import org.saiku.olap.query.IQuery;
import org.saiku.service.util.exception.SaikuServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectUtil.class);

    private ObjectUtil() {
    }

    @NotNull
    public static SaikuCube convert(String connection, @NotNull Cube c) {
        return new SaikuCube(connection, c.getUniqueName(), c.getName(), c.getCaption(), c.getSchema().getCatalog().getName(), c.getSchema().getName(), c.isVisible());
    }

    @NotNull
    public static SaikuDimension convert(@NotNull Dimension dim) {
        return new SaikuDimension(dim.getName(), dim.getUniqueName(), dim.getCaption(), dim.getDescription(), dim.isVisible(), ObjectUtil.convertHierarchies((List<Hierarchy>)dim.getHierarchies()));
    }

    @NotNull
    private static SaikuDimension convert(@NotNull QueryDimension dim) {
        return ObjectUtil.convert(dim.getDimension());
    }

    @NotNull
    public static List<SaikuDimension> convertQueryDimensions(@NotNull List<QueryDimension> dims) {
        ArrayList<SaikuDimension> dimList = new ArrayList<SaikuDimension>();
        for (QueryDimension d : dims) {
            dimList.add(ObjectUtil.convert(d));
        }
        return dimList;
    }

    @NotNull
    public static List<SaikuDimension> convertDimensions(@NotNull List<Dimension> dims) {
        ArrayList<SaikuDimension> dimList = new ArrayList<SaikuDimension>();
        for (Dimension d : dims) {
            dimList.add(ObjectUtil.convert(d));
        }
        return dimList;
    }

    @NotNull
    public static List<SaikuHierarchy> convertHierarchies(@NotNull List<Hierarchy> hierarchies) {
        ArrayList<SaikuHierarchy> hierarchyList = new ArrayList<SaikuHierarchy>();
        for (Hierarchy h : hierarchies) {
            hierarchyList.add(ObjectUtil.convert(h));
        }
        return hierarchyList;
    }

    @NotNull
    public static SaikuHierarchy convert(@NotNull Hierarchy hierarchy) {
        try {
            return new SaikuHierarchy(hierarchy.getName(), hierarchy.getUniqueName(), hierarchy.getCaption(), hierarchy.getDescription(), hierarchy.getDimension().getUniqueName(), hierarchy.isVisible(), ObjectUtil.convertLevels((List<Level>)hierarchy.getLevels()), ObjectUtil.convertMembers((Collection<Member>)hierarchy.getRootMembers()));
        }
        catch (OlapException e) {
            throw new SaikuServiceException("Cannot get root members", e);
        }
    }

    @NotNull
    public static List<SaikuLevel> convertLevels(@NotNull List<Level> levels) {
        ArrayList<SaikuLevel> levelList = new ArrayList<SaikuLevel>();
        for (Level l : levels) {
            levelList.add(ObjectUtil.convert(l));
        }
        return levelList;
    }

    @NotNull
    private static SaikuLevel convert(@NotNull Level level) {
        Checker c = new Checker();
        try {
            try {
                Class.forName("mondrian.olap4j.MondrianOlap4jLevelExtend");
                Class<?> _tempClass = Class.forName("mondrian.olap4j.MondrianOlap4jLevelExtend");
                if (c.checker(level)) {
                    Constructor<?> ctor = _tempClass.getDeclaredConstructor(Level.class);
                    LevelInterface test = (LevelInterface)ctor.newInstance(level);
                    HashMap<String, String> m = null;
                    if (test.getAnnotations() != null) {
                        m = new HashMap<String, String>();
                        for (Map.Entry entry : test.getAnnotations().entrySet()) {
                            m.put((String)entry.getKey(), (String)((Annotation)entry.getValue()).getValue());
                        }
                    }
                    return new SaikuLevel(test.getName(), test.getUniqueName(), test.getCaption(), test.getDescription(), test.getDimension().getUniqueName(), test.getHierarchy().getUniqueName(), test.isVisible(), test.getLevelType().toString(), m);
                }
                return new SaikuLevel(level.getName(), level.getUniqueName(), level.getCaption(), level.getDescription(), level.getDimension().getUniqueName(), level.getHierarchy().getUniqueName(), level.isVisible(), null, null);
            }
            catch (ClassNotFoundException e) {
                return new SaikuLevel(level.getName(), level.getUniqueName(), level.getCaption(), level.getDescription(), level.getDimension().getUniqueName(), level.getHierarchy().getUniqueName(), level.isVisible(), null, null);
            }
        }
        catch (Exception e) {
            throw new SaikuServiceException("Cannot convert level: " + level, e);
        }
    }

    @NotNull
    public static List<SaikuMember> convertMembers(@NotNull Collection<Member> members) {
        ArrayList<SaikuMember> memberList = new ArrayList<SaikuMember>();
        for (Member m : members) {
            memberList.add(ObjectUtil.convert(m));
        }
        return memberList;
    }

    @NotNull
    private static List<SaikuSelection> convertSelections(@NotNull List<Selection> selections, @NotNull QueryDimension dim, @NotNull IQuery query) {
        ArrayList<SaikuSelection> selectionList = new ArrayList<SaikuSelection>();
        for (Selection sel : selections) {
            selectionList.add(ObjectUtil.convert(sel, dim, query));
        }
        return selectionList;
    }

    private static Level getSelectionLevel(@NotNull Selection sel) {
        Level retVal = Level.class.isAssignableFrom(sel.getRootElement().getClass()) ? (Level)sel.getRootElement() : ((Member)sel.getRootElement()).getLevel();
        return retVal;
    }

    @NotNull
    private static SaikuSelection convert(@NotNull Selection sel, @NotNull QueryDimension dim, @NotNull IQuery query) {
        String levelUniqueName;
        String hierarchyUniqueName;
        SaikuSelection.Type type;
        Level level;
        if (Level.class.isAssignableFrom(sel.getRootElement().getClass())) {
            level = (Level)sel.getRootElement();
            type = SaikuSelection.Type.LEVEL;
            hierarchyUniqueName = ((Level)sel.getRootElement()).getHierarchy().getUniqueName();
            levelUniqueName = sel.getUniqueName();
        } else {
            level = ((Member)sel.getRootElement()).getLevel();
            type = SaikuSelection.Type.MEMBER;
            hierarchyUniqueName = ((Member)sel.getRootElement()).getHierarchy().getUniqueName();
            levelUniqueName = ((Member)sel.getRootElement()).getLevel().getUniqueName();
        }
        String totalsFunction = query.getTotalFunction(level.getUniqueName());
        List dimensions = dim.getAxis().getDimensions();
        QueryDimension lastDimension = (QueryDimension)dimensions.get(dimensions.size() - 1);
        Selection deepestSelection = null;
        int selectionDepth = -1;
        for (Selection selection : lastDimension.getInclusions()) {
            Level current = ObjectUtil.getSelectionLevel(selection);
            if (selectionDepth >= current.getDepth()) continue;
            deepestSelection = selection;
            selectionDepth = current.getDepth();
        }
        return new SaikuSelection(sel.getRootElement().getName(), sel.getUniqueName(), sel.getRootElement().getCaption(), sel.getRootElement().getDescription(), sel.getDimension().getName(), hierarchyUniqueName, levelUniqueName, type, totalsFunction, sel.equals(deepestSelection));
    }

    @NotNull
    public static SaikuMember convert(@NotNull Member m) {
        return new SaikuMember(m.getName(), m.getUniqueName(), m.getCaption(), m.getDescription(), m.getDimension().getUniqueName(), m.getHierarchy().getUniqueName(), m.getLevel().getUniqueName(), m.isCalculated());
    }

    @NotNull
    public static SaikuMeasure convertMeasure(@NotNull Measure m) {
        Map props2 = m.getProperties().asMap();
        NamedList props = m.getProperties();
        String f = SaikuMondrianHelper.getMeasureGroup((Measure)m);
        return new SaikuMeasure(m.getName(), m.getUniqueName(), m.getCaption(), m.getDescription(), m.getDimension().getUniqueName(), m.getHierarchy().getUniqueName(), m.getLevel().getUniqueName(), m.isVisible(), m.isCalculated() | m.isCalculatedInQuery(), f);
    }

    @NotNull
    public static SaikuDimensionSelection convertDimensionSelection(@NotNull QueryDimension dim, @NotNull IQuery query) {
        List<SaikuSelection> selections = ObjectUtil.convertSelections(dim.getInclusions(), dim, query);
        return new SaikuDimensionSelection(dim.getName(), dim.getDimension().getUniqueName(), dim.getDimension().getCaption(), dim.getDimension().getDescription(), selections);
    }

    @NotNull
    private static List<SaikuDimensionSelection> convertDimensionSelections(@NotNull List<QueryDimension> dimensions, @NotNull IQuery query) {
        ArrayList<SaikuDimensionSelection> dims = new ArrayList<SaikuDimensionSelection>();
        for (QueryDimension dim : dimensions) {
            dims.add(ObjectUtil.convertDimensionSelection(dim, query));
        }
        return dims;
    }

    @NotNull
    private static SaikuAxis convertQueryAxis(@NotNull QueryAxis axis, @NotNull IQuery query) {
        List<SaikuDimensionSelection> dims = ObjectUtil.convertDimensionSelections(axis.getDimensions(), query);
        Axis location = axis.getLocation();
        String so = axis.getSortOrder() == null ? null : axis.getSortOrder().name();
        SaikuAxis sax = new SaikuAxis(location.name(), location.axisOrdinal(), axis.getName(), dims, so, axis.getSortIdentifierNodeName(), query.getTotalFunction(axis.getName()));
        try {
            if (axis.getLimitFunction() != null) {
                sax.setLimitFunction(axis.getLimitFunction().toString());
                sax.setLimitFunctionN(axis.getLimitFunctionN().toPlainString());
                sax.setLimitFunctionSortLiteral(axis.getLimitFunctionSortLiteral());
            }
            if (StringUtils.isNotBlank((String)axis.getFilterCondition())) {
                sax.setFilterCondition(axis.getFilterCondition());
            }
        }
        catch (Error e) {
            LOG.error("Could not convert query axis", (Throwable)e);
        }
        return sax;
    }

    @NotNull
    public static SaikuQuery convert(@NotNull IQuery q) {
        ArrayList<SaikuAxis> axes = new ArrayList<SaikuAxis>();
        if (q.getType().equals((Object)IQuery.QueryType.QM)) {
            for (Axis axis : q.getAxes().keySet()) {
                if (axis == null) continue;
                axes.add(ObjectUtil.convertQueryAxis(q.getAxis(axis), q));
            }
        }
        return new SaikuQuery(q.getName(), q.getSaikuCube(), axes, q.getMdx(), q.getType().toString(), q.getProperties());
    }

    @NotNull
    public static List<SimpleCubeElement> convert2Simple(@Nullable Collection<? extends MetadataElement> mset) {
        ArrayList<SimpleCubeElement> elements = new ArrayList<SimpleCubeElement>();
        if (mset != null) {
            for (MetadataElement metadataElement : mset) {
                elements.add(new SimpleCubeElement(metadataElement.getName(), metadataElement.getUniqueName(), metadataElement.getCaption()));
            }
        }
        return elements;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static List<SimpleCubeElement> convert2simple(@Nullable ResultSet rs) {
        try {
            int width = 0;
            boolean first = true;
            ArrayList<SimpleCubeElement> elements = new ArrayList<SimpleCubeElement>();
            if (rs != null) {
                while (rs.next()) {
                    if (first) {
                        first = false;
                        width = rs.getMetaData().getColumnCount();
                    }
                    String[] row = new String[3];
                    for (int i = 0; i < width; ++i) {
                        row[i] = rs.getString(i + 1);
                    }
                    SimpleCubeElement s = new SimpleCubeElement(row[0], row[1], row[2]);
                    elements.add(s);
                }
            }
            ArrayList<SimpleCubeElement> arrayList = elements;
            return arrayList;
        }
        catch (Exception e) {
            throw new SaikuServiceException("Error converting ResultSet into SimpleCubeElement", e);
        }
        finally {
            if (rs != null) {
                Statement statement = null;
                Object con = null;
                try {
                    statement = rs.getStatement();
                }
                catch (Exception e) {
                    throw new SaikuServiceException(e);
                }
                finally {
                    try {
                        rs.close();
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (Exception ee) {
                        LOG.error("Could not close statement", (Throwable)ee);
                    }
                    rs = null;
                }
            }
        }
    }
}

