/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.olap.query;

import java.util.Map;
import java.util.Properties;
import org.olap4j.Axis;
import org.saiku.olap.query.OlapQuery;

public class QueryProperties {
    private static final String KEY_NONEMPTY = "saiku.olap.query.nonempty";
    private static final String KEY_NONEMPTY_ROWS = "saiku.olap.query.nonempty.rows";
    private static final String KEY_NONEMPTY_COLUMNS = "saiku.olap.query.nonempty.columns";
    public static final String KEY_IS_DRILLTHROUGH = "saiku.olap.query.drillthrough";
    private static final String KEY_SUPPORTS_LIMIT = "saiku.olap.query.limit";
    private static final String KEY_SUPPORTS_FILTER = "saiku.olap.query.filter";
    private static final String[] KEYS = new String[]{"saiku.olap.query.nonempty", "saiku.olap.query.nonempty.rows", "saiku.olap.query.nonempty.columns", "saiku.olap.query.drillthrough", "saiku.olap.query.limit", "saiku.olap.query.filter"};

    public static class QueryPropertyFactory {
        private static final QueryProperties q = new QueryProperties();

        public static QueryProperty getProperty(String key, String value, OlapQuery query) {
            if (QueryProperties.KEY_NONEMPTY_ROWS.equals(key)) {
                QueryProperties queryProperties = q;
                queryProperties.getClass();
                return queryProperties.new NonEmptyRowsProperty(query, key, value);
            }
            if (QueryProperties.KEY_NONEMPTY_COLUMNS.equals(key)) {
                QueryProperties queryProperties = q;
                queryProperties.getClass();
                return queryProperties.new NonEmptyColumnsProperty(query, key, value);
            }
            if (QueryProperties.KEY_NONEMPTY.equals(key)) {
                QueryProperties queryProperties = q;
                queryProperties.getClass();
                return queryProperties.new NonEmptyProperty(query, key, value);
            }
            if (QueryProperties.KEY_IS_DRILLTHROUGH.equals(key)) {
                QueryProperties queryProperties = q;
                queryProperties.getClass();
                return queryProperties.new IsDrillthroughProperty(query, key, value);
            }
            if (QueryProperties.KEY_SUPPORTS_LIMIT.equals(key)) {
                QueryProperties queryProperties = q;
                queryProperties.getClass();
                return queryProperties.new SupportsLimitProperty(query, key, value);
            }
            if (QueryProperties.KEY_SUPPORTS_FILTER.equals(key)) {
                QueryProperties queryProperties = q;
                queryProperties.getClass();
                return queryProperties.new SupportsFilterProperty(query, key, value);
            }
            QueryProperties queryProperties = q;
            queryProperties.getClass();
            return queryProperties.new DummyProperty(query, key, value);
        }

        public static Properties forQuery(OlapQuery query) {
            Properties props = new Properties();
            for (String key : KEYS) {
                props.putAll((Map<?, ?>)QueryPropertyFactory.getProperty(key, null, query).getProperties());
            }
            return props;
        }
    }

    public class SupportsFilterProperty
    extends QueryProperty {
        public SupportsFilterProperty(OlapQuery query, String key, String value) {
            super(query, key, value);
        }

        @Override
        public void handle() {
        }

        @Override
        public Properties getProperties() {
            Properties props = new Properties();
            String key = this.key;
            String value = Boolean.FALSE.toString();
            try {
                this.query.getAxis((Axis)Axis.COLUMNS).getFilterCondition();
                value = Boolean.TRUE.toString();
            }
            catch (Error error) {
                // empty catch block
            }
            props.put(key, value);
            return props;
        }
    }

    public class SupportsLimitProperty
    extends QueryProperty {
        public SupportsLimitProperty(OlapQuery query, String key, String value) {
            super(query, key, value);
        }

        @Override
        public void handle() {
        }

        @Override
        public Properties getProperties() {
            Properties props = new Properties();
            String key = this.key;
            String value = Boolean.FALSE.toString();
            try {
                this.query.getAxis((Axis)Axis.COLUMNS).getLimitFunction();
                value = Boolean.TRUE.toString();
            }
            catch (Error error) {
                // empty catch block
            }
            props.put(key, value);
            return props;
        }
    }

    public class IsDrillthroughProperty
    extends QueryProperty {
        public IsDrillthroughProperty(OlapQuery query, String key, String value) {
            super(query, key, value);
        }

        @Override
        public void handle() {
        }

        @Override
        public Properties getProperties() {
            Properties props = new Properties();
            String key = this.key;
            String value = Boolean.toString(this.query.isDrillThroughEnabled());
            props.put(key, value);
            return props;
        }
    }

    public class NonEmptyColumnsProperty
    extends QueryProperty {
        public NonEmptyColumnsProperty(OlapQuery query, String key, String value) {
            super(query, key, value);
        }

        @Override
        public void handle() {
            Boolean nonEmpty = Boolean.parseBoolean(this.value);
            this.query.getAxis((Axis)Axis.COLUMNS).setNonEmpty(nonEmpty.booleanValue());
        }

        @Override
        public Properties getProperties() {
            String key = this.key;
            String value = Boolean.toString(this.query.getAxis((Axis)Axis.COLUMNS).isNonEmpty());
            Properties props = new Properties();
            props.put(key, value);
            return props;
        }
    }

    public class NonEmptyProperty
    extends QueryProperty {
        public NonEmptyProperty(OlapQuery query, String key, String value) {
            super(query, key, value);
        }

        @Override
        public void handle() {
            Boolean nonEmpty = Boolean.parseBoolean(this.value);
            this.query.getAxis((Axis)Axis.ROWS).setNonEmpty(nonEmpty.booleanValue());
            this.query.getAxis((Axis)Axis.COLUMNS).setNonEmpty(nonEmpty.booleanValue());
        }

        @Override
        public Properties getProperties() {
            String key = this.key;
            String value = Boolean.toString(this.query.getAxis((Axis)Axis.COLUMNS).isNonEmpty() && this.query.getAxis((Axis)Axis.ROWS).isNonEmpty());
            Properties props = new Properties();
            props.put(key, value);
            return props;
        }
    }

    public class NonEmptyRowsProperty
    extends QueryProperty {
        public NonEmptyRowsProperty(OlapQuery query, String key, String value) {
            super(query, key, value);
        }

        @Override
        public void handle() {
            Boolean nonEmpty = Boolean.parseBoolean(this.value);
            this.query.getAxis((Axis)Axis.ROWS).setNonEmpty(nonEmpty.booleanValue());
        }

        @Override
        public Properties getProperties() {
            String key = this.key;
            String value = Boolean.toString(this.query.getAxis((Axis)Axis.ROWS).isNonEmpty());
            Properties props = new Properties();
            props.put(key, value);
            return props;
        }
    }

    public class DummyProperty
    extends QueryProperty {
        public DummyProperty(OlapQuery query, String key, String value) {
            super(query, key, value);
        }

        @Override
        public void handle() {
        }

        @Override
        public Properties getProperties() {
            return new Properties();
        }
    }

    public abstract class QueryProperty {
        final String key;
        final String value;
        final OlapQuery query;

        public QueryProperty(OlapQuery query, String key, String value) {
            this.key = key;
            this.value = value;
            this.query = query;
        }

        public abstract void handle();

        public abstract Properties getProperties();
    }
}

