/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.olap.dto;

import java.util.ArrayList;
import java.util.List;
import org.saiku.olap.dto.AbstractSaikuObject;
import org.saiku.olap.dto.SaikuDimensionSelection;
import org.saiku.olap.dto.SaikuMember;
import org.saiku.olap.dto.SaikuTuple;
import org.saiku.olap.dto.SimpleCubeElement;

public class SaikuTag
extends AbstractSaikuObject {
    private List<SaikuTuple> saikuTuples;
    private String name;
    private List<SimpleCubeElement> saikuTupleDimensions;
    private List<SaikuDimensionSelection> saikuDimensionSelections;

    public SaikuTag() {
    }

    public SaikuTag(String name, List<SimpleCubeElement> saikuTupleDimensions, List<SaikuTuple> saikuTuples, List<SaikuDimensionSelection> filterSelections) {
        super(name, name);
        this.saikuTuples = saikuTuples;
        this.name = name;
        this.saikuTupleDimensions = saikuTupleDimensions;
        this.saikuDimensionSelections = filterSelections;
    }

    public List<SaikuMember> getSaikuMembers(String dimensionUniqueName) {
        ArrayList<SaikuMember> members = new ArrayList<SaikuMember>();
        for (SaikuTuple t : this.saikuTuples) {
            for (SaikuMember m : t.getSaikuMembers()) {
                if (!m.getDimensionUniqueName().equals(dimensionUniqueName)) continue;
                members.add(m);
            }
        }
        return members;
    }

    public List<SaikuTuple> getSaikuTuples() {
        return this.saikuTuples;
    }

    public List<SimpleCubeElement> getSaikuTupleDimensions() {
        return this.saikuTupleDimensions;
    }

    public List<SaikuDimensionSelection> getSaikuDimensionSelections() {
        return this.saikuDimensionSelections;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

