/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.datasources.connection.encrypt;

import org.saiku.datasources.connection.encrypt.Des;
import org.springframework.dao.DataAccessException;

class TripleDesPasswordEncoder {
    private static final byte[] defaultKey1 = new byte[]{-87, -87, 15, -76, 87, 17, -115, 44};
    private static final byte[] defaultKey2 = new byte[]{44, 44, -12, 92, 117, 21, -58, -93};
    private Des des;

    TripleDesPasswordEncoder() {
    }

    public String encode(String rawPass) throws DataAccessException {
        Object salt = null;
        if (rawPass.length() == 0) {
            return rawPass;
        }
        int length = rawPass.length() + 1;
        if (length % 8 != 0) {
            length = length / 8 * 8 + 8;
        }
        byte[] source = rawPass.getBytes();
        byte[] digest = new byte[length];
        System.arraycopy(source, 0, digest, 0, source.length);
        this.setKeys(true, salt);
        this.getEncoder().Crypt(digest);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int temp = digest[i] & 0xFF;
            if (temp < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(temp));
        }
        return sb.toString();
    }

    private void setKeys(boolean encrypt, Object timestamp) {
        this.getEncoder().SetKey(encrypt, defaultKey1, defaultKey2);
    }

    private Des getEncoder() {
        if (this.des == null) {
            this.des = new Des();
        }
        return this.des;
    }
}

