/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.datasources.connection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.olap4j.OlapConnection;
import org.saiku.datasources.connection.IConnectionManager;
import org.saiku.datasources.connection.IConnectionProcessor;
import org.saiku.datasources.connection.ISaikuConnection;
import org.saiku.datasources.datasource.SaikuDatasource;
import org.saiku.olap.util.exception.SaikuOlapException;
import org.saiku.service.datasource.IDatasourceManager;
import org.saiku.service.datasource.IDatasourceProcessor;
import org.saiku.service.user.UserService;
import org.saiku.service.util.exception.SaikuServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConnectionManager
implements IConnectionManager,
Serializable {
    private static final long serialVersionUID = 4735617922513789022L;
    private static final Logger log = LoggerFactory.getLogger(AbstractConnectionManager.class);
    private transient IDatasourceManager ds;
    private UserService userService;
    private transient List<IDatasourceProcessor> dsProcessors;

    @Override
    public void setDataSourceManager(IDatasourceManager ds) {
        this.ds = ds;
    }

    @Override
    public IDatasourceManager getDataSourceManager() {
        return this.ds;
    }

    public void setDataSourceProcessors(List<IDatasourceProcessor> processors) {
        this.dsProcessors = processors;
    }

    public List<IDatasourceProcessor> getDataSourceProcessors() {
        return this.dsProcessors;
    }

    @Override
    public abstract void init() throws SaikuOlapException;

    public void destroy() throws SaikuOlapException {
        Map<String, OlapConnection> connections = this.getAllOlapConnections();
        if (connections != null && !connections.isEmpty()) {
            for (OlapConnection con : connections.values()) {
                try {
                    if (con.isClosed()) continue;
                    con.close();
                }
                catch (Exception e) {
                    log.error("Could not close connection", (Throwable)e);
                }
            }
        }
        if (connections != null) {
            connections.clear();
        }
        log.info("Do we still have connections? : " + this.getAllOlapConnections().size());
    }

    private SaikuDatasource preProcess(SaikuDatasource datasource) {
        if (datasource != null && datasource.getProperties().containsKey("datasource.processors")) {
            String[] processors;
            datasource = datasource.clone();
            for (String processor : processors = datasource.getProperties().getProperty("datasource.processors").split(",")) {
                try {
                    Class<?> clazz = Class.forName(processor);
                    Constructor<?> ctor = clazz.getConstructor(new Class[0]);
                    IDatasourceProcessor dsProcessor = (IDatasourceProcessor)ctor.newInstance(new Object[0]);
                    datasource = dsProcessor.process(datasource);
                }
                catch (Exception e) {
                    throw new SaikuServiceException("Error applying DatasourceProcessor \"" + processor + "\"", e);
                }
            }
        }
        return datasource;
    }

    private ISaikuConnection postProcess(SaikuDatasource datasource, ISaikuConnection con) {
        String[] processors;
        String[] stringArray;
        int n;
        int n2;
        if (datasource != null && datasource.getProperties().containsKey("connection.processors") && (n2 = 0) < (n = (stringArray = (processors = (datasource = datasource.clone()).getProperties().getProperty("connection.processors").split(","))).length)) {
            String processor = stringArray[n2];
            try {
                Class<?> clazz = Class.forName(processor);
                Constructor<?> ctor = clazz.getConstructor(new Class[0]);
                IConnectionProcessor conProcessor = (IConnectionProcessor)ctor.newInstance(new Object[0]);
                return conProcessor.process(con);
            }
            catch (Exception e) {
                throw new SaikuServiceException("Error applying ConnectionProcessor \"" + processor + "\"", e);
            }
        }
        return con;
    }

    @Override
    public ISaikuConnection getConnection(String name) throws SaikuOlapException {
        SaikuDatasource datasource = this.ds.getDatasource(name, false);
        datasource = this.preProcess(datasource);
        ISaikuConnection con = this.getInternalConnection(name, datasource);
        con = this.postProcess(datasource, con);
        return con;
    }

    protected abstract ISaikuConnection getInternalConnection(String var1, SaikuDatasource var2) throws SaikuOlapException;

    protected abstract ISaikuConnection refreshInternalConnection(String var1, SaikuDatasource var2);

    @Override
    public void refreshAllConnections() {
        if (this.ds == null) {
            return;
        }
        this.ds.load();
        String[] userRoles = new String[]{};
        if (this.userService != null && this.userService.getCurrentUserRoles() != null) {
            userRoles = this.userService.getCurrentUserRoles();
        }
        for (String name : this.ds.getDatasources(userRoles).keySet()) {
            try {
                this.refreshConnection(name);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void refreshConnection(String name) {
        SaikuDatasource datasource = this.ds.getDatasource(name);
        datasource = this.preProcess(datasource);
        ISaikuConnection con = this.refreshInternalConnection(name, datasource);
        con = this.postProcess(datasource, con);
    }

    @Override
    public Map<String, ISaikuConnection> getAllConnections() throws SaikuOlapException {
        HashMap<String, ISaikuConnection> resultDs = new HashMap<String, ISaikuConnection>();
        String[] roles = new String[]{};
        if (this.userService != null && this.userService.getCurrentUserRoles() != null) {
            roles = this.userService.getCurrentUserRoles();
        }
        for (String name : this.ds.getDatasources(roles).keySet()) {
            ISaikuConnection con = this.getConnection(name);
            if (con == null) continue;
            resultDs.put(name, con);
        }
        return resultDs;
    }

    @Override
    public OlapConnection getOlapConnection(String name) throws SaikuOlapException {
        Connection o;
        ISaikuConnection con = this.getConnection(name);
        if (con != null && (o = con.getConnection()) != null && o instanceof OlapConnection) {
            return (OlapConnection)o;
        }
        return null;
    }

    @Override
    public Map<String, OlapConnection> getAllOlapConnections() throws SaikuOlapException {
        Map<String, ISaikuConnection> connections = this.getAllConnections();
        HashMap<String, OlapConnection> ocons = new HashMap<String, OlapConnection>();
        for (ISaikuConnection con : connections.values()) {
            Connection o = con.getConnection();
            if (o == null || !(o instanceof OlapConnection)) continue;
            ocons.put(con.getName(), (OlapConnection)o);
        }
        return ocons;
    }

    protected boolean isDatasourceSecurity(SaikuDatasource datasource, String value) {
        Properties props;
        if (datasource != null && value != null && (props = datasource.getProperties()) != null && this.isDatasourceSecurityEnabled(datasource) && props.containsKey("security.type")) {
            return props.getProperty("security.type").equals(value);
        }
        return false;
    }

    protected boolean isDatasourceSecurityEnabled(SaikuDatasource datasource) {
        Properties props;
        if (datasource != null && (props = datasource.getProperties()) != null && props.containsKey("security.enabled")) {
            String enabled = props.getProperty("security.enabled", "false");
            return Boolean.parseBoolean(enabled);
        }
        return false;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }
}

