/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.database;

import jakarta.servlet.ServletContext;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import org.apache.commons.lang3.ArrayUtils;
import org.saiku.UserDAO;
import org.saiku.database.dto.SaikuUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.support.JdbcDaoSupport;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

public class JdbcUserDAO
extends JdbcDaoSupport
implements UserDAO {
    private final Properties prop = new Properties();
    private final ClassLoader loader = Thread.currentThread().getContextClassLoader();
    private final BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
    @Autowired
    private ServletContext servletContext;

    public JdbcUserDAO() {
        InputStream stream = this.loader.getResourceAsStream("../database-queries.properties");
        try {
            this.prop.load(stream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public SaikuUser insert(SaikuUser user) {
        String sql = this.prop.getProperty("insertUser");
        String encrypt = this.servletContext.getInitParameter("db.encryptpassword");
        if (encrypt.equals("true")) {
            user.setPassword(this.passwordEncoder.encode((CharSequence)user.getPassword()));
        }
        String newsql = this.prop.getProperty("maxUser");
        this.getJdbcTemplate().update(sql, new Object[]{user.getUsername(), user.getPassword(), user.getEmail(), true});
        Integer name = (Integer)this.getJdbcTemplate().queryForObject(newsql, new Object[]{user.getUsername()}, Integer.class);
        String updatesql = this.prop.getProperty("updateRole");
        Object[] roles = user.getRoles();
        Object[] roles2 = new String[]{"ROLE_USER"};
        String[] both = (String[])ArrayUtils.addAll((Object[])roles2, (Object[])roles);
        user.setRoles(both);
        this.getJdbcTemplate().update(updatesql, new Object[]{name, user.getId()});
        user.setId(name);
        this.insertRole(user);
        return user;
    }

    @Override
    public void insertRole(SaikuUser user) {
        String sql = this.prop.getProperty("insertRole");
        String removeSQL = this.prop.getProperty("deleteRole");
        this.getJdbcTemplate().update(removeSQL, new Object[]{user.getId()});
        if (user.getRoles() != null) {
            for (String r : user.getRoles()) {
                if (r == null || r.equals("")) continue;
                this.getJdbcTemplate().update(sql, new Object[]{user.getId(), user.getUsername(), r});
            }
        }
    }

    @Override
    public void deleteUser(SaikuUser user) {
        String sql = this.prop.getProperty("deleteRoleByUserName");
        String sql2 = this.prop.getProperty("deleteUserByUserName");
        this.getJdbcTemplate().update(sql, new Object[]{user.getUsername()});
        this.getJdbcTemplate().update(sql2, new Object[]{user.getUsername()});
    }

    @Override
    public void deleteRole(SaikuUser user) {
        String role = "";
        String sql = this.prop.getProperty("deleteRoleByRoleAndUser");
        this.getJdbcTemplate().update(sql, new Object[]{user.getId(), role});
    }

    @Override
    public String[] getRoles(SaikuUser user) {
        String sql = this.prop.getProperty("getRole");
        String roles = (String)this.getJdbcTemplate().queryForObject(sql, new Object[]{user.getId()}, String.class);
        if (roles != null) {
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(roles.split(",")));
            String[] stockArr = new String[list.size()];
            return list.toArray(stockArr);
        }
        return null;
    }

    @Override
    public SaikuUser findByUserId(int userId) {
        return (SaikuUser)this.getJdbcTemplate().query(this.prop.getProperty("getUserById"), new Object[]{userId}, (RowMapper)new UserMapper()).get(0);
    }

    @Override
    public Collection findAllUsers() {
        return this.getJdbcTemplate().query(this.prop.getProperty("getAllUsers"), (RowMapper)new UserMapper());
    }

    @Override
    public void deleteUser(String username) {
        String sql = this.prop.getProperty("deleteRoleByUserId");
        String newsql = this.prop.getProperty("deleteUserById");
        this.getJdbcTemplate().update(sql, new Object[]{username});
        this.getJdbcTemplate().update(newsql, new Object[]{username});
    }

    @Override
    public SaikuUser updateUser(SaikuUser user, boolean updatepassword) {
        String sql = updatepassword ? this.prop.getProperty("updateUserWithPassword") : this.prop.getProperty("updateUser");
        String newsql = this.prop.getProperty("maxUser");
        String encrypt = this.servletContext.getInitParameter("db.encryptpassword");
        if (updatepassword) {
            if (encrypt.equals("true")) {
                user.setPassword(this.passwordEncoder.encode((CharSequence)user.getPassword()));
            }
            this.getJdbcTemplate().update(sql, new Object[]{user.getUsername(), user.getPassword(), user.getEmail(), true, user.getId()});
        } else {
            this.getJdbcTemplate().update(sql, new Object[]{user.getUsername(), user.getEmail(), true, user.getId()});
        }
        Integer name = (Integer)this.getJdbcTemplate().queryForObject(newsql, new Object[]{user.getUsername()}, Integer.class);
        String updatesql = this.prop.getProperty("updateRole");
        this.getJdbcTemplate().update(updatesql, new Object[]{name, user.getId()});
        user.setId(name);
        this.insertRole(user);
        return user;
    }

    @Override
    public void updateRoles(SaikuUser user) {
        this.insertRole(user);
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    private static final class UserMapper
    implements RowMapper {
        private UserMapper() {
        }

        public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
            SaikuUser user = new SaikuUser();
            user.setId(rs.getInt("user_id"));
            user.setUsername(rs.getString("username"));
            user.setEmail(rs.getString("email"));
            user.setPassword(rs.getString("password"));
            if (rs.getString("ROLES") != null) {
                ArrayList<String> list = new ArrayList<String>(Arrays.asList(rs.getString("ROLES").split(",")));
                String[] stockArr = new String[list.size()];
                stockArr = list.toArray(stockArr);
                user.setRoles(stockArr);
            }
            return user;
        }
    }
}

