/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.query.mdx;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.olap4j.mdx.LiteralNode;
import org.olap4j.mdx.ParseTreeNode;
import org.olap4j.mdx.parser.MdxParser;
import org.saiku.query.mdx.AbstractFilterFunction;
import org.saiku.query.mdx.IFilterFunction;

public class NFilter
extends AbstractFilterFunction {
    private String filterExpression;
    private int n;
    private IFilterFunction.MdxFunctionType type;

    public NFilter(IFilterFunction.MdxFunctionType type, int n, String filterExpression) {
        if (IFilterFunction.MdxFunctionType.Filter.equals((Object)type)) {
            throw new IllegalArgumentException("Cannot use Filter() as TopN Filter");
        }
        this.filterExpression = filterExpression;
        this.n = n;
        this.type = type;
    }

    public int getN() {
        return this.n;
    }

    public String getFilterExpression() {
        return this.filterExpression;
    }

    @Override
    public List<ParseTreeNode> getArguments(MdxParser parser) {
        ArrayList<ParseTreeNode> arguments = new ArrayList<ParseTreeNode>();
        LiteralNode nfilter = LiteralNode.createNumeric(null, (BigDecimal)new BigDecimal(this.n), (boolean)false);
        arguments.add((ParseTreeNode)nfilter);
        if (this.filterExpression != null) {
            ParseTreeNode topn = parser.parseExpression(this.filterExpression);
            arguments.add(topn);
        }
        return arguments;
    }

    @Override
    public IFilterFunction.MdxFunctionType getFunctionType() {
        return this.type;
    }
}

