/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.query;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.olap4j.OlapException;
import org.olap4j.impl.IdentifierParser;
import org.olap4j.impl.Named;
import org.olap4j.impl.NamedListImpl;
import org.olap4j.mdx.IdentifierSegment;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.Member;
import org.olap4j.metadata.NamedList;
import org.saiku.query.AbstractSortableQuerySet;
import org.saiku.query.Query;
import org.saiku.query.QueryAxis;
import org.saiku.query.QueryLevel;
import org.saiku.query.RootMember;
import org.saiku.query.metadata.CalculatedMember;

public class QueryHierarchy
extends AbstractSortableQuerySet
implements Named {
    private final NamedList<RootMember> rootMembers = new NamedListImpl();
    protected QueryAxis axis;
    private final Query query;
    private final Hierarchy hierarchy;
    private NamedList<QueryLevel> queryLevels = new NamedListImpl();
    private NamedList<QueryLevel> activeLevels = new NamedListImpl();
    private NamedList<CalculatedMember> calculatedMembers = new NamedListImpl();
    private NamedList<CalculatedMember> activeCalculatedMembers = new NamedListImpl();
    private boolean consistent = true;
    private boolean visualTotals = false;
    private String visualTotalsPattern;

    public QueryHierarchy(Query query, Hierarchy hierarchy) {
        this.query = query;
        this.hierarchy = hierarchy;
        for (Level level : hierarchy.getLevels()) {
            QueryLevel queryLevel = new QueryLevel(this, level);
            this.queryLevels.add((Object)queryLevel);
        }
        try {
            NamedList members = hierarchy.getRootMembers();
            for (Member member : members) {
                RootMember rootMember = new RootMember(this, member);
                this.rootMembers.add((Object)rootMember);
            }
        }
        catch (OlapException e) {
            e.printStackTrace();
        }
    }

    public Query getQuery() {
        return this.query;
    }

    public QueryAxis getAxis() {
        return this.axis;
    }

    protected void setAxis(QueryAxis axis) {
        this.axis = axis;
    }

    @Override
    public String getName() {
        return this.hierarchy.getName();
    }

    public String getUniqueName() {
        return this.hierarchy.getUniqueName();
    }

    public String getCaption() {
        return this.hierarchy.getCaption();
    }

    public boolean isConsistent() {
        return this.consistent;
    }

    public void setConsistent(boolean consistent) {
        this.consistent = consistent;
    }

    public boolean isVisualTotals() {
        return this.visualTotals | this.query.isVisualTotals();
    }

    public void setVisualTotals(boolean visualTotals) {
        this.visualTotals = visualTotals;
        if (!visualTotals) {
            this.visualTotalsPattern = null;
        }
    }

    public void setVisualTotalsPattern(String pattern) {
        this.visualTotalsPattern = pattern;
        this.visualTotals = true;
    }

    public String getVisualTotalsPattern() {
        return this.visualTotalsPattern == null ? this.query.getVisualTotalsPattern() : this.visualTotalsPattern;
    }

    public boolean needsHierarchize() {
        return this.visualTotals | this.activeLevels.size() > 1 && this.getHierarchizeMode() == null;
    }

    public Hierarchy getHierarchy() {
        return this.hierarchy;
    }

    public void addCalculatedMember(CalculatedMember cm) {
        this.calculatedMembers.add((Object)cm);
    }

    public NamedList<CalculatedMember> getCalculatedMembers() {
        return this.calculatedMembers;
    }

    public List<CalculatedMember> getActiveCalculatedMembers() {
        return this.activeCalculatedMembers;
    }

    public List<QueryLevel> getActiveQueryLevels() {
        Collections.sort(this.activeLevels, new SaikuQueryLevelComparator());
        return this.activeLevels;
    }

    public QueryLevel getActiveLevel(String levelName) {
        return (QueryLevel)this.activeLevels.get(levelName);
    }

    public QueryLevel includeLevel(String levelName) {
        QueryLevel ql = (QueryLevel)this.queryLevels.get(levelName);
        if (ql != null && !this.activeLevels.contains((Object)ql)) {
            this.activeLevels.add((Object)ql);
        }
        return ql;
    }

    public QueryLevel includeMemberLevel(String levelName) {
        QueryLevel ql = (QueryLevel)this.queryLevels.get(levelName);
        if (ql != null && !this.activeLevels.contains((Object)ql)) {
            this.activeLevels.add((Object)ql);
        }
        return ql;
    }

    public QueryLevel includeLevel(Level l) throws OlapException {
        if (!l.getHierarchy().equals(this.hierarchy)) {
            throw new OlapException("You cannot include level " + l.getUniqueName() + " on hierarchy " + this.hierarchy.getUniqueName());
        }
        QueryLevel ql = (QueryLevel)this.queryLevels.get(l.getName());
        if (ql != null && !this.activeLevels.contains((Object)l)) {
            this.activeLevels.add((Object)ql);
        }
        return ql;
    }

    public void excludeLevel(String levelName) {
        QueryLevel ql = (QueryLevel)this.queryLevels.get(levelName);
        if (ql != null && this.activeLevels.contains((Object)ql)) {
            this.activeLevels.remove((Object)ql);
        }
    }

    public void excludeLevel(Level l) throws OlapException {
        QueryLevel ql = (QueryLevel)this.queryLevels.get(l.getName());
        if (ql != null && !this.activeLevels.contains((Object)l)) {
            this.activeLevels.remove((Object)ql);
        }
    }

    public void includeMembers(List<Member> members) throws OlapException {
        for (Member m : members) {
            this.includeMember(m);
        }
    }

    public void includeMember(String uniqueMemberName) throws OlapException {
        List nameParts = IdentifierParser.parseIdentifier((String)uniqueMemberName);
        this.includeMember(nameParts);
    }

    public void includeMember(List<IdentifierSegment> nameParts) throws OlapException {
        Member member = this.query.getCube().lookupMember(nameParts);
        if (member == null) {
            throw new OlapException("Unable to find a member with name " + nameParts);
        }
        this.includeMember(member);
    }

    public void includeCalculatedMember(CalculatedMember m, boolean include) throws OlapException {
        Hierarchy h = m.getHierarchy();
        if (!h.equals(this.hierarchy)) {
            throw new OlapException("You cannot include the calculated member " + m.getUniqueName() + " on hierarchy " + this.hierarchy.getUniqueName());
        }
        if (!this.calculatedMembers.contains((Object)m)) {
            this.calculatedMembers.add((Object)m);
        }
        if (include) {
            QueryLevel ql = (QueryLevel)this.queryLevels.get(m.getLevel().getName());
            ql.include(m);
        } else {
            this.activeCalculatedMembers.add((Object)m);
        }
    }

    public void excludeCalculatedMember(CalculatedMember m) throws OlapException {
        this.activeCalculatedMembers.remove((Object)m);
    }

    public void includeMember(Member m) throws OlapException {
        Level l = m.getLevel();
        if (!l.getHierarchy().equals(this.hierarchy)) {
            throw new OlapException("You cannot include member " + m.getUniqueName() + " on hierarchy " + this.hierarchy.getUniqueName());
        }
        QueryLevel ql = (QueryLevel)this.queryLevels.get(l.getName());
        if (!this.activeLevels.contains((Object)ql)) {
            this.activeLevels.add((Object)ql);
        }
        ql.include(m);
    }

    public void includeRange(String uniqueMemberNameStart, String uniqueMemberNameEnd) throws OlapException {
        List namePartsStart = IdentifierParser.parseIdentifier((String)uniqueMemberNameStart);
        List namePartsEnd = IdentifierParser.parseIdentifier((String)uniqueMemberNameEnd);
        this.includeRange(namePartsStart, namePartsEnd);
    }

    public void includeRange(List<IdentifierSegment> namePartsStart, List<IdentifierSegment> namePartsEnd) throws OlapException {
        Member rangeStart = this.query.getCube().lookupMember(namePartsStart);
        Member rangeEnd = this.query.getCube().lookupMember(namePartsEnd);
        if (rangeStart == null) {
            throw new OlapException("Unable to find a member with name " + rangeStart);
        }
        if (rangeEnd == null) {
            throw new OlapException("Unable to find a member with name " + rangeEnd);
        }
        this.includeRange(rangeStart, rangeEnd);
    }

    public void includeRange(Member start, Member end) throws OlapException {
        Level l = start.getLevel();
        if (!start.getLevel().equals(end.getLevel())) {
            throw new OlapException("A range selection must include members from the same level (" + start.getLevel().getName() + " vs. " + end.getLevel().getName());
        }
        if (!l.getHierarchy().equals(this.hierarchy)) {
            throw new OlapException("Hierarchy not matching. You cannot include a range selection for " + start.getUniqueName() + " and " + end.getUniqueName() + " on hierarchy " + this.hierarchy.getUniqueName());
        }
        QueryLevel ql = (QueryLevel)this.queryLevels.get(l.getName());
        if (!this.activeLevels.contains((Object)ql)) {
            this.activeLevels.add((Object)ql);
        }
        ql.setRange(start, end);
    }

    public void excludeMember(String uniqueMemberName) throws OlapException {
        List nameParts = IdentifierParser.parseIdentifier((String)uniqueMemberName);
        this.excludeMember(nameParts);
    }

    public void excludeMember(List<IdentifierSegment> nameParts) throws OlapException {
        Member member = this.query.getCube().lookupMember(nameParts);
        if (member == null) {
            throw new OlapException("Unable to find a member with name " + nameParts);
        }
        this.excludeMember(member);
    }

    public void excludeMembers(List<Member> members) {
        for (Member m : members) {
            this.excludeMember(m);
        }
    }

    public void excludeMember(Member m) {
        Level l = m.getLevel();
        if (!l.getHierarchy().equals(this.hierarchy)) {
            throw new IllegalArgumentException("You cannot exclude member " + m.getUniqueName() + " on hierarchy " + this.hierarchy.getUniqueName());
        }
        QueryLevel ql = (QueryLevel)this.queryLevels.get(l.getName());
        if (!this.activeLevels.contains((Object)ql)) {
            this.activeLevels.add((Object)ql);
        }
        ql.exclude(m);
    }

    public void clearSelection() {
        if (this.activeLevels != null) {
            for (QueryLevel ql : this.activeLevels) {
                ql.clearSelections();
            }
        }
        this.activeLevels.clear();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.hierarchy == null ? 0 : this.hierarchy.getUniqueName().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QueryHierarchy other = (QueryHierarchy)obj;
        return !(this.hierarchy == null ? other.hierarchy != null : !this.hierarchy.getUniqueName().equals(other.hierarchy.getUniqueName()));
    }

    public String toString() {
        return this.hierarchy.getUniqueName();
    }

    private class SaikuQueryLevelComparator
    implements Comparator<QueryLevel> {
        private SaikuQueryLevelComparator() {
        }

        @Override
        public int compare(QueryLevel o1, QueryLevel o2) {
            if (o1 != null && o2 != null) {
                return o1.getLevel().getDepth() - o2.getLevel().getDepth();
            }
            return 0;
        }
    }
}

