/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.quartz.impl.jdbcjobstore.StdJDBCDelegate;

public class SybaseDelegate
extends StdJDBCDelegate {
    @Override
    protected Object getObjectFromBlob(ResultSet rs, String colName) throws ClassNotFoundException, IOException, SQLException {
        Object obj;
        InputStream binaryInput = rs.getBinaryStream(colName);
        if (binaryInput == null || binaryInput.available() == 0) {
            return null;
        }
        try (ObjectInputStream in = new ObjectInputStream(binaryInput);){
            obj = in.readObject();
        }
        return obj;
    }

    @Override
    protected Object getJobDataFromBlob(ResultSet rs, String colName) throws ClassNotFoundException, IOException, SQLException {
        if (this.canUseProperties()) {
            return rs.getBinaryStream(colName);
        }
        return this.getObjectFromBlob(rs, colName);
    }

    @Override
    protected void setBytes(PreparedStatement ps, int index, ByteArrayOutputStream baos) throws SQLException {
        ps.setBytes(index, baos == null ? null : baos.toByteArray());
    }
}

