/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel.examples;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.util.IOUtils;

public class AddDimensionedImage {
    public static final int EXPAND_ROW = 1;
    public static final int EXPAND_COLUMN = 2;
    public static final int EXPAND_ROW_AND_COLUMN = 3;
    public static final int OVERLAY_ROW_AND_COLUMN = 7;

    public void addImageToSheet(String cellNumber, HSSFSheet sheet, String imageFile, double reqImageWidthMM, double reqImageHeightMM, int resizeBehaviour) throws IOException, IllegalArgumentException {
        CellReference cellRef = new CellReference(cellNumber);
        this.addImageToSheet(cellRef.getCol(), cellRef.getRow(), sheet, imageFile, reqImageWidthMM, reqImageHeightMM, resizeBehaviour);
    }

    private void addImageToSheet(int colNumber, int rowNumber, HSSFSheet sheet, String imageFile, double reqImageWidthMM, double reqImageHeightMM, int resizeBehaviour) throws FileNotFoundException, IOException, IllegalArgumentException {
        if (resizeBehaviour != 2 && resizeBehaviour != 1 && resizeBehaviour != 3 && resizeBehaviour != 7) {
            throw new IllegalArgumentException("Invalid value passed to the resizeBehaviour parameter of AddDimensionedImage.addImageToSheet()");
        }
        ClientAnchorDetail colClientAnchorDetail = this.fitImageToColumns(sheet, colNumber, reqImageWidthMM, resizeBehaviour);
        ClientAnchorDetail rowClientAnchorDetail = this.fitImageToRows(sheet, rowNumber, reqImageHeightMM, resizeBehaviour);
        int dx1 = 0;
        int dy1 = 0;
        int dx2 = 0;
        int dy2 = 0;
        short col1 = 0;
        short col2 = 0;
        short row1 = 0;
        short row2 = 0;
        if (colClientAnchorDetail != null) {
            dx2 = colClientAnchorDetail.getInset();
            col1 = (short)colClientAnchorDetail.getFromIndex();
            col2 = (short)colClientAnchorDetail.getToIndex();
        }
        if (rowClientAnchorDetail != null) {
            dy2 = rowClientAnchorDetail.getInset();
            row1 = (short)rowClientAnchorDetail.getFromIndex();
            row2 = (short)rowClientAnchorDetail.getToIndex();
        }
        HSSFClientAnchor anchor = new HSSFClientAnchor(dx1, dy1, dx2, dy2, col1, (int)row1, col2, (int)row2);
        anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_AND_RESIZE);
        int index = sheet.getWorkbook().addPicture(this.imageToBytes(imageFile), 6);
        HSSFPatriarch patriarch = sheet.createDrawingPatriarch();
        patriarch.createPicture(anchor, index);
    }

    private ClientAnchorDetail fitImageToColumns(HSSFSheet sheet, int colNumber, double reqImageWidthMM, int resizeBehaviour) {
        ClientAnchorDetail colClientAnchorDetail = null;
        double colWidthMM = ConvertImageUnits.widthUnits2Millimetres((short)sheet.getColumnWidth(colNumber));
        if (colWidthMM < reqImageWidthMM) {
            if (resizeBehaviour == 2 || resizeBehaviour == 3) {
                sheet.setColumnWidth(colNumber, ConvertImageUnits.millimetres2WidthUnits(reqImageWidthMM));
                colWidthMM = reqImageWidthMM;
                double colCoordinatesPerMM = 1023.0 / colWidthMM;
                int pictureWidthCoordinates = (int)(reqImageWidthMM * colCoordinatesPerMM);
                colClientAnchorDetail = new ClientAnchorDetail(colNumber, colNumber, pictureWidthCoordinates);
            } else if (resizeBehaviour == 7 || resizeBehaviour == 1) {
                colClientAnchorDetail = this.calculateColumnLocation(sheet, colNumber, reqImageWidthMM);
            }
        } else {
            double colCoordinatesPerMM = 1023.0 / colWidthMM;
            int pictureWidthCoordinates = (int)(reqImageWidthMM * colCoordinatesPerMM);
            colClientAnchorDetail = new ClientAnchorDetail(colNumber, colNumber, pictureWidthCoordinates);
        }
        return colClientAnchorDetail;
    }

    private ClientAnchorDetail fitImageToRows(HSSFSheet sheet, int rowNumber, double reqImageHeightMM, int resizeBehaviour) {
        double rowHeightMM;
        ClientAnchorDetail rowClientAnchorDetail = null;
        HSSFRow row = sheet.getRow(rowNumber);
        if (row == null) {
            row = sheet.createRow(rowNumber);
        }
        if ((rowHeightMM = (double)row.getHeightInPoints() / 2.83) < reqImageHeightMM) {
            if (resizeBehaviour == 1 || resizeBehaviour == 3) {
                row.setHeightInPoints((float)(reqImageHeightMM * 2.83));
                rowHeightMM = reqImageHeightMM;
                double rowCoordinatesPerMM = 255.0 / rowHeightMM;
                int pictureHeightCoordinates = (int)(reqImageHeightMM * rowCoordinatesPerMM);
                rowClientAnchorDetail = new ClientAnchorDetail(rowNumber, rowNumber, pictureHeightCoordinates);
            } else if (resizeBehaviour == 7 || resizeBehaviour == 2) {
                rowClientAnchorDetail = this.calculateRowLocation(sheet, rowNumber, reqImageHeightMM);
            }
        } else {
            double rowCoordinatesPerMM = 255.0 / rowHeightMM;
            int pictureHeightCoordinates = (int)(reqImageHeightMM * rowCoordinatesPerMM);
            rowClientAnchorDetail = new ClientAnchorDetail(rowNumber, rowNumber, pictureHeightCoordinates);
        }
        return rowClientAnchorDetail;
    }

    private ClientAnchorDetail calculateColumnLocation(HSSFSheet sheet, int startingColumn, double reqImageWidthMM) {
        ClientAnchorDetail anchorDetail;
        double totalWidthMM = 0.0;
        double colWidthMM = 0.0;
        int toColumn = startingColumn;
        while (totalWidthMM < reqImageWidthMM) {
            colWidthMM = ConvertImageUnits.widthUnits2Millimetres((short)sheet.getColumnWidth(toColumn));
            totalWidthMM += colWidthMM + 2.0;
            ++toColumn;
        }
        --toColumn;
        if ((int)totalWidthMM == (int)reqImageWidthMM) {
            anchorDetail = new ClientAnchorDetail(startingColumn, toColumn, 1023);
        } else {
            double overlapMM = reqImageWidthMM - (totalWidthMM - colWidthMM);
            if (overlapMM < 0.0) {
                overlapMM = 0.0;
            }
            double coordinatePositionsPerMM = colWidthMM == 0.0 ? 0.0 : 1023.0 / colWidthMM;
            int inset = (int)(coordinatePositionsPerMM * overlapMM);
            anchorDetail = new ClientAnchorDetail(startingColumn, toColumn, inset);
        }
        return anchorDetail;
    }

    private ClientAnchorDetail calculateRowLocation(HSSFSheet sheet, int startingRow, double reqImageHeightMM) {
        ClientAnchorDetail clientAnchorDetail;
        double rowHeightMM = 0.0;
        double totalRowHeightMM = 0.0;
        int toRow = startingRow;
        while (totalRowHeightMM < reqImageHeightMM) {
            HSSFRow row = sheet.getRow(toRow);
            if (row == null) {
                row = sheet.createRow(toRow);
            }
            rowHeightMM = (double)row.getHeightInPoints() / 2.83;
            totalRowHeightMM += rowHeightMM;
            ++toRow;
        }
        --toRow;
        if ((int)totalRowHeightMM == (int)reqImageHeightMM) {
            clientAnchorDetail = new ClientAnchorDetail(startingRow, toRow, 255);
        } else {
            double overlapMM = reqImageHeightMM - (totalRowHeightMM - rowHeightMM);
            if (overlapMM < 0.0) {
                overlapMM = 0.0;
            }
            double rowCoordinatesPerMM = rowHeightMM == 0.0 ? 0.0 : 255.0 / rowHeightMM;
            int inset = (int)(overlapMM * rowCoordinatesPerMM);
            clientAnchorDetail = new ClientAnchorDetail(startingRow, toRow, inset);
        }
        return clientAnchorDetail;
    }

    private byte[] imageToBytes(String imageFilename) throws IOException {
        File imageFile = new File(imageFilename);
        try (FileInputStream fis = new FileInputStream(imageFile);){
            byte[] byArray = IOUtils.toByteArray((InputStream)fis);
            return byArray;
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.err.println("Usage: AddDimensionedImage imageFile outputFile");
            return;
        }
        String imageFile = args[0];
        String outputFile = args[1];
        try (HSSFWorkbook workbook = new HSSFWorkbook();){
            HSSFSheet sheet = workbook.createSheet("Picture Test");
            new AddDimensionedImage().addImageToSheet("A1", sheet, imageFile, 125.0, 125.0, 3);
            try (FileOutputStream fos = new FileOutputStream(outputFile);){
                workbook.write((OutputStream)fos);
            }
        }
    }

    private static final class ConvertImageUnits {
        public static final int TOTAL_COLUMN_COORDINATE_POSITIONS = 1023;
        public static final int TOTAL_ROW_COORDINATE_POSITIONS = 255;
        public static final double PIXELS_PER_MILLIMETRES = 3.78;
        public static final double POINTS_PER_MILLIMETRE = 2.83;
        public static final double CELL_BORDER_WIDTH_MILLIMETRES = 2.0;
        public static final short EXCEL_COLUMN_WIDTH_FACTOR = 256;
        public static final int UNIT_OFFSET_LENGTH = 7;
        private static final int[] UNIT_OFFSET_MAP = new int[]{0, 36, 73, 109, 146, 182, 219};

        private ConvertImageUnits() {
        }

        public static short pixel2WidthUnits(int pxs) {
            short widthUnits = (short)(256 * (pxs / 7));
            widthUnits = (short)(widthUnits + UNIT_OFFSET_MAP[pxs % 7]);
            return widthUnits;
        }

        public static int widthUnits2Pixel(short widthUnits) {
            int pixels = widthUnits / 256 * 7;
            int offsetWidthUnits = widthUnits % 256;
            return pixels += Math.round((float)offsetWidthUnits / 36.57143f);
        }

        public static double widthUnits2Millimetres(short widthUnits) {
            return (double)ConvertImageUnits.widthUnits2Pixel(widthUnits) / 3.78;
        }

        public static int millimetres2WidthUnits(double millimetres) {
            return ConvertImageUnits.pixel2WidthUnits((int)(millimetres * 3.78));
        }
    }

    public static class ClientAnchorDetail {
        private int fromIndex;
        private int toIndex;
        private int inset;

        public ClientAnchorDetail(int fromIndex, int toIndex, int inset) {
            this.fromIndex = fromIndex;
            this.toIndex = toIndex;
            this.inset = inset;
        }

        public int getFromIndex() {
            return this.fromIndex;
        }

        public int getToIndex() {
            return this.toIndex;
        }

        public int getInset() {
            return this.inset;
        }
    }
}

