/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.xmla.server.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class StringEscaper {
    private final String[] translationTable;
    public static final StringEscaper HTML_ESCAPER;
    public static final StringEscaper XML_ESCAPER;
    public static final StringEscaper XML_NUMERIC_ESCAPER;
    public static final StringEscaper URL_ARG_ESCAPER;
    public static final StringEscaper URL_ESCAPER;

    private StringEscaper(String[] translationTable) {
        this.translationTable = translationTable;
    }

    public String escapeString(String s) {
        StringBuilder sb = null;
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            String escape = c > '\u007f' ? "&#" + Integer.toString(c) + ";" : (c >= this.translationTable.length ? null : this.translationTable[c]);
            if (escape == null) {
                if (sb == null) continue;
                sb.append(c);
                continue;
            }
            if (sb == null) {
                sb = new StringBuilder(n * 2);
                sb.append(s.substring(0, i));
            }
            sb.append(escape);
        }
        if (sb == null) {
            return s;
        }
        return sb.toString();
    }

    public void appendEscapedString(String s, StringBuffer sb) {
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            String escape = c >= this.translationTable.length ? null : this.translationTable[c];
            if (escape == null) {
                sb.append(c);
                continue;
            }
            sb.append(escape);
        }
    }

    public void appendEscapedString(String s, Appendable sb) throws IOException {
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            String escape = c >= this.translationTable.length ? null : this.translationTable[c];
            if (escape == null) {
                sb.append(c);
                continue;
            }
            sb.append(escape);
        }
    }

    public Builder toBuilder() {
        return new Builder(new ArrayList<String>(Arrays.asList(this.translationTable)));
    }

    static {
        XML_ESCAPER = HTML_ESCAPER = new Builder().defineEscape('&', "&amp;").defineEscape('\"', "&quot;").defineEscape('\'', "&#39;").defineEscape('<', "&lt;").defineEscape('>', "&gt;").build();
        XML_NUMERIC_ESCAPER = new Builder().defineEscape('&', "&#38;").defineEscape('\"', "&#34;").defineEscape('\'', "&#39;").defineEscape('<', "&#60;").defineEscape('>', "&#62;").defineEscape('\t', "&#9;").defineEscape('\n', "&#10;").defineEscape('\r', "&#13;").build();
        URL_ARG_ESCAPER = new Builder().defineEscape('?', "%3f").defineEscape('&', "%26").build();
        URL_ESCAPER = URL_ARG_ESCAPER.toBuilder().defineEscape('%', "%%").defineEscape('\"', "%22").defineEscape('\r', "+").defineEscape('\n', "+").defineEscape(' ', "+").defineEscape('#', "%23").build();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private final List<String> translationVector;

        public Builder() {
            this(new ArrayList<String>());
        }

        private Builder(List<String> translationVector) {
            this.translationVector = translationVector;
        }

        public StringEscaper build() {
            return new StringEscaper(this.translationVector.toArray(new String[this.translationVector.size()]));
        }

        public Builder defineEscape(char from, String to) {
            char i = from;
            if (i >= this.translationVector.size()) {
                this.translationVector.addAll(Collections.nCopies(i + '\u0001' - this.translationVector.size(), null));
            }
            this.translationVector.set(i, to);
            return this;
        }
    }
}

