/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.driver.xmla.cache;

import java.net.URL;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.olap4j.driver.xmla.cache.XmlaOlap4jCache;
import org.olap4j.driver.xmla.cache.XmlaOlap4jConcurrentMemoryCache;
import org.olap4j.driver.xmla.cache.XmlaOlap4jInvalidStateException;
import org.olap4j.impl.Olap4jUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlaOlap4jNamedMemoryCache
implements XmlaOlap4jCache {
    private static Map<String, XmlaOlap4jConcurrentMemoryCache> caches = null;
    private boolean initDone = false;

    public XmlaOlap4jNamedMemoryCache() {
        XmlaOlap4jNamedMemoryCache.initCaches();
    }

    private static synchronized void initCaches() {
        if (caches == null) {
            caches = new ConcurrentHashMap<String, XmlaOlap4jConcurrentMemoryCache>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String setParameters(Map<String, String> config, Map<String, String> props) {
        String refId;
        if (props.containsKey(Property.NAME.name())) {
            refId = props.get(Property.NAME.name());
        } else {
            refId = String.valueOf(UUID.randomUUID());
            props.put(Property.NAME.name(), refId);
        }
        Map<String, XmlaOlap4jConcurrentMemoryCache> map = caches;
        synchronized (map) {
            if (!caches.containsKey(props.get(Property.NAME.name()))) {
                caches.put(props.get(Property.NAME.name()), new XmlaOlap4jConcurrentMemoryCache(props));
            }
        }
        this.initDone = true;
        return refId;
    }

    @Override
    public byte[] get(String id, URL url, byte[] request) throws XmlaOlap4jInvalidStateException {
        this.validateState();
        Map<String, XmlaOlap4jConcurrentMemoryCache> map = caches;
        synchronized (map) {
            if (caches.containsKey(id)) {
                return caches.get(id).get(url, request);
            }
            throw new XmlaOlap4jInvalidStateException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String id, URL url, byte[] request, byte[] response) throws XmlaOlap4jInvalidStateException {
        this.validateState();
        Map<String, XmlaOlap4jConcurrentMemoryCache> map = caches;
        synchronized (map) {
            if (!caches.containsKey(id)) {
                throw new XmlaOlap4jInvalidStateException();
            }
            caches.get(id).put(url, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushCache() {
        Map<String, XmlaOlap4jConcurrentMemoryCache> map = caches;
        synchronized (map) {
            caches.clear();
        }
    }

    private void validateState() throws XmlaOlap4jInvalidStateException {
        if (!this.initDone) {
            throw new XmlaOlap4jInvalidStateException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        LIFO,
        FIFO,
        LFU,
        MFU;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        NAME("Name of a cache to create or to share."),
        SIZE("Maximum number of SOAP requests which will be cached under the given cache name."),
        TIMEOUT("Maximum TTL of SOAP requests which will be cached under the given cache name."),
        MODE("Eviction mode to set to the given cache name.");


        private Property(String description) {
            Olap4jUtil.discard((Object)description);
        }
    }
}

