/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.driver.xmla;

import java.io.StringWriter;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.olap4j.CellSet;
import org.olap4j.CellSetListener;
import org.olap4j.OlapConnection;
import org.olap4j.OlapException;
import org.olap4j.OlapStatement;
import org.olap4j.driver.xmla.XmlaHelper;
import org.olap4j.driver.xmla.XmlaOlap4jCellSet;
import org.olap4j.driver.xmla.XmlaOlap4jConnection;
import org.olap4j.mdx.ParseTreeNode;
import org.olap4j.mdx.ParseTreeWriter;
import org.olap4j.mdx.SelectNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class XmlaOlap4jStatement
implements OlapStatement {
    final XmlaOlap4jConnection olap4jConnection;
    private boolean closed;
    XmlaOlap4jCellSet openCellSet;
    private boolean canceled;
    int timeoutSeconds;
    Future<byte[]> future;
    private boolean cancelEarly = false;

    XmlaOlap4jStatement(XmlaOlap4jConnection olap4jConnection) {
        assert (olap4jConnection != null);
        this.olap4jConnection = olap4jConnection;
        this.closed = false;
    }

    private XmlaHelper getHelper() {
        return this.olap4jConnection.helper;
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int executeUpdate(String sql) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void close() throws SQLException {
        if (!this.closed) {
            this.closed = true;
            if (this.openCellSet != null) {
                XmlaOlap4jCellSet c = this.openCellSet;
                this.openCellSet = null;
                c.close();
            }
        }
    }

    public int getMaxFieldSize() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setMaxFieldSize(int max) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getMaxRows() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setMaxRows(int max) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getQueryTimeout() throws SQLException {
        return this.timeoutSeconds;
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        if (seconds < 0) {
            throw this.getHelper().createException("illegal timeout value " + seconds);
        }
        this.timeoutSeconds = seconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void cancel() {
        XmlaOlap4jStatement xmlaOlap4jStatement = this;
        synchronized (xmlaOlap4jStatement) {
            if (!this.canceled) {
                if (this.future != null) {
                    this.canceled = true;
                    this.future.cancel(true);
                } else {
                    this.cancelEarly = true;
                }
            }
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void clearWarnings() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setCursorName(String name) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean execute(String sql) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getResultSet() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getUpdateCount() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean getMoreResults() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setFetchDirection(int direction) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getFetchDirection() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setFetchSize(int rows) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getFetchSize() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getResultSetConcurrency() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getResultSetType() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void addBatch(String sql) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void clearBatch() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int[] executeBatch() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public OlapConnection getConnection() {
        return this.olap4jConnection;
    }

    public boolean getMoreResults(int current) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getResultSetHoldability() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    public void setPoolable(boolean poolable) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isPoolable() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return iface.cast(this);
        }
        throw this.getHelper().createException("does not implement '" + iface + "'");
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CellSet executeOlapQuery(String mdx) throws OlapException {
        String dataSourceInfo;
        String catalog = this.olap4jConnection.getCatalog();
        String roleName = this.olap4jConnection.getRoleName();
        String propList = this.olap4jConnection.makeConnectionPropertyList();
        switch (XmlaOlap4jConnection.BackendFlavor.getFlavor(this.olap4jConnection, true)) {
            case ESSBASE: {
                dataSourceInfo = this.olap4jConnection.getOlapDatabase().getDataSourceInfo();
                break;
            }
            default: {
                dataSourceInfo = this.olap4jConnection.getDatabase();
            }
        }
        StringBuilder buf = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<soapenv:Envelope\n    xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\"\n    xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n    <soapenv:Body>\n        <Execute xmlns=\"urn:schemas-microsoft-com:xml-analysis\">\n        <Command>\n        <Statement>\n           <![CDATA[\n" + mdx + "]]>\n" + "         </Statement>\n" + "        </Command>\n" + "        <Properties>\n" + "          <PropertyList>\n");
        if (catalog != null) {
            buf.append("            <Catalog>");
            buf.append(catalog);
            buf.append("</Catalog>\n");
        }
        if (propList != null) {
            buf.append(propList);
        }
        if (roleName != null && !"".equals(roleName)) {
            buf.append("        <Roles>");
            buf.append(roleName);
            buf.append("</Roles>\n");
        }
        if (dataSourceInfo != null) {
            buf.append("            <DataSourceInfo>");
            buf.append(dataSourceInfo);
            buf.append("</DataSourceInfo>\n");
        }
        buf.append("            <Format>Multidimensional</Format>\n            <AxisFormat>TupleFormat</AxisFormat>\n          </PropertyList>\n        </Properties>\n</Execute>\n</soapenv:Body>\n</soapenv:Envelope>");
        String request = buf.toString();
        XmlaOlap4jStatement xmlaOlap4jStatement = this;
        synchronized (xmlaOlap4jStatement) {
            if (this.openCellSet != null) {
                XmlaOlap4jCellSet cs = this.openCellSet;
                this.openCellSet = null;
                try {
                    cs.close();
                }
                catch (SQLException e) {
                    throw this.getHelper().createException("Error while closing previous CellSet", e);
                }
            }
            this.future = this.olap4jConnection.proxy.submit(this.olap4jConnection.serverInfos, request);
            this.openCellSet = this.olap4jConnection.factory.newCellSet(this);
        }
        if (this.cancelEarly) {
            this.cancel();
        }
        this.openCellSet.populate();
        return this.openCellSet;
    }

    public CellSet executeOlapQuery(SelectNode selectNode) throws OlapException {
        String mdx = XmlaOlap4jStatement.toString((ParseTreeNode)selectNode);
        return this.executeOlapQuery(mdx);
    }

    public void addListener(CellSetListener.Granularity granularity, CellSetListener listener) throws OlapException {
        throw this.getHelper().createException("This driver does not support the cell listener API.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getBytes() throws OlapException {
        Object object = this;
        synchronized (object) {
            if (this.future == null) {
                throw new IllegalArgumentException();
            }
        }
        try {
            if (this.timeoutSeconds > 0) {
                object = this.future.get(this.timeoutSeconds, TimeUnit.SECONDS);
                return object;
            }
            object = this.future.get();
            return object;
        }
        catch (InterruptedException e) {
            throw this.getHelper().createException(null, e);
        }
        catch (ExecutionException e) {
            throw this.getHelper().createException(null, e.getCause());
        }
        catch (TimeoutException e) {
            throw this.getHelper().createException("Query timeout of " + this.timeoutSeconds + " seconds exceeded");
        }
        catch (CancellationException e) {
            throw this.getHelper().createException("Query canceled");
        }
        finally {
            XmlaOlap4jStatement xmlaOlap4jStatement = this;
            synchronized (xmlaOlap4jStatement) {
                if (this.future == null) {
                    throw new IllegalArgumentException();
                }
                this.future = null;
            }
        }
    }

    private static String toString(ParseTreeNode node) {
        StringWriter sw = new StringWriter();
        ParseTreeWriter parseTreeWriter = new ParseTreeWriter((Writer)sw);
        node.unparse(parseTreeWriter);
        return sw.toString();
    }
}

