/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.olap4j.Axis;
import org.olap4j.mdx.AxisNode;
import org.olap4j.mdx.CallNode;
import org.olap4j.mdx.CubeNode;
import org.olap4j.mdx.DimensionNode;
import org.olap4j.mdx.HierarchyNode;
import org.olap4j.mdx.IdentifierNode;
import org.olap4j.mdx.LevelNode;
import org.olap4j.mdx.LiteralNode;
import org.olap4j.mdx.MemberNode;
import org.olap4j.mdx.ParseTreeNode;
import org.olap4j.mdx.SelectNode;
import org.olap4j.mdx.Syntax;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.Member;
import org.olap4j.query.Query;
import org.olap4j.query.QueryAxis;
import org.olap4j.query.QueryDimension;
import org.olap4j.query.Selection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Olap4jNodeConverter {
    Olap4jNodeConverter() {
    }

    public static SelectNode toOlap4j(Query query) {
        List<IdentifierNode> list = Collections.emptyList();
        List<Object> withList = query.getWithList().isEmpty() ? Collections.emptyList() : query.getWithList();
        ArrayList<QueryAxis> axisList = new ArrayList<QueryAxis>();
        axisList.add(query.getAxes().get(Axis.COLUMNS));
        axisList.add(query.getAxes().get(Axis.ROWS));
        AxisNode filterAxis = null;
        if (query.getAxes().containsKey(Axis.FILTER)) {
            QueryAxis axis = query.getAxes().get(Axis.FILTER);
            if (!axis.dimensions.isEmpty()) {
                filterAxis = Olap4jNodeConverter.toOlap4j(axis);
            }
        }
        return new SelectNode(null, withList, Olap4jNodeConverter.toOlap4j(axisList), new CubeNode(null, query.getCube()), filterAxis, list);
    }

    private static CallNode generateSetCall(ParseTreeNode ... args) {
        return new CallNode(null, "{}", Syntax.Braces, args);
    }

    private static CallNode generateListSetCall(List<ParseTreeNode> cnodes) {
        return new CallNode(null, "{}", Syntax.Braces, cnodes);
    }

    private static CallNode generateListTupleCall(List<ParseTreeNode> cnodes) {
        return new CallNode(null, "()", Syntax.Parentheses, cnodes);
    }

    protected static CallNode generateCrossJoin(List<ParseTreeNode> selections) {
        ParseTreeNode sel1 = selections.remove(0);
        if (sel1 instanceof MemberNode) {
            sel1 = Olap4jNodeConverter.generateSetCall(sel1);
        }
        if (selections.size() == 1) {
            ParseTreeNode sel2 = selections.get(0);
            if (sel2 instanceof MemberNode) {
                sel2 = Olap4jNodeConverter.generateSetCall(sel2);
            }
            return new CallNode(null, "CrossJoin", Syntax.Function, sel1, sel2);
        }
        return new CallNode(null, "CrossJoin", Syntax.Function, sel1, Olap4jNodeConverter.generateCrossJoin(selections));
    }

    protected static CallNode generateUnion(List<List<ParseTreeNode>> unions) {
        if (unions.size() > 2) {
            List<ParseTreeNode> first = unions.remove(0);
            return new CallNode(null, "Union", Syntax.Function, Olap4jNodeConverter.generateCrossJoin(first), Olap4jNodeConverter.generateUnion(unions));
        }
        return new CallNode(null, "Union", Syntax.Function, Olap4jNodeConverter.generateCrossJoin(unions.get(0)), Olap4jNodeConverter.generateCrossJoin(unions.get(1)));
    }

    protected static CallNode generateHierarchizeUnion(List<List<ParseTreeNode>> unions) {
        return new CallNode(null, "Hierarchize", Syntax.Function, Olap4jNodeConverter.generateUnion(unions));
    }

    private static void generateUnionsRecursively(QueryAxis axis, int dim, List<ParseTreeNode> curr, List<List<ParseTreeNode>> unions, List<Selection> selsWithContext, List<List<ParseTreeNode>> contextUnions) {
        CallNode exceptSet = null;
        QueryDimension qDim = axis.getDimensions().get(dim);
        List<Selection> exclusionSelections = qDim.getExclusions();
        ArrayList<ParseTreeNode> exclusionNodes = new ArrayList<ParseTreeNode>();
        for (Selection exclusion : exclusionSelections) {
            exclusionNodes.add(Olap4jNodeConverter.toOlap4j(exclusion));
        }
        if (exclusionNodes.size() > 0) {
            exceptSet = Olap4jNodeConverter.generateListSetCall(exclusionNodes);
        }
        for (Selection sel : qDim.getInclusions()) {
            ParseTreeNode selectionNode = Olap4jNodeConverter.toOlap4j(sel);
            if (qDim.isHierarchyConsistent() && qDim.getInclusions().size() > 1) {
                Integer currentDepth = null;
                if (sel.getRootElement() instanceof Member) {
                    currentDepth = ((Member)sel.getRootElement()).getDepth();
                } else if (sel.getRootElement() instanceof Level) {
                    currentDepth = ((Level)sel.getRootElement()).getDepth();
                }
                selectionNode = Olap4jNodeConverter.toHierarchyConsistentNode(selectionNode, currentDepth, qDim);
            }
            if (qDim.getSortOrder() != null) {
                CallNode currentMemberNode = new CallNode(null, "CurrentMember", Syntax.Property, new DimensionNode(null, sel.getDimension()));
                CallNode currentMemberNameNode = new CallNode(null, "Name", Syntax.Property, currentMemberNode);
                selectionNode = new CallNode(null, "Order", Syntax.Function, Olap4jNodeConverter.generateSetCall(selectionNode), currentMemberNameNode, LiteralNode.createSymbol(null, qDim.getSortOrder().name()));
            }
            if (exceptSet != null) {
                selectionNode = new CallNode(null, "Except", Syntax.Function, Olap4jNodeConverter.generateSetCall(selectionNode), exceptSet);
            }
            if (sel.getSelectionContext() != null && sel.getSelectionContext().size() > 0) {
                if (selsWithContext.contains(sel)) continue;
                ArrayList<ParseTreeNode> sels = new ArrayList<ParseTreeNode>();
                for (int i = 0; i < axis.getDimensions().size(); ++i) {
                    if (dim == i) {
                        sels.add(selectionNode);
                        continue;
                    }
                    QueryDimension dimension = axis.getDimensions().get(i);
                    boolean found = false;
                    for (Selection selection : sel.getSelectionContext()) {
                        if (!selection.getDimension().equals(dimension.getDimension())) continue;
                        sels.add(Olap4jNodeConverter.toOlap4j(selection));
                        found = true;
                    }
                    if (found || dimension.getInclusions().size() <= 0) continue;
                    sels.add(Olap4jNodeConverter.toOlap4j(dimension.getInclusions().get(0)));
                }
                contextUnions.add(sels);
                selsWithContext.add(sel);
                continue;
            }
            ArrayList<ParseTreeNode> ncurr = new ArrayList<ParseTreeNode>();
            if (curr != null) {
                ncurr.addAll(curr);
            }
            ncurr.add(selectionNode);
            if (dim == axis.getDimensions().size() - 1) {
                unions.add(ncurr);
                continue;
            }
            Olap4jNodeConverter.generateUnionsRecursively(axis, dim + 1, ncurr, unions, selsWithContext, contextUnions);
        }
    }

    private static AxisNode toOlap4j(QueryAxis axis) {
        LiteralNode evaluatorNode;
        CallNode callNode = null;
        int numDimensions = axis.getDimensions().size();
        if (numDimensions == 0) {
            return null;
        }
        if (numDimensions == 1) {
            QueryDimension dimension = axis.getDimensions().get(0);
            List<ParseTreeNode> members = Olap4jNodeConverter.toOlap4j(dimension);
            callNode = Olap4jNodeConverter.generateListSetCall(members);
        } else {
            ArrayList<List<ParseTreeNode>> unions = new ArrayList<List<ParseTreeNode>>();
            ArrayList<Selection> selsWithContext = new ArrayList<Selection>();
            ArrayList<List<ParseTreeNode>> contextUnions = new ArrayList<List<ParseTreeNode>>();
            Olap4jNodeConverter.generateUnionsRecursively(axis, 0, null, unions, selsWithContext, contextUnions);
            unions.addAll(contextUnions);
            callNode = unions.size() > 1 ? (axis.getHierarchizeMode() != null && axis.getHierarchizeMode().equals((Object)QueryDimension.HierarchizeMode.POST) ? Olap4jNodeConverter.generateHierarchizeUnionPost(unions) : Olap4jNodeConverter.generateHierarchizeUnion(unions)) : Olap4jNodeConverter.generateCrossJoin((List)unions.get(0));
        }
        CallNode filteredNode = null;
        if (axis.getFilterCondition() != null) {
            LiteralNode conditionNode = LiteralNode.createSymbol(null, axis.getFilterCondition());
            filteredNode = new CallNode(null, "Filter", Syntax.Function, callNode, conditionNode);
        } else {
            filteredNode = callNode;
        }
        CallNode limitedNode = null;
        if (axis.getLimitFunction() != null) {
            LiteralNode n = LiteralNode.createNumeric(null, axis.getLimitFunctionN(), false);
            if (axis.getLimitFunctionSortLiteral() != null) {
                evaluatorNode = null;
                evaluatorNode = LiteralNode.createSymbol(null, axis.getLimitFunctionSortLiteral());
                limitedNode = new CallNode(null, axis.getLimitFunction().toString(), Syntax.Function, filteredNode, n, evaluatorNode);
            } else {
                limitedNode = new CallNode(null, axis.getLimitFunction().toString(), Syntax.Function, filteredNode, n);
            }
        } else {
            limitedNode = filteredNode;
        }
        CallNode sortedNode = null;
        if (axis.getSortOrder() != null) {
            evaluatorNode = LiteralNode.createSymbol(null, axis.getSortIdentifierNodeName());
            sortedNode = new CallNode(null, "Order", Syntax.Function, limitedNode, evaluatorNode, LiteralNode.createSymbol(null, axis.getSortOrder().name()));
        } else {
            sortedNode = limitedNode;
        }
        return new AxisNode(null, axis.isNonEmpty(), axis.getLocation(), new ArrayList<IdentifierNode>(), sortedNode);
    }

    protected static CallNode generateHierarchizeUnionPost(List<List<ParseTreeNode>> unions) {
        return new CallNode(null, "Hierarchize", Syntax.Function, Olap4jNodeConverter.generateUnion(unions), LiteralNode.createSymbol(null, QueryDimension.HierarchizeMode.POST.name()));
    }

    private static List<ParseTreeNode> toOlap4j(QueryDimension dimension) {
        ArrayList<ParseTreeNode> includeList = new ArrayList<ParseTreeNode>();
        HashMap levelNodes = new HashMap();
        for (Selection selection : dimension.getInclusions()) {
            ParseTreeNode selectionNode = Olap4jNodeConverter.toOlap4j(selection);
            if (dimension.isHierarchyConsistent() && dimension.getInclusions().size() > 1) {
                Integer curdepth = 0;
                if (selection.getRootElement() instanceof Member) {
                    curdepth = ((Member)selection.getRootElement()).getDepth();
                } else if (selection.getRootElement() instanceof Level) {
                    curdepth = ((Level)selection.getRootElement()).getDepth();
                }
                if (levelNodes.get(curdepth) != null) {
                    ((List)levelNodes.get(curdepth)).add(selectionNode);
                    continue;
                }
                ArrayList<ParseTreeNode> nodes = new ArrayList<ParseTreeNode>();
                nodes.add(selectionNode);
                levelNodes.put(curdepth, nodes);
                continue;
            }
            includeList.add(selectionNode);
        }
        if (dimension.isHierarchyConsistent() && dimension.getInclusions().size() > 1) {
            Object[] levelDepths = levelNodes.keySet().toArray(new Integer[levelNodes.keySet().size()]);
            Arrays.sort(levelDepths);
            for (Object depth : levelDepths) {
                ParseTreeNode levelNode = Olap4jNodeConverter.generateListSetCall((List)levelNodes.get(depth));
                levelNode = Olap4jNodeConverter.toHierarchyConsistentNode(levelNode, (Integer)depth, dimension);
                includeList.add(levelNode);
            }
        }
        ArrayList<ParseTreeNode> orderedList = new ArrayList<ParseTreeNode>();
        if (dimension.getSortOrder() != null) {
            CallNode currentMemberNode = new CallNode(null, "CurrentMember", Syntax.Property, new DimensionNode(null, dimension.getDimension()));
            CallNode currentMemberNameNode = new CallNode(null, "Name", Syntax.Property, currentMemberNode);
            orderedList.add(new CallNode(null, "Order", Syntax.Function, Olap4jNodeConverter.generateListSetCall(includeList), currentMemberNameNode, LiteralNode.createSymbol(null, dimension.getSortOrder().name())));
        } else {
            orderedList.addAll(includeList);
        }
        ArrayList<ParseTreeNode> listWithExclusions = new ArrayList<ParseTreeNode>();
        if (dimension.getExclusions().size() > 0) {
            ArrayList<ParseTreeNode> excludedMembers = new ArrayList<ParseTreeNode>();
            for (Selection selection : dimension.getExclusions()) {
                excludedMembers.add(Olap4jNodeConverter.toOlap4j(selection));
            }
            listWithExclusions.add(new CallNode(null, "Except", Syntax.Function, Olap4jNodeConverter.generateListSetCall(orderedList), Olap4jNodeConverter.generateListSetCall(excludedMembers)));
        } else {
            listWithExclusions.addAll(orderedList);
        }
        ArrayList<ParseTreeNode> listWithHierarchy = new ArrayList<ParseTreeNode>();
        if (dimension.getHierarchizeMode() != null) {
            CallNode hierarchyNode;
            if (dimension.getHierarchizeMode().equals((Object)QueryDimension.HierarchizeMode.PRE)) {
                hierarchyNode = new CallNode(null, "Hierarchize", Syntax.Function, Olap4jNodeConverter.generateListSetCall(listWithExclusions));
            } else if (dimension.getHierarchizeMode().equals((Object)QueryDimension.HierarchizeMode.POST)) {
                hierarchyNode = new CallNode(null, "Hierarchize", Syntax.Function, Olap4jNodeConverter.generateListSetCall(listWithExclusions), LiteralNode.createSymbol(null, dimension.getHierarchizeMode().name()));
            } else {
                throw new RuntimeException("Missing value handler.");
            }
            listWithHierarchy.add(hierarchyNode);
        } else {
            listWithHierarchy.addAll(listWithExclusions);
        }
        return listWithHierarchy;
    }

    private static ParseTreeNode toOlap4j(Selection selection) {
        try {
            return selection.visit();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static ParseTreeNode toOlap4j(Member member, Selection.Operator oper) {
        ParseTreeNode node = null;
        try {
            switch (oper) {
                case MEMBER: {
                    node = new MemberNode(null, member);
                    break;
                }
                case SIBLINGS: {
                    node = new CallNode(null, "Siblings", Syntax.Property, new MemberNode(null, member));
                    break;
                }
                case CHILDREN: {
                    node = new CallNode(null, "Children", Syntax.Property, new MemberNode(null, member));
                    break;
                }
                case INCLUDE_CHILDREN: {
                    node = Olap4jNodeConverter.generateSetCall(new MemberNode(null, member), Olap4jNodeConverter.toOlap4j(member, Selection.Operator.CHILDREN));
                    break;
                }
                case DESCENDANTS: {
                    node = new CallNode(null, "Descendants", Syntax.Function, new MemberNode(null, member));
                    break;
                }
                case ANCESTORS: {
                    node = new CallNode(null, "Ascendants", Syntax.Function, new MemberNode(null, member));
                    break;
                }
                default: {
                    System.out.println("NOT IMPLEMENTED: " + (Object)((Object)oper));
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return node;
    }

    static ParseTreeNode toOlap4j(Level level, Selection.Operator oper) {
        CallNode node = null;
        try {
            switch (oper) {
                case MEMBERS: {
                    node = new CallNode(null, "Members", Syntax.Property, new LevelNode(null, level));
                    break;
                }
                default: {
                    System.out.println("NOT IMPLEMENTED: " + (Object)((Object)oper));
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return node;
    }

    private static List<AxisNode> toOlap4j(List<QueryAxis> axes) {
        ArrayList<AxisNode> axisList = new ArrayList<AxisNode>();
        for (QueryAxis axis : axes) {
            AxisNode axisNode = Olap4jNodeConverter.toOlap4j(axis);
            if (axisNode == null) continue;
            axisList.add(Olap4jNodeConverter.toOlap4j(axis));
        }
        return axisList;
    }

    private static ParseTreeNode toHierarchyConsistentNode(ParseTreeNode selectionNode, Integer maxDepth, QueryDimension qDim) {
        if (qDim.getInclusions().size() > 1) {
            HashMap<Integer, Level> levels = new HashMap<Integer, Level>();
            for (Selection s : qDim.getInclusions()) {
                Level lvl;
                Integer d;
                if (s.getRootElement() instanceof Member) {
                    d = ((Member)s.getRootElement()).getDepth();
                    if (levels.containsKey(d)) continue;
                    lvl = ((Member)s.getRootElement()).getLevel();
                    levels.put(d, lvl);
                    continue;
                }
                if (!(s.getRootElement() instanceof Level) || levels.containsKey(d = Integer.valueOf(((Level)s.getRootElement()).getDepth()))) continue;
                lvl = (Level)s.getRootElement();
                levels.put(d, lvl);
            }
            Object[] levelDepths = levels.keySet().toArray(new Integer[levels.keySet().size()]);
            Arrays.sort(levelDepths);
            ArrayList<CallNode> inConditions = new ArrayList<CallNode>();
            Integer i = 0;
            while (i < levelDepths.length - 1) {
                Object currentLevel = (Level)levels.get(levelDepths[i]);
                if ((Integer)levelDepths[i] < maxDepth && currentLevel.getLevelType() != Level.Type.ALL) {
                    CallNode currentMemberNode = new CallNode(null, "CurrentMember", Syntax.Property, new HierarchyNode(null, currentLevel.getHierarchy()));
                    CallNode ancestorNode = new CallNode(null, "Ancestor", Syntax.Function, currentMemberNode, new LevelNode(null, (Level)currentLevel));
                    ArrayList<ParseTreeNode> ancestorList = new ArrayList<ParseTreeNode>();
                    for (Selection anc : qDim.getInclusions()) {
                        Level l;
                        if (!(anc.getRootElement() instanceof Member) || !(l = ((Member)anc.getRootElement()).getLevel()).equals(levels.get(levelDepths[i]))) continue;
                        ancestorList.add(anc.visit());
                    }
                    if (ancestorList.size() > 0) {
                        CallNode ancestorSet = Olap4jNodeConverter.generateListSetCall(ancestorList);
                        CallNode inClause = new CallNode(null, "Exists", Syntax.Function, ancestorNode, ancestorSet);
                        CallNode count = new CallNode(null, "Count", Syntax.Property, inClause);
                        CallNode greaterZero = new CallNode(null, " > 0", Syntax.Postfix, count);
                        inConditions.add(greaterZero);
                    }
                }
                currentLevel = i;
                Integer n = i = Integer.valueOf(i + 1);
            }
            if (inConditions.size() > 0) {
                CallNode chainedIn = (CallNode)inConditions.get(0);
                if (inConditions.size() > 1) {
                    for (int c = 1; c < inConditions.size(); ++c) {
                        chainedIn = new CallNode(null, "AND", Syntax.Infix, chainedIn, (ParseTreeNode)inConditions.get(c));
                    }
                }
                return new CallNode(null, "Filter", Syntax.Function, Olap4jNodeConverter.generateSetCall(selectionNode), chainedIn);
            }
        }
        return selectionNode;
    }
}

