/*
 * Decompiled with CFR 0.152.
 */
package mondrian.web.taglib;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionBindingEvent;
import jakarta.servlet.http.HttpSessionBindingListener;
import javax.xml.parsers.ParserConfigurationException;
import mondrian.olap.Connection;
import mondrian.olap.DriverManager;
import mondrian.olap.Query;
import mondrian.olap.Result;
import mondrian.spi.CatalogLocator;
import mondrian.spi.impl.ServletContextCatalogLocator;
import mondrian.web.taglib.DomBuilder;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class ResultCache
implements HttpSessionBindingListener {
    private static final Logger LOGGER = Logger.getLogger(ResultCache.class);
    private static final String ATTR_NAME = "mondrian.web.taglib.ResultCache.";
    private Query query = null;
    private Result result = null;
    private Document document = null;
    private ServletContext servletContext;
    private Connection connection;

    private ResultCache(ServletContext context) {
        this.servletContext = context;
    }

    public static ResultCache getInstance(HttpSession session, ServletContext servletContext, String name) {
        String fqname = ATTR_NAME + name;
        ResultCache resultCache = (ResultCache)session.getAttribute(fqname);
        if (resultCache == null) {
            resultCache = new ResultCache(servletContext);
            session.setAttribute(fqname, (Object)resultCache);
        }
        return resultCache;
    }

    public void parse(String mdx) {
        if (this.connection != null) {
            this.query = this.connection.parseQuery(mdx);
            this.setDirty();
        } else {
            LOGGER.error((Object)"null connection");
        }
    }

    public Result getResult() {
        if (this.result == null) {
            long t1 = System.currentTimeMillis();
            this.result = this.connection.execute(this.query);
            long t2 = System.currentTimeMillis();
            LOGGER.debug((Object)("Execute query took " + (t2 - t1) + " millisec"));
        }
        return this.result;
    }

    public Document getDOM() {
        try {
            if (this.document == null) {
                this.document = DomBuilder.build(this.getResult());
            }
            return this.document;
        }
        catch (ParserConfigurationException e) {
            LOGGER.error((Object)e);
            throw new RuntimeException(e.toString());
        }
    }

    public Query getQuery() {
        return this.query;
    }

    public void setQuery(Query query) {
        this.query = query;
        this.setDirty();
    }

    public void setDirty() {
        this.result = null;
        this.document = null;
    }

    public void valueBound(HttpSessionBindingEvent ev) {
        String connectString = this.servletContext.getInitParameter("connectString");
        LOGGER.debug((Object)("connectString: " + connectString));
        this.connection = DriverManager.getConnection(connectString, (CatalogLocator)new ServletContextCatalogLocator(this.servletContext));
        if (this.connection == null) {
            throw new RuntimeException("No ROLAP connection from connectString: " + connectString);
        }
    }

    public void valueUnbound(HttpSessionBindingEvent ev) {
        if (this.connection != null) {
            this.connection.close();
        }
    }
}

