/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi.impl;

import mondrian.olap.Util;
import mondrian.spi.CellFormatter;
import mondrian.spi.DataSourceResolver;
import mondrian.spi.DynamicSchemaProcessor;
import mondrian.spi.MemberFormatter;
import mondrian.spi.PropertyFormatter;
import mondrian.spi.RoleGenerator;
import mondrian.spi.UserDefinedFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scripts {
    private static <T> T create(ScriptDefinition script, Class<T> iface, String script2) {
        String engineName = script.language.engineName;
        return Util.compileScript(iface, script2, engineName);
    }

    private static String simple(ScriptDefinition script, String decl) {
        switch (script.language) {
            case JAVASCRIPT: {
                return "function " + decl + " { " + script.script + " }";
            }
        }
        throw Util.unexpected(script.language);
    }

    public static PropertyFormatter propertyFormatter(ScriptDefinition script) {
        return Scripts.create(script, PropertyFormatter.class, Scripts.simple(script, "formatProperty(member,propertyName,propertyValue)"));
    }

    public static MemberFormatter memberFormatter(ScriptDefinition script) {
        return Scripts.create(script, MemberFormatter.class, Scripts.simple(script, "formatMember(member)"));
    }

    public static CellFormatter cellFormatter(ScriptDefinition script) {
        return Scripts.create(script, CellFormatter.class, Scripts.simple(script, "formatCell(value)"));
    }

    public static RoleGenerator roleGenerator(ScriptDefinition script) {
        return Scripts.create(script, RoleGenerator.class, Scripts.simple(script, "asXml(context)"));
    }

    public static DataSourceResolver dataSourceResolver(ScriptDefinition script) {
        return Scripts.create(script, DataSourceResolver.class, Scripts.simple(script, "lookup(dataSourceName)"));
    }

    public static DynamicSchemaProcessor dynamicSchemaProcessor(ScriptDefinition script) {
        return Scripts.create(script, DynamicSchemaProcessor.class, Scripts.simple(script, "processSchema(schemaUrl, connectInfo)"));
    }

    public static UserDefinedFunction userDefinedFunction(ScriptDefinition script, String name) {
        String code;
        switch (script.language) {
            case JAVASCRIPT: {
                code = "var mondrian = Packages.mondrian;\nfunction getName() {\n  return " + Util.quoteJavaString(name) + ";\n" + "}\n" + "function getDescription() {\n" + "  return this.getName();\n" + "}\n" + "function getSyntax() {\n" + "  return mondrian.olap.Syntax.Function;\n" + "}\n" + "function getParameterTypes() {\n" + "  return new Array();\n" + "}\n" + "function getReturnType(parameterTypes) {\n" + "  return new mondrian.olap.type.ScalarType();\n" + "}\n" + "function getReservedWords() {\n" + "  return null;\n" + "}\n" + "function execute(evaluator, arguments) {\n" + "  return null;\n" + "}\n" + script.script;
                break;
            }
            default: {
                throw Util.unexpected(script.language);
            }
        }
        return Scripts.create(script, UserDefinedFunction.class, code);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScriptLanguage {
        JAVASCRIPT("JavaScript");

        final String engineName;

        private ScriptLanguage(String engineName) {
            this.engineName = engineName;
        }

        public static ScriptLanguage lookup(String languageName) {
            for (ScriptLanguage scriptLanguage : ScriptLanguage.values()) {
                if (!scriptLanguage.engineName.equals(languageName)) continue;
                return scriptLanguage;
            }
            return null;
        }
    }

    public static class ScriptDefinition {
        public final String script;
        public final ScriptLanguage language;

        public ScriptDefinition(String script, ScriptLanguage language) {
            this.script = script;
            this.language = language;
            assert (script != null);
            assert (language != null);
        }
    }
}

