/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi;

import java.util.List;
import mondrian.olap.Util;
import mondrian.rolap.DefaultDataServicesProvider;
import mondrian.spi.DataServicesProvider;
import mondrian.util.ServiceDiscovery;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;

public class DataServicesLocator {
    public static DataServicesProvider getDataServicesProvider(final String className) {
        Predicate providerNamePredicate;
        if (Util.isEmpty(className)) {
            return new DefaultDataServicesProvider();
        }
        ServiceDiscovery<DataServicesProvider> discovery = ServiceDiscovery.forClass(DataServicesProvider.class);
        List<Class<DataServicesProvider>> implementors = discovery.getImplementor();
        Class provider = (Class)CollectionUtils.find(implementors, (Predicate)(providerNamePredicate = new Predicate(){

            public boolean evaluate(Object o) {
                Class providerClass = (Class)o;
                return providerClass.getName().equals(className);
            }
        }));
        if (provider != null) {
            try {
                return (DataServicesProvider)provider.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("Unrecognized Service Provider: " + className);
    }
}

