/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.List;
import mondrian.rolap.BitKey;
import mondrian.rolap.RolapStar;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.agg.Segment;
import mondrian.rolap.agg.SegmentAxis;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupingSet {
    private final List<Segment> segments;
    final Segment segment0;
    private final BitKey levelBitKey;
    private final BitKey measureBitKey;
    private final StarColumnPredicate[] predicates;
    private final SegmentAxis[] axes;
    private final RolapStar.Column[] columns;

    public GroupingSet(List<Segment> segments, BitKey levelBitKey, BitKey measureBitKey, StarColumnPredicate[] predicates, RolapStar.Column[] columns) {
        this.segments = segments;
        this.segment0 = segments.get(0);
        this.levelBitKey = levelBitKey;
        this.measureBitKey = measureBitKey;
        this.predicates = predicates;
        this.axes = new SegmentAxis[predicates.length];
        this.columns = columns;
    }

    public List<Segment> getSegments() {
        return this.segments;
    }

    public BitKey getLevelBitKey() {
        return this.levelBitKey;
    }

    public BitKey getMeasureBitKey() {
        return this.measureBitKey;
    }

    public SegmentAxis[] getAxes() {
        return this.axes;
    }

    public StarColumnPredicate[] getPredicates() {
        return this.predicates;
    }

    public RolapStar.Column[] getColumns() {
        return this.columns;
    }

    public void setSegmentsFailed() {
        for (Segment segment : this.segments) {
        }
    }
}

