/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import mondrian.rolap.BitKey;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.ListPredicate;
import mondrian.rolap.agg.Predicates;
import mondrian.rolap.agg.ValueColumnPredicate;
import mondrian.spi.Dialect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndPredicate
extends ListPredicate {
    public AndPredicate(List<StarPredicate> predicateList) {
        super(predicateList);
    }

    @Override
    public boolean evaluate(List<Object> valueList) {
        for (StarPredicate childPredicate : this.children) {
            if (!childPredicate.evaluate(valueList)) continue;
            return true;
        }
        return false;
    }

    @Override
    public StarPredicate and(StarPredicate predicate) {
        if (predicate instanceof AndPredicate) {
            ListPredicate that = (ListPredicate)predicate;
            ArrayList<StarPredicate> list = new ArrayList<StarPredicate>(this.children);
            list.addAll(that.children);
            return new AndPredicate(list);
        }
        ArrayList<StarPredicate> list = new ArrayList<StarPredicate>(this.children);
        list.add(predicate);
        return new AndPredicate(list);
    }

    @Override
    public StarPredicate or(StarPredicate predicate) {
        return Predicates.or(Arrays.asList(this, predicate));
    }

    public BitKey checkInList(Dialect dialect, BitKey inListLhsBitKey) {
        BitKey inListRhsBitKey = inListLhsBitKey.copy();
        if (!this.getConstrainedColumnBitKey().equals(inListLhsBitKey) || this.children.size() > 1 && !dialect.supportsMultiValueInExpr()) {
            inListRhsBitKey.clear();
        } else {
            for (StarPredicate predicate : this.children) {
                if (predicate instanceof ValueColumnPredicate) {
                    ValueColumnPredicate columnPred = (ValueColumnPredicate)predicate;
                    if (columnPred.getValue() != RolapUtil.sqlNullValue) continue;
                    inListRhsBitKey.clear(columnPred.getColumn().physColumn.ordinal());
                    continue;
                }
                inListRhsBitKey.clear();
                break;
            }
        }
        return inListRhsBitKey;
    }

    public void toInListSql(Dialect dialect, StringBuilder buf, BitKey inListRhsBitKey) {
        boolean multiValueInList;
        boolean bl = multiValueInList = this.children.size() > 1;
        if (multiValueInList) {
            buf.append("(");
        }
        TreeSet<ValueColumnPredicate> sortedPredicates = new TreeSet<ValueColumnPredicate>();
        for (StarPredicate predicate : this.children) {
            assert (predicate instanceof ValueColumnPredicate);
            if (!inListRhsBitKey.get(((ValueColumnPredicate)predicate).getColumn().physColumn.ordinal())) continue;
            sortedPredicates.add((ValueColumnPredicate)predicate);
        }
        int k = 0;
        for (ValueColumnPredicate predicate : sortedPredicates) {
            if (k++ > 0) {
                buf.append(", ");
            }
            dialect.quote(buf, predicate.getValue(), predicate.getColumn().physColumn.getDatatype());
        }
        if (multiValueInList) {
            buf.append(")");
        }
    }

    @Override
    protected String getOp() {
        return "and";
    }
}

