/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mondrian.rolap.RolapStar;
import mondrian.rolap.SqlStatement;
import mondrian.rolap.SqlTupleReader;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.PredicateColumn;
import mondrian.rolap.agg.Predicates;
import mondrian.rolap.agg.QuerySpec;
import mondrian.rolap.sql.Clause;
import mondrian.rolap.sql.SqlQueryBuilder;
import mondrian.spi.Dialect;
import mondrian.util.Ord;
import mondrian.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQuerySpec
implements QuerySpec {
    private final RolapStar star;
    protected final boolean countOnly;

    protected AbstractQuerySpec(RolapStar star, boolean countOnly) {
        this.star = star;
        this.countOnly = countOnly;
    }

    protected SqlQueryBuilder createQueryBuilder(String desc) {
        return new SqlQueryBuilder(this.getStar().getSqlQueryDialect(), desc, new SqlTupleReader.ColumnLayoutBuilder());
    }

    @Override
    public RolapStar getStar() {
        return this.star;
    }

    protected void addMeasure(RolapStar.Measure measure, String alias, SqlQueryBuilder queryBuilder) {
        String exprInner;
        if (!this.isPartOfSelect(measure)) {
            return;
        }
        assert (measure.getTable() == this.getStar().getFactTable());
        if (measure.getExpression() == null) {
            exprInner = "*";
        } else {
            exprInner = measure.getExpression().toSql();
            queryBuilder.addColumn(queryBuilder.column(measure.getExpression(), measure.getTable()), Clause.FROM);
        }
        String exprOuter = measure.getAggregator().getExpression(exprInner);
        queryBuilder.sqlQuery.addSelect(exprOuter, measure.getInternalType(), alias);
    }

    protected abstract boolean isAggregate();

    protected Map<String, String> nonDistinctGenerateSql(SqlQueryBuilder queryBuilder) {
        if (this.countOnly) {
            queryBuilder.sqlQuery.addSelect("count(*)", SqlStatement.Type.INT);
            queryBuilder.addRelation(queryBuilder.table(this.star.getFactTable().getPath()), SqlQueryBuilder.NullJoiner.INSTANCE);
        }
        for (Ord<Pair<RolapStar.Column, String>> ord : Ord.zip(this.getColumns())) {
            Dialect dialect;
            RolapStar.Column column = (RolapStar.Column)((Pair)ord.e).left;
            String alias = (String)((Pair)ord.e).right;
            StarColumnPredicate predicate = this.getColumnPredicate(ord.i);
            String where = Predicates.toSql(predicate, dialect = queryBuilder.getDialect());
            if (!where.equals("true")) {
                queryBuilder.sqlQuery.addWhere(where);
            }
            SqlQueryBuilder.Column queryColumn = queryBuilder.column(column.getExpression(), column.getTable());
            if (this.countOnly || !this.isPartOfSelect(column)) {
                queryBuilder.addColumn(queryColumn, Clause.FROM);
                continue;
            }
            queryBuilder.addColumn(queryColumn, Clause.SELECT.maybeGroup(this.isAggregate()).maybeOrder(this.isOrdered()), SqlQueryBuilder.NullJoiner.INSTANCE, alias);
        }
        this.extraPredicates(queryBuilder);
        for (Pair pair : this.getMeasures()) {
            this.addMeasure((RolapStar.Measure)pair.left, (String)pair.right, queryBuilder);
        }
        return Collections.emptyMap();
    }

    protected boolean isPartOfSelect(RolapStar.Column col) {
        return true;
    }

    protected boolean isPartOfSelect(RolapStar.Measure measure) {
        return true;
    }

    protected boolean isOrdered() {
        return false;
    }

    @Override
    public Pair<String, List<SqlStatement.Type>> generateSqlQuery(String desc) {
        SqlQueryBuilder queryBuilder = this.createQueryBuilder(desc);
        int k = this.getDistinctMeasureCount();
        Dialect dialect = queryBuilder.getDialect();
        Map<String, String> groupingSetsAliases = !dialect.allowsCountDistinct() && k > 0 || !dialect.allowsMultipleCountDistinct() && k > 1 ? this.distinctGenerateSql(queryBuilder, this.countOnly) : this.nonDistinctGenerateSql(queryBuilder);
        if (!this.countOnly) {
            this.addGroupingFunction(queryBuilder);
            this.addGroupingSets(queryBuilder, groupingSetsAliases);
        }
        return queryBuilder.toSqlAndTypes();
    }

    protected void addGroupingFunction(SqlQueryBuilder queryBuilder) {
        throw new UnsupportedOperationException();
    }

    protected void addGroupingSets(SqlQueryBuilder queryBuilder, Map<String, String> groupingSetsAliases) {
        throw new UnsupportedOperationException();
    }

    protected int getDistinctMeasureCount() {
        int k = 0;
        for (Pair<RolapStar.Measure, String> pair : this.getMeasures()) {
            if (!((RolapStar.Measure)pair.left).getAggregator().isDistinct()) continue;
            ++k;
        }
        return k;
    }

    protected Map<String, String> distinctGenerateSql(SqlQueryBuilder outerQueryBuilder, boolean countOnly) {
        Dialect dialect = outerQueryBuilder.getDialect();
        Dialect.DatabaseProduct databaseProduct = dialect.getDatabaseProduct();
        HashMap<String, String> groupingSetsAliases = new HashMap<String, String>();
        SqlQueryBuilder innerQueryBuilder = this.createQueryBuilder("distinct segment");
        boolean distinct = databaseProduct != Dialect.DatabaseProduct.GREENPLUM;
        innerQueryBuilder.sqlQuery.setDistinct(distinct);
        for (Ord<Pair<RolapStar.Column, String>> ord : Ord.zip(this.getColumns())) {
            RolapStar.Column column = (RolapStar.Column)((Pair)ord.e).left;
            String expr = column.getExpression().toSql();
            SqlQueryBuilder.Column queryBuilderColumn = innerQueryBuilder.column(column.getExpression(), column.getTable());
            StarColumnPredicate predicate = this.getColumnPredicate(ord.i);
            String where = Predicates.toSql(predicate, dialect);
            if (!where.equals("true")) {
                innerQueryBuilder.sqlQuery.addWhere(where);
            }
            if (countOnly) {
                innerQueryBuilder.addColumn(queryBuilderColumn, Clause.FROM);
                continue;
            }
            int x = innerQueryBuilder.addColumn(queryBuilderColumn, Clause.SELECT.maybeGroup(!distinct), null, "d" + ord.i);
            String alias = innerQueryBuilder.sqlQuery.getAlias(x);
            String quotedAlias = dialect.quoteIdentifier(alias);
            outerQueryBuilder.sqlQuery.addSelectGroupBy(quotedAlias, null);
            groupingSetsAliases.put(expr, dialect.quoteIdentifier("dummyname." + alias));
        }
        this.extraPredicates(innerQueryBuilder);
        for (Pair pair : this.getMeasures()) {
            RolapStar.Measure measure = (RolapStar.Measure)pair.left;
            assert (measure.getTable() == this.getStar().getFactTable());
            int x = innerQueryBuilder.addColumn(innerQueryBuilder.column(measure.getExpression(), measure.getTable()), Clause.SELECT.maybeGroup(!distinct), null, (String)pair.right);
            String alias = innerQueryBuilder.sqlQuery.getAlias(x);
            String quotedAlias = dialect.quoteIdentifier(alias);
            outerQueryBuilder.sqlQuery.addSelect(measure.getAggregator().getNonDistinctAggregator().getExpression(quotedAlias), null);
        }
        outerQueryBuilder.sqlQuery.addFrom(innerQueryBuilder.sqlQuery, "dummyname", true);
        return groupingSetsAliases;
    }

    protected void extraPredicates(SqlQueryBuilder queryBuilder) {
        for (StarPredicate predicate : this.getPredicateList()) {
            for (PredicateColumn pair : predicate.getColumnList()) {
                queryBuilder.addColumn(queryBuilder.column(pair.physColumn, pair.router), Clause.FROM);
            }
            StringBuilder buf = new StringBuilder();
            predicate.toSql(queryBuilder.getDialect(), buf);
            String where = buf.toString();
            if (where.equals("true")) continue;
            queryBuilder.sqlQuery.addWhere(where);
        }
    }

    protected List<StarPredicate> getPredicateList() {
        return Collections.emptyList();
    }
}

