/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import mondrian.calc.TupleList;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Id;
import mondrian.olap.Larders;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Property;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;
import mondrian.rolap.BitKey;
import mondrian.rolap.DBStatement;
import mondrian.rolap.LevelColumnLayout;
import mondrian.rolap.MemberCache;
import mondrian.rolap.MemberReader;
import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.RolapAttribute;
import mondrian.rolap.RolapBaseCubeMeasure;
import mondrian.rolap.RolapClosure;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeDimension;
import mondrian.rolap.RolapCubeHierarchy;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMeasureGroup;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapMemberBase;
import mondrian.rolap.RolapProperty;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapStarSet;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.SqlConstraintFactory;
import mondrian.rolap.SqlConstraintUtils;
import mondrian.rolap.SqlContextConstraint;
import mondrian.rolap.SqlStatement;
import mondrian.rolap.SqlTupleReader;
import mondrian.rolap.TupleReader;
import mondrian.rolap.agg.AggregationManager;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.aggmatcher.AggStar;
import mondrian.rolap.sql.Clause;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.MemberKeyConstraint;
import mondrian.rolap.sql.SqlQuery;
import mondrian.rolap.sql.SqlQueryBuilder;
import mondrian.rolap.sql.TupleConstraint;
import mondrian.server.Locus;
import mondrian.server.monitor.SqlStatementEvent;
import mondrian.spi.Dialect;
import mondrian.util.CreationException;
import mondrian.util.ObjectFactory;
import mondrian.util.Pair;
import org.eigenbase.util.property.StringProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlMemberSource
implements MemberReader,
TupleReader.MemberBuilder {
    private final SqlConstraintFactory sqlConstraintFactory = SqlConstraintFactory.instance();
    protected final RolapCubeHierarchy hierarchy;
    private final DataSource dataSource;
    private MemberCache cache;
    private int lastOrdinal = 0;
    private final Map<Object, Object> valuePool;

    SqlMemberSource(RolapCubeHierarchy hierarchy) {
        this.hierarchy = hierarchy;
        this.dataSource = hierarchy.getRolapSchema().getInternalConnection().getDataSource();
        this.valuePool = ValuePoolFactoryFactory.getValuePoolFactory().create(this);
    }

    @Override
    public RolapCubeHierarchy getHierarchy() {
        return this.hierarchy;
    }

    @Override
    public boolean setCache(MemberCache cache) {
        this.cache = cache;
        return true;
    }

    @Override
    public int getMemberCount() {
        int count = 0;
        for (RolapCubeLevel rolapCubeLevel : this.hierarchy.getLevelList()) {
            count += this.getLevelMemberCount(rolapCubeLevel);
        }
        return count;
    }

    @Override
    public RolapMember substitute(RolapMember member) {
        return member;
    }

    @Override
    public RolapMember desubstitute(RolapMember member) {
        return member;
    }

    @Override
    public RolapMember getMemberByKey(RolapCubeLevel level, List<Comparable> keyValues) {
        if (level.isAll()) {
            return null;
        }
        List<RolapMember> list = this.getMembersInLevel(level, new MemberKeyConstraint(level.attribute.getKeyList(), keyValues));
        switch (list.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return list.get(0);
            }
        }
        throw Util.newError("More than one member in level " + level + " with key " + keyValues);
    }

    @Override
    public RolapMember lookupMember(List<Id.Segment> uniqueNameParts, boolean failIfNotFound) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getLevelMemberCount(RolapCubeLevel level) {
        if (level.isAll()) {
            return 1;
        }
        if (level.isMeasure()) {
            return level.getHierarchy().getMemberReader().getMembersInLevel(level).size();
        }
        return this.getMemberCount(level, this.dataSource);
    }

    private int getMemberCount(RolapLevel level, DataSource dataSource) {
        boolean[] mustCount = new boolean[1];
        String sql = this.makeAttributeMemberCountSql(level.attribute, mustCount);
        SqlStatement stmt = RolapUtil.executeQuery(dataSource, sql, new Locus(Locus.peek().execution, "SqlMemberSource.getLevelMemberCount", "while counting members of level '" + level));
        try {
            int count;
            ResultSet resultSet = stmt.getResultSet();
            if (!mustCount[0]) {
                Util.assertTrue(resultSet.next());
                ++stmt.rowCount;
                count = resultSet.getInt(1);
            } else {
                ResultSetMetaData rmd = resultSet.getMetaData();
                int nColumns = rmd.getColumnCount();
                String[] colStrings = new String[nColumns];
                count = 0;
                while (resultSet.next()) {
                    ++stmt.rowCount;
                    boolean isEqual = true;
                    for (int i = 0; i < nColumns; ++i) {
                        String colStr = resultSet.getString(i + 1);
                        if (!Util.equals(colStr, colStrings[i])) {
                            isEqual = false;
                        }
                        colStrings[i] = colStr;
                    }
                    if (isEqual) continue;
                    ++count;
                }
            }
            int n = count;
            return n;
        }
        catch (SQLException e) {
            throw stmt.handle(e);
        }
        finally {
            stmt.close();
        }
    }

    private String makeAttributeMemberCountSql(RolapAttribute attribute, boolean[] mustCount) {
        mustCount[0] = false;
        SqlTupleReader.ColumnLayoutBuilder layoutBuilder = new SqlTupleReader.ColumnLayoutBuilder();
        Dialect dialect = this.getDialect();
        SqlQueryBuilder queryBuilder = new SqlQueryBuilder(dialect, "while generating query to count members in attribute " + attribute, layoutBuilder);
        SqlQuery sqlQuery = queryBuilder.sqlQuery;
        SqlQueryBuilder.Joiner joiner = SqlQueryBuilder.AutoJoiner.INSTANCE;
        if (!dialect.allowsFromQuery()) {
            ArrayList<String> columnList = new ArrayList<String>();
            int columnCount = 0;
            for (RolapSchema.PhysColumn column : attribute.getKeyList()) {
                if (columnCount > 0 && !dialect.allowsCompoundCountDistinct()) {
                    mustCount[0] = true;
                }
                queryBuilder.addColumn(queryBuilder.column(column, this.hierarchy.cubeDimension), Clause.FROM, joiner, null);
                String keyExp = column.toSql();
                if (columnCount > 0 && !dialect.allowsCompoundCountDistinct() && dialect.getDatabaseProduct() == Dialect.DatabaseProduct.SYBASE) {
                    keyExp = "convert(varchar, " + columnList + ")";
                }
                columnList.add(keyExp);
                ++columnCount;
            }
            if (mustCount[0]) {
                for (String colDef : columnList) {
                    String exp = dialect.generateCountExpression(colDef);
                    String alias = sqlQuery.addSelect(exp, null);
                    sqlQuery.addOrderBy(exp, alias, true, false, true, true);
                }
            } else {
                ArrayList<String> list = new ArrayList<String>();
                for (String colDef : columnList) {
                    list.add(dialect.generateCountExpression(colDef));
                }
                sqlQuery.addSelect("count(DISTINCT " + Util.commaList(list) + ")", null);
            }
            return (String)queryBuilder.toSqlAndTypes().left;
        }
        sqlQuery.setDistinct(true);
        for (RolapSchema.PhysColumn column : attribute.getKeyList()) {
            queryBuilder.addColumn(queryBuilder.column(column, this.hierarchy.cubeDimension), Clause.SELECT);
        }
        SqlQuery outerQuery = SqlQuery.newQuery(dialect, "while generating query to count members in attribute " + attribute);
        outerQuery.addSelect("count(*)", null);
        boolean failIfExists = true;
        queryBuilder.flush();
        outerQuery.addFrom(sqlQuery, "init", failIfExists);
        return outerQuery.toString();
    }

    @Override
    public List<RolapMember> getMembers() {
        return this.getMembers(this.dataSource);
    }

    /*
     * WARNING - void declaration
     */
    private List<RolapMember> getMembers(DataSource dataSource) {
        SqlTupleReader.ColumnLayoutBuilder layoutBuilder = new SqlTupleReader.ColumnLayoutBuilder();
        String sql = this.makeKeysSql(layoutBuilder, ((RolapLevel)Util.last(this.hierarchy.levelList)).attribute.getKeyList());
        List<SqlStatement.Type> types = layoutBuilder.types;
        SqlStatement stmt = RolapUtil.executeQuery(dataSource, sql, types, 0, 0, new SqlStatement.StatementLocus(null, "SqlMemberSource.getMembers", "while building member cache", SqlStatementEvent.Purpose.TUPLES, 0), -1, -1, null);
        SqlTupleReader.ColumnLayout columnLayout = layoutBuilder.toLayout();
        try {
            Map<Object, SqlStatement.Accessor> accessors = stmt.getAccessors();
            ArrayList<RolapMember> list = new ArrayList<RolapMember>();
            HashMap<Comparable, RolapMember> map = new HashMap<Comparable, RolapMember>();
            RolapMember root = null;
            if (this.hierarchy.hasAll()) {
                root = this.hierarchy.getAllMember();
                list.add(root);
            }
            int limit = MondrianProperties.instance().ResultLimit.get();
            ResultSet resultSet = stmt.getResultSet();
            while (resultSet.next()) {
                ++stmt.rowCount;
                if (limit > 0 && limit < stmt.rowCount) {
                    throw stmt.handle(MondrianResource.instance().MemberFetchLimitExceeded.ex(limit));
                }
                RolapMember member = root;
                for (RolapCubeLevel rolapCubeLevel : this.hierarchy.getLevelList()) {
                    LevelColumnLayout<Integer> levelLayout;
                    block24: {
                        if (rolapCubeLevel.isAll()) continue;
                        levelLayout = columnLayout.levelLayoutMap.get(rolapCubeLevel);
                        Comparable[] keyValues = new Comparable[rolapCubeLevel.attribute.getKeyList().size()];
                        for (int i = 0; i < levelLayout.getKeys().size(); ++i) {
                            int keyOrdinal = levelLayout.getKeys().get(i);
                            Comparable value = accessors.get(keyOrdinal).get();
                            keyValues[i] = SqlMemberSource.toComparable(value);
                        }
                        RolapMember parent = member;
                        Comparable key = keyValues[0];
                        if (keyValues.length == 1) {
                            member = (RolapMember)map.get(key);
                        } else {
                            member = (RolapMember)map.get(Arrays.asList(keyValues));
                            if (member == null) {
                                key = RolapMember.Key.create(keyValues);
                            }
                        }
                        if (member == null) {
                            Comparable orderKey;
                            String caption;
                            String nameValue;
                            Comparable captionValue = levelLayout.getCaptionKey() >= 0 ? accessors.get(levelLayout.getCaptionKey()).get() : null;
                            if (levelLayout.getNameKey() >= 0) {
                                Comparable comparable = accessors.get(levelLayout.getNameKey()).get();
                                nameValue = comparable == null ? null : String.valueOf(comparable);
                            } else {
                                Object var22_28 = null;
                                nameValue = null;
                            }
                            Larders.LarderBuilder builder = new Larders.LarderBuilder();
                            builder.add(Property.NAME, (Object)nameValue);
                            if (captionValue != null && !(caption = captionValue.toString()).equals(nameValue)) {
                                builder.caption(caption);
                            }
                            RolapMemberBase memberBase = new RolapMemberBase(parent, rolapCubeLevel, key, Member.MemberType.REGULAR, RolapMemberBase.deriveUniqueName(parent, rolapCubeLevel, nameValue, false), builder.build());
                            memberBase.setOrdinal(this.lastOrdinal++);
                            member = memberBase;
                            list.add(member);
                            map.put(key, member);
                            switch (levelLayout.getOrderBySource()) {
                                case NONE: {
                                    break block24;
                                }
                                case KEY: {
                                    orderKey = key;
                                    break;
                                }
                                case NAME: {
                                    void var22_29;
                                    orderKey = var22_29;
                                    break;
                                }
                                case MAPPED: {
                                    orderKey = SqlMemberSource.getCompositeKey(accessors, levelLayout.getOrderByKeys());
                                    break;
                                }
                                default: {
                                    throw Util.unexpected(levelLayout.getOrderBySource());
                                }
                            }
                            ((RolapMemberBase)member).setOrderKey(orderKey);
                        }
                    }
                    int i = 0;
                    for (Property property : rolapCubeLevel.attribute.getProperties()) {
                        int propertyOrdinal = levelLayout.getPropertyKeys().get(i++);
                        member.setProperty(property, (Object)accessors.get(propertyOrdinal).get());
                    }
                }
            }
            ArrayList<RolapMember> arrayList = list;
            return arrayList;
        }
        catch (SQLException e) {
            throw stmt.handle(e);
        }
        finally {
            stmt.close();
        }
    }

    private Dialect getDialect() {
        return this.hierarchy.getDimension().getSchema().getDialect();
    }

    public static Comparable toComparable(Object value) {
        if (value == null) {
            return RolapUtil.sqlNullValue;
        }
        if (value instanceof byte[]) {
            return new String((byte[])value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return (Comparable)value;
    }

    private String makeKeysSql(SqlTupleReader.ColumnLayoutBuilder layoutBuilder, List<RolapSchema.PhysColumn> keyList) {
        SqlQuery sqlQuery = SqlQuery.newQuery(this.getDialect(), "while generating query to retrieve members of " + this.hierarchy);
        SqlQueryBuilder queryBuilder = new SqlQueryBuilder(sqlQuery, layoutBuilder, keyList);
        SqlQueryBuilder.Joiner joiner = SqlQueryBuilder.AutoJoiner.INSTANCE;
        RolapCubeDimension dimension = this.hierarchy.cubeDimension;
        queryBuilder.addColumns(keyList, dimension, Clause.FROM, joiner);
        for (RolapCubeLevel rolapCubeLevel : this.hierarchy.getLevelList()) {
            queryBuilder.addColumns(rolapCubeLevel.getOrderByList(), dimension, Clause.SELECT_ORDER, joiner);
            queryBuilder.addColumns(rolapCubeLevel.attribute.getKeyList(), dimension, Clause.SELECT_GROUP, joiner);
            for (RolapProperty property : rolapCubeLevel.attribute.getExplicitProperties()) {
                queryBuilder.addColumns(property.attribute.getKeyList(), dimension, Clause.SELECT.maybeGroup(!sqlQuery.getDialect().allowsSelectNotInGroupBy()), joiner);
            }
        }
        return sqlQuery.toSql();
    }

    @Override
    public List<RolapMember> getMembersInLevel(RolapCubeLevel level) {
        TupleConstraint constraint = this.sqlConstraintFactory.getLevelMembersConstraint(null);
        return this.getMembersInLevel(level, constraint);
    }

    @Override
    public List<RolapMember> getMembersInLevel(RolapCubeLevel level, TupleConstraint constraint) {
        if (level.isAll()) {
            return Collections.singletonList(this.hierarchy.getAllMember());
        }
        SqlTupleReader tupleReader = new SqlTupleReader(constraint);
        tupleReader.addLevelMembers(level, this, null);
        TupleList tupleList = tupleReader.readMembers(this.hierarchy.getDimension().getSchema().getDialect(), this.dataSource, null, null);
        assert (tupleList.getArity() == 1);
        return Util.cast(tupleList.slice(0));
    }

    @Override
    public MemberCache getMemberCache() {
        return this.cache;
    }

    @Override
    public Object getMemberCacheLock() {
        return this.cache;
    }

    @Override
    public List<RolapMember> getRootMembers() {
        return this.getMembersInLevel(this.hierarchy.getLevelList().get(0));
    }

    String makeChildMemberSql(RolapMember member, MemberChildrenConstraint constraint, SqlTupleReader.ColumnLayoutBuilder layoutBuilder) {
        Util.deprecated("make caption, key, name etc. properties of a level so can handle in a loop", false);
        Util.deprecated("remove commented code in this method", false);
        final RolapMeasureGroup aggMeasureGroup = SqlMemberSource.chooseAggStar(constraint, member);
        RolapStarSet starSet = constraint.createStarSet(aggMeasureGroup);
        Dialect dialect = this.getDialect();
        SqlQueryBuilder queryBuilder = new SqlQueryBuilder(dialect, "while generating query to retrieve children of member " + member, layoutBuilder);
        SqlQuery sqlQuery = queryBuilder.sqlQuery;
        constraint.addMemberConstraint(queryBuilder, starSet, member);
        RolapCubeLevel level = member.getLevel().getChildLevel();
        layoutBuilder.createLayoutFor(level);
        queryBuilder.joinToDimensionKey = true;
        Util.Function1<RolapSchema.PhysColumn, RolapSchema.PhysColumn> fn = Util.identityFunctor();
        if (starSet.getMeasureGroup() != null) {
            RolapSchema.PhysPath path;
            RolapMeasureGroup measureGroup;
            if (aggMeasureGroup != null) {
                measureGroup = aggMeasureGroup;
                fn = new Util.Function1<RolapSchema.PhysColumn, RolapSchema.PhysColumn>(){

                    @Override
                    public RolapSchema.PhysColumn apply(RolapSchema.PhysColumn param) {
                        for (Pair<RolapStar.Column, RolapSchema.PhysColumn> pair : aggMeasureGroup.copyColumnList) {
                            if (!((RolapSchema.PhysColumn)pair.right).equals(param)) continue;
                            return ((RolapStar.Column)pair.left).getExpression();
                        }
                        return param;
                    }
                };
            } else {
                measureGroup = starSet.getMeasureGroup();
            }
            queryBuilder.fact = measureGroup;
            if (Util.deprecated(false, false).booleanValue() && (path = measureGroup.getPath(level.getDimension())) != null) {
                for (RolapSchema.PhysHop hop : path.hopList) {
                    sqlQuery.addFrom(hop.relation, null, false);
                    if (hop.link == null) continue;
                    sqlQuery.addWhere(hop.link.sql);
                }
            }
        }
        constraint.addLevelConstraint(sqlQuery, starSet, level);
        if (sqlQuery.isUnsatisfiable()) {
            return null;
        }
        queryBuilder.addColumns(Util.transform(fn, member.getLevel().attribute.getKeyList()), member.getDimension(), Clause.FROM, SqlQueryBuilder.NullJoiner.INSTANCE, false);
        return this.projectProperties(layoutBuilder, queryBuilder, level, level.attribute.getProperties(), fn);
    }

    private String projectProperties(SqlTupleReader.ColumnLayoutBuilder layoutBuilder, SqlQueryBuilder queryBuilder, RolapCubeLevel level, List<RolapProperty> properties, Util.Function1<RolapSchema.PhysColumn, RolapSchema.PhysColumn> fn) {
        RolapSchema.PhysColumn exp;
        SqlQueryBuilder.NullJoiner joiner = SqlQueryBuilder.NullJoiner.INSTANCE;
        SqlTupleReader.LevelLayoutBuilder levelLayout = layoutBuilder.createLayoutFor(level);
        RolapCubeDimension dimension = level.cubeDimension;
        for (RolapSchema.PhysColumn key : level.getOrderByList()) {
            levelLayout.orderByOrdinalList.add(queryBuilder.addColumn(queryBuilder.column(fn.apply(key), dimension), Clause.SELECT_GROUP_ORDER, joiner, null, false));
        }
        for (RolapSchema.PhysColumn column : level.attribute.getKeyList()) {
            levelLayout.keyOrdinalList.add(queryBuilder.addColumn(queryBuilder.column(fn.apply(column), dimension), Clause.SELECT_GROUP, joiner, null, false));
        }
        if (level.attribute.getNameExp() != null) {
            exp = fn.apply(level.attribute.getNameExp());
            levelLayout.nameOrdinal = queryBuilder.addColumn(queryBuilder.column(exp, dimension), Clause.SELECT_GROUP, joiner, null);
        }
        if (level.attribute.getCaptionExp() != null) {
            exp = fn.apply(level.attribute.getCaptionExp());
            levelLayout.captionOrdinal = queryBuilder.addColumn(queryBuilder.column(exp, dimension), Clause.SELECT_GROUP, joiner, null);
        }
        for (RolapProperty property : properties) {
            RolapSchema.PhysColumn exp2 = fn.apply(property.attribute.getNameExp());
            Clause clause = !queryBuilder.sqlQuery.getDialect().allowsSelectNotInGroupBy() || !property.dependsOnLevelValue() ? Clause.SELECT_GROUP : Clause.SELECT;
            levelLayout.propertyOrdinalList.add(queryBuilder.addColumn(queryBuilder.column(exp2, dimension), clause, joiner, null));
        }
        Pair<String, List<SqlStatement.Type>> pair = queryBuilder.toSqlAndTypes();
        layoutBuilder.types.addAll((Collection)pair.right);
        return (String)pair.left;
    }

    private static AggStar chooseAggStar0(MemberChildrenConstraint constraint, RolapMember member) {
        RolapStar.Column[] columns;
        Util.deprecated("method not used; remove", true);
        if (!MondrianProperties.instance().UseAggregates.get() || !(constraint instanceof SqlContextConstraint)) {
            return null;
        }
        SqlContextConstraint contextConstraint = (SqlContextConstraint)constraint;
        Evaluator evaluator = contextConstraint.getEvaluator();
        RolapCube cube = (RolapCube)evaluator.getCube();
        RolapStar star = cube.getStar();
        int starColumnCount = star.getColumnCount();
        BitKey measureBitKey = BitKey.Factory.makeBitKey(starColumnCount);
        BitKey levelBitKey = BitKey.Factory.makeBitKey(starColumnCount);
        Member[] members = evaluator.getNonAllMembers();
        if (!(members[0] instanceof RolapBaseCubeMeasure)) {
            return null;
        }
        RolapBaseCubeMeasure measure = (RolapBaseCubeMeasure)members[0];
        int bitPosition = measure.getStarMeasure().getBitPosition();
        int ordinal = measure.getOrdinal();
        CellRequest request = RolapAggregationManager.makeRequest(members);
        if (request == null) {
            return null;
        }
        for (RolapStar.Column column1 : columns = request.getConstrainedColumns()) {
            levelBitKey.set(column1.getBitPosition());
        }
        levelBitKey.set(bitPosition);
        measureBitKey.set(ordinal);
        return AggregationManager.findAgg(star, levelBitKey, measureBitKey, new boolean[]{false});
    }

    private static RolapMeasureGroup chooseAggStar(MemberChildrenConstraint constraint, RolapMember member) {
        RolapStar.Column[] columns;
        if (!MondrianProperties.instance().UseAggregates.get()) {
            return null;
        }
        if (!(constraint instanceof SqlContextConstraint)) {
            return null;
        }
        SqlContextConstraint contextConstraint = (SqlContextConstraint)constraint;
        Evaluator evaluator = contextConstraint.getEvaluator();
        RolapMeasureGroup measureGroup = evaluator.getMeasureGroup();
        if (measureGroup == null) {
            return null;
        }
        RolapStar star = measureGroup.getStar();
        int starColumnCount = star.getColumnCount();
        BitKey measureBitKey = BitKey.Factory.makeBitKey(starColumnCount);
        BitKey levelBitKey = BitKey.Factory.makeBitKey(starColumnCount);
        Member[] members = evaluator.getNonAllMembers();
        RolapStoredMeasure measure = (RolapStoredMeasure)members[0];
        RolapCubeLevel level = member.getLevel().getChildLevel();
        for (RolapSchema.PhysColumn column : level.attribute.getKeyList()) {
            RolapStar.Column starColumn = measureGroup.getRolapStarColumn(level.cubeDimension, column, false);
            levelBitKey.set(starColumn.getBitPosition());
        }
        int ordinal = measure.getOrdinal();
        CellRequest request = RolapAggregationManager.makeRequest(members);
        if (request == null) {
            return null;
        }
        Util.deprecated("try using getConstrainedColumnsBitKey", false);
        for (RolapStar.Column column1 : columns = request.getConstrainedColumns()) {
            levelBitKey.set(column1.getBitPosition());
        }
        measureBitKey.set(ordinal);
        return ((RolapCube)evaluator.getCube()).galaxy.findAgg(star, levelBitKey, measureBitKey, new boolean[]{false});
    }

    public static boolean isLevelCollapsed(AggStar aggStar, RolapCubeLevel level, RolapMeasureGroup measureGroup) {
        if (level.isAll()) {
            return false;
        }
        RolapStar.Column starColumn = level.getBaseStarKeyColumn(measureGroup);
        int bitPos = starColumn.getBitPosition();
        AggStar.Table.Column aggColumn = aggStar.lookupColumn(bitPos);
        return aggColumn.getTable() instanceof AggStar.FactTable;
    }

    @Override
    public void getMemberChildren(List<RolapMember> parentMembers, List<RolapMember> children) {
        MemberChildrenConstraint constraint = this.sqlConstraintFactory.getMemberChildrenConstraint(null);
        this.getMemberChildren(parentMembers, children, constraint);
    }

    @Override
    public void getMemberChildren(List<RolapMember> parentMembers, List<RolapMember> children, MemberChildrenConstraint mcc) {
        RolapCubeLevel childLevel = this.getCommonChildLevelForDescendants(parentMembers);
        if (childLevel != null) {
            TupleConstraint lmc = this.sqlConstraintFactory.getDescendantsConstraint(parentMembers, mcc);
            List<RolapMember> list = this.getMembersInLevel(childLevel, lmc);
            children.addAll(list);
            return;
        }
        for (RolapMember parentMember : parentMembers) {
            this.getMemberChildren(parentMember, children, mcc);
        }
    }

    @Override
    public void getMemberChildren(RolapMember parentMember, List<RolapMember> children) {
        MemberChildrenConstraint constraint = this.sqlConstraintFactory.getMemberChildrenConstraint(null);
        this.getMemberChildren(parentMember, children, constraint);
    }

    @Override
    public void getMemberChildren(RolapMember parentMember, List<RolapMember> children, MemberChildrenConstraint constraint) {
        if (!parentMember.isAll() && parentMember.isCalculated() && !parentMember.getLevel().isParentChild()) {
            return;
        }
        this.getMemberChildren2(parentMember, children, constraint);
    }

    private RolapCubeLevel getCommonChildLevelForDescendants(List<RolapMember> parents) {
        if (parents.size() < 2) {
            return null;
        }
        RolapCubeLevel parentLevel = null;
        RolapCubeLevel childLevel = null;
        for (RolapMember member : parents) {
            if (member.isCalculated()) {
                return null;
            }
            if (parentLevel == null) {
                parentLevel = member.getLevel();
                if (parentLevel.isParentChild()) {
                    return null;
                }
                childLevel = parentLevel.getChildLevel();
                if (childLevel == null) {
                    return null;
                }
                if (!childLevel.isParentChild()) continue;
                return null;
            }
            if (parentLevel == member.getLevel()) continue;
            return null;
        }
        return childLevel;
    }

    private void getMemberChildren2(RolapMember parentMember, List<RolapMember> children, MemberChildrenConstraint constraint) {
        RolapCubeLevel childLevel;
        boolean parentChild;
        String sql;
        RolapCubeLevel parentLevel = parentMember.getLevel();
        SqlTupleReader.ColumnLayoutBuilder layoutBuilder = new SqlTupleReader.ColumnLayoutBuilder();
        if (parentLevel.isParentChild()) {
            sql = this.makeChildMemberSqlPC(parentMember, layoutBuilder);
            parentChild = true;
            childLevel = parentLevel;
        } else {
            childLevel = parentLevel.getChildLevel();
            if (childLevel == null) {
                return;
            }
            parentChild = childLevel.isParentChild();
            sql = parentChild ? this.makeChildMemberSql_PCRoot(parentMember, layoutBuilder) : this.makeChildMemberSql(parentMember, constraint, layoutBuilder);
        }
        if (sql == null) {
            return;
        }
        List<SqlStatement.Type> types = layoutBuilder.types;
        SqlStatement stmt = RolapUtil.executeQuery(this.dataSource, sql, types, 0, 0, new SqlStatement.StatementLocus(Locus.peek().execution, "SqlMemberSource.getMemberChildren", "while building member cache", SqlStatementEvent.Purpose.TUPLES, 0), -1, -1, null);
        try {
            LevelColumnLayout<Integer> layout;
            int limit = MondrianProperties.instance().ResultLimit.get();
            Map<Object, SqlStatement.Accessor> accessors = stmt.getAccessors();
            ResultSet resultSet = stmt.getResultSet();
            SqlTupleReader.ColumnLayout fullLayout = layoutBuilder.toLayout();
            LevelColumnLayout<Integer> levelColumnLayout = layout = parentChild && !parentMember.isAll() && childLevel.getParentAttribute() != null && childLevel.getClosure() != null ? fullLayout.levelLayoutMap.get(childLevel.getClosure().closedPeerLevel.getChildLevel()) : fullLayout.levelLayoutMap.get(childLevel);
            assert (layout != null) : "Error!!";
            while (resultSet.next()) {
                ++stmt.rowCount;
                if (limit > 0 && limit < stmt.rowCount) {
                    throw MondrianResource.instance().MemberFetchLimitExceeded.ex(limit);
                }
                Comparable[] keyValues = new Comparable[layout.getKeys().size()];
                for (int i = 0; i < layout.getKeys().size(); ++i) {
                    Comparable value = accessors.get(layout.getKeys().get(i)).get();
                    keyValues[i] = SqlMemberSource.toComparable(value);
                }
                RolapMember member = this.cache.getMember(childLevel, RolapMember.Key.quick(keyValues));
                if (member == null) {
                    Comparable orderKey;
                    String nameValue;
                    Comparable nameObject;
                    Comparable keyClone = RolapMember.Key.create(keyValues);
                    Comparable captionValue = layout.getCaptionKey() >= 0 ? accessors.get(layout.getCaptionKey()).get() : null;
                    if (layout.getNameKey() >= 0) {
                        nameObject = accessors.get(layout.getNameKey()).get();
                        nameValue = nameObject == null ? RolapUtil.mdxNullLiteral() : String.valueOf(nameObject);
                    } else {
                        nameObject = null;
                        nameValue = null;
                    }
                    switch (layout.getOrderBySource()) {
                        case NONE: {
                            orderKey = null;
                            break;
                        }
                        case KEY: {
                            orderKey = keyClone;
                            break;
                        }
                        case NAME: {
                            orderKey = nameObject;
                            break;
                        }
                        case MAPPED: {
                            orderKey = SqlMemberSource.getCompositeKey(accessors, layout.getOrderByKeys());
                            break;
                        }
                        default: {
                            throw Util.unexpected(layout.getOrderBySource());
                        }
                    }
                    member = this.makeMember(parentMember, childLevel, keyClone, captionValue, nameValue, orderKey, parentChild, stmt, layout);
                }
                children.add(member);
            }
        }
        catch (SQLException e) {
            throw stmt.handle(e);
        }
        finally {
            stmt.close();
        }
    }

    @Override
    public RolapMember makeMember(RolapMember parentMember, RolapCubeLevel childLevel, Comparable key, Object captionValue, String nameValue, Comparable orderKey, boolean parentChild, DBStatement stmt, LevelColumnLayout layout) throws SQLException {
        String caption;
        Larders.LarderBuilder builder = new Larders.LarderBuilder();
        builder.add(Property.NAME, (Object)nameValue);
        if (captionValue != null && !(caption = captionValue.toString()).equals(nameValue)) {
            builder.caption(caption);
        }
        RolapMemberBase member = new RolapMemberBase(parentMember, childLevel, key, Member.MemberType.REGULAR, RolapMemberBase.deriveUniqueName(parentMember, childLevel, nameValue, false), builder.build());
        assert (parentMember == null || parentMember.getLevel().getDepth() == childLevel.getDepth() - 1 || childLevel.isParentChild());
        this.setOrderKey(orderKey, layout, member);
        if (parentChild) {
            member = childLevel.hasClosedPeer() ? new RolapParentChildMember(parentMember, childLevel, key, member) : new RolapParentChildMemberNoClosure(parentMember, childLevel, key, member);
            this.setOrderKey(orderKey, layout, member);
        }
        Map<Object, SqlStatement.Accessor> accessors = stmt.getAccessors();
        if (layout.getNameKey() != layout.getKeys().get(layout.getKeys().size() - 1)) {
            // empty if block
        }
        int j = 0;
        for (RolapProperty property : childLevel.attribute.getExplicitProperties()) {
            member.setProperty(property, (Object)this.getPooledValue(accessors.get(layout.getPropertyKeys().get(j++)).get()));
        }
        this.cache.putMember(member.getLevel(), key, member);
        return member;
    }

    private void setOrderKey(Comparable orderKey, LevelColumnLayout layout, RolapMemberBase member) {
        if (layout.getOrderBySource() != LevelColumnLayout.OrderKeySource.NONE) {
            if (Util.deprecated(true, false).booleanValue()) {
                member.setOrdinal(this.lastOrdinal++);
            }
            member.setOrderKey(orderKey);
        }
    }

    static Comparable getCompositeKey(final Map<Object, SqlStatement.Accessor> accessors, final List<Integer> ordinals) throws SQLException {
        switch (ordinals.size()) {
            case 0: {
                return Util.COMPARABLE_EMPTY_LIST;
            }
            case 1: {
                Comparable o = accessors.get(ordinals.get(0)).get();
                return SqlMemberSource.toComparable(o);
            }
        }
        return (Comparable)((Object)Util.flatList(new AbstractList<Comparable>(){

            @Override
            public Comparable get(int index) {
                try {
                    Comparable value = ((SqlStatement.Accessor)accessors.get(ordinals.get(index))).get();
                    return SqlMemberSource.toComparable(value);
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public int size() {
                return ordinals.size();
            }
        }));
    }

    @Override
    public RolapMember allMember() {
        return this.hierarchy.getAllMember();
    }

    private <T> T getPooledValue(T incoming) {
        if (this.valuePool == null) {
            return incoming;
        }
        Object ret = this.valuePool.get(incoming);
        if (ret != null) {
            return (T)ret;
        }
        this.valuePool.put(incoming, incoming);
        return incoming;
    }

    private String makeChildMemberSql_PCRoot(RolapMember member, SqlTupleReader.ColumnLayoutBuilder layoutBuilder) {
        SqlQueryBuilder queryBuilder = new SqlQueryBuilder(this.getDialect(), "while generating query to retrieve children of parent/child hierarchy member " + member, layoutBuilder);
        assert (member.isAll()) : "In the current implementation, parent/child hierarchies must have only one level (plus the 'All' level).";
        RolapCubeLevel level = member.getLevel().getChildLevel();
        assert (!level.isAll()) : "all level cannot be parent-child";
        StringBuilder condition = new StringBuilder(64);
        for (RolapSchema.PhysColumn parentKey : level.getParentAttribute().getKeyList()) {
            queryBuilder.addColumn(queryBuilder.column(parentKey, level.cubeDimension), Clause.FROM);
            String parentId = parentKey.toSql();
            condition.append(parentId);
        }
        String nullParentValue = level.getNullParentValue();
        if (nullParentValue == null || nullParentValue.equalsIgnoreCase("NULL")) {
            condition.append(" IS NULL");
        } else {
            try {
                Util.discard((double)Double.parseDouble(nullParentValue));
                condition.append(" = ");
                condition.append(nullParentValue);
            }
            catch (NumberFormatException e) {
                condition.append(" = ");
                Util.singleQuoteString(nullParentValue, condition);
            }
        }
        queryBuilder.sqlQuery.addWhere(condition.toString());
        return this.projectProperties(layoutBuilder, queryBuilder, level, level.attribute.getProperties(), Util.<RolapSchema.PhysColumn>identityFunctor());
    }

    private String makeChildMemberSqlPC(RolapMember member, SqlTupleReader.ColumnLayoutBuilder layoutBuilder) {
        boolean haveClosure;
        Dialect dialect = this.getDialect();
        SqlQueryBuilder queryBuilder = new SqlQueryBuilder(dialect, "while generating query to retrieve children of parent/child hierarchy member " + member, layoutBuilder);
        RolapCubeLevel level = member.getLevel();
        RolapClosure closure = level.getClosure();
        boolean bl = haveClosure = level.isParentChild() && closure != null;
        if (haveClosure) {
            level = Util.first((RolapCubeLevel)closure.closedPeerLevel, level);
        }
        Util.assertTrue(!level.isAll(), "all level cannot be parent-child");
        RolapAttribute attribute = haveClosure ? level.getAttribute() : level.getParentAttribute();
        for (Pair<RolapSchema.PhysColumn, Comparable> pair : Pair.iterate(attribute.getKeyList(), member.getKeyAsList())) {
            RolapSchema.PhysColumn parentKey = (RolapSchema.PhysColumn)pair.left;
            Comparable keyVal = (Comparable)pair.right;
            SqlConstraintUtils.constrainLevel2(queryBuilder, parentKey, level.cubeDimension, keyVal);
        }
        if (closure != null && closure.distanceColumn != null) {
            queryBuilder.addColumn(queryBuilder.column(closure.distanceColumn, ((RolapCubeLevel)closure.closedPeerLevel).cubeDimension), Clause.FROM);
            queryBuilder.sqlQuery.addWhere(closure.distanceColumn.toSql() + " = 1");
        }
        RolapCubeLevel cubeLevel = haveClosure ? level.getChildLevel() : level;
        return this.projectProperties(layoutBuilder, queryBuilder, cubeLevel, member.getLevel().attribute.getProperties(), Util.<RolapSchema.PhysColumn>identityFunctor());
    }

    @Override
    public RolapMember getLeadMember(RolapMember member, int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void getMemberRange(RolapLevel level, RolapMember startMember, RolapMember endMember, List<RolapMember> memberList) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int compare(RolapMember m1, RolapMember m2, boolean siblingsAreEqual) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TupleReader.MemberBuilder getMemberBuilder() {
        return this;
    }

    @Override
    public RolapMember getDefaultMember() {
        throw new UnsupportedOperationException();
    }

    @Override
    public RolapMember getMemberParent(RolapMember member) {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ValuePoolFactoryFactory
    extends ObjectFactory.Singleton<ValuePoolFactory> {
        private static final ValuePoolFactoryFactory factory = new ValuePoolFactoryFactory();

        public static ValuePoolFactory getValuePoolFactory() {
            return (ValuePoolFactory)factory.getObject();
        }

        private ValuePoolFactoryFactory() {
            super(ValuePoolFactory.class);
        }

        @Override
        protected StringProperty getStringProperty() {
            return MondrianProperties.instance().SqlMemberSourceValuePoolFactoryClass;
        }

        @Override
        protected ValuePoolFactory getDefault(Class[] parameterTypes, Object[] parameterValues) throws CreationException {
            return new NullValuePoolFactory();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class NullValuePoolFactory
    implements ValuePoolFactory {
        @Override
        public Map<Object, Object> create(SqlMemberSource source) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ValuePoolFactory {
        public Map<Object, Object> create(SqlMemberSource var1);
    }

    private static class RolapParentChildMemberNoClosure
    extends RolapParentChildMember {
        public RolapParentChildMemberNoClosure(RolapMember parentMember, RolapCubeLevel childLevel, Comparable value, RolapMember dataMember) {
            super(parentMember, childLevel, value, dataMember);
        }

        protected boolean computeCalculated(Member.MemberType memberType) {
            return false;
        }

        public boolean isEvaluated() {
            return true;
        }

        public Exp getExpression() {
            return this.getHierarchy().getAggregateChildrenExpression();
        }
    }

    private static class RolapParentChildMember
    extends RolapMemberBase {
        private final RolapMember dataMember;
        private final int depth;

        public RolapParentChildMember(RolapMember parentMember, RolapCubeLevel childLevel, Comparable value, RolapMember dataMember) {
            super(parentMember, childLevel, value, dataMember.getMemberType(), RolapParentChildMember.deriveUniqueName(parentMember, childLevel, dataMember.getName(), false), Larders.ofName(dataMember.getName()));
            this.dataMember = dataMember;
            this.depth = parentMember != null ? parentMember.getDepth() + 1 : 0;
        }

        public RolapMember getDataMember() {
            return this.dataMember;
        }

        public int getDepth() {
            return this.depth;
        }

        public int getOrdinal() {
            return this.dataMember.getOrdinal();
        }
    }
}

