/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import mondrian.olap.Larder;
import mondrian.olap.Larders;
import mondrian.olap.Member;
import mondrian.olap.Property;
import mondrian.olap.Util;
import mondrian.rolap.RolapAggregator;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapMeasureGroup;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapMemberBase;
import mondrian.rolap.RolapResult;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapStoredMeasure;

class RolapVirtualCubeMeasure
extends RolapMemberBase
implements RolapStoredMeasure {
    private final RolapStoredMeasure cubeMeasure;
    private final Larder larder;
    private final RolapMeasureGroup measureGroup;

    RolapVirtualCubeMeasure(RolapMeasureGroup measureGroup, RolapMember parentMember, RolapCubeLevel level, RolapStoredMeasure cubeMeasure, Larder larder) {
        super(parentMember, level, (Comparable)((Object)cubeMeasure.getName()), Member.MemberType.MEASURE, RolapVirtualCubeMeasure.deriveUniqueName(parentMember, level, cubeMeasure.getName(), false), Larders.ofName(cubeMeasure.getName()));
        this.measureGroup = measureGroup;
        Util.deprecated("since all cubes are now virtual, is this class obsolete? we just need a way to clone RolapStoredMeasure in a different measure group", false);
        this.cubeMeasure = cubeMeasure;
        this.larder = larder;
    }

    public Object getPropertyValue(Property property) {
        Object value = super.getPropertyValue(property);
        if (value == null) {
            value = this.cubeMeasure.getPropertyValue(property);
        }
        return value;
    }

    public RolapStar.Measure getStarMeasure() {
        return this.cubeMeasure.getStarMeasure();
    }

    public RolapMeasureGroup getMeasureGroup() {
        return this.measureGroup;
    }

    public RolapSchema.PhysColumn getExpr() {
        return this.cubeMeasure.getExpr();
    }

    public RolapAggregator getAggregator() {
        return this.cubeMeasure.getAggregator();
    }

    public RolapResult.ValueFormatter getFormatter() {
        return this.cubeMeasure.getFormatter();
    }
}

