/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import mondrian.calc.Calc;
import mondrian.calc.DummyExp;
import mondrian.calc.ListCalc;
import mondrian.calc.impl.ValueCalc;
import mondrian.mdx.HierarchyExpr;
import mondrian.mdx.UnresolvedFunCall;
import mondrian.olap.Access;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Formula;
import mondrian.olap.Hierarchy;
import mondrian.olap.HierarchyBase;
import mondrian.olap.Id;
import mondrian.olap.Larder;
import mondrian.olap.Larders;
import mondrian.olap.Level;
import mondrian.olap.LocalizedProperty;
import mondrian.olap.MatchType;
import mondrian.olap.Member;
import mondrian.olap.OlapElement;
import mondrian.olap.Property;
import mondrian.olap.Role;
import mondrian.olap.SchemaReader;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.AggregateFunDef;
import mondrian.olap.fun.BuiltinFunTable;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.type.Type;
import mondrian.resource.MondrianResource;
import mondrian.rolap.DelegatingRolapMember;
import mondrian.rolap.MemberReader;
import mondrian.rolap.RestrictedMemberReader;
import mondrian.rolap.RolapAttribute;
import mondrian.rolap.RolapCalculatedMember;
import mondrian.rolap.RolapCubeHierarchy;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapDimension;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapEvaluatorRoot;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMeasure;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapMemberBase;
import mondrian.rolap.RolapResult;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapSchemaLoader;
import mondrian.rolap.RolapSharedAttribute;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.SubstitutingMemberReader;
import mondrian.rolap.sql.SqlQuery;
import mondrian.spi.CellFormatter;
import mondrian.spi.impl.Scripts;
import org.apache.log4j.Logger;
import org.olap4j.impl.NamedListImpl;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.NamedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolapHierarchy
extends HierarchyBase {
    private static final Logger LOGGER = Logger.getLogger(RolapHierarchy.class);
    protected RolapMember nullMember;
    private Exp aggregateChildrenExpression;
    protected RolapLevel nullLevel;
    protected RolapLevel allLevel;
    protected RolapMemberBase allMember;
    private static final int ALL_LEVEL_CARDINALITY = 1;
    private static final int NULL_LEVEL_CARDINALITY = 1;
    final RolapAttribute attribute;
    private final Larder larder;
    public final RolapHierarchy closureFor;
    final NamedList<RolapLevel> levelList = new NamedListImpl();
    public final boolean isScenario;
    private static final RolapSharedAttribute ALL_ATTRIBUTE = new RolapSharedAttribute("All", true, Collections.<RolapSchema.PhysColumn>emptyList(), null, null, Collections.<RolapSchema.PhysColumn>emptyList(), null, Level.Type.ALL, 1);
    private static final RolapSharedAttribute NULL_ATTRIBUTE = new RolapSharedAttribute("Null", true, Collections.<RolapSchema.PhysColumn>emptyList(), null, null, Collections.<RolapSchema.PhysColumn>emptyList(), null, Level.Type.NULL, 1);
    private static final RolapSharedAttribute MEASURES_ATTRIBUTE = new RolapSharedAttribute("Measures", true, Collections.<RolapSchema.PhysColumn>emptyList(), null, null, Collections.<RolapSchema.PhysColumn>emptyList(), null, Level.Type.REGULAR, Integer.MIN_VALUE);

    RolapHierarchy(RolapDimension dimension, String subName, String uniqueName, boolean visible, boolean hasAll, RolapHierarchy closureFor, RolapAttribute attribute, Larder larder) {
        super(dimension, subName, uniqueName, visible, hasAll);
        this.attribute = attribute;
        this.larder = larder;
        this.closureFor = closureFor;
        boolean bl = this.isScenario = subName != null && subName.equals("Scenario");
        assert (!this.isScenario || dimension.getDimensionType() == Dimension.Type.SCENARIO);
    }

    void initHierarchy(RolapSchemaLoader schemaLoader, String allLevelName) {
        if (this instanceof RolapCubeHierarchy) {
            throw new AssertionError();
        }
        this.allLevel = new RolapLevel(this, Util.first(allLevelName, "(All)"), true, 0, ALL_ATTRIBUTE.inDimension(this.getDimension()), null, Collections.<RolapSchema.PhysColumn>emptyList(), null, null, RolapLevel.HideMemberCondition.Never, Larders.EMPTY, schemaLoader.resourceMap);
        if (this.hasAll) {
            this.levelList.add((Object)this.allLevel);
        }
        this.nullLevel = new RolapLevel(this, Util.first(allLevelName, "(All)"), true, 0, NULL_ATTRIBUTE.inDimension(this.getDimension()), null, Collections.<RolapSchema.PhysColumn>emptyList(), null, null, RolapLevel.HideMemberCondition.Never, Larders.EMPTY, schemaLoader.resourceMap);
        if (this.dimension.isMeasures()) {
            this.levelList.add((Object)new RolapLevel(this, "MeasuresLevel", true, this.levelList.size(), MEASURES_ATTRIBUTE.inDimension(this.getDimension()), null, Collections.<RolapSchema.PhysColumn>emptyList(), null, null, RolapLevel.HideMemberCondition.Never, Larders.EMPTY, schemaLoader.resourceMap));
        }
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RolapHierarchy)) {
            return false;
        }
        RolapHierarchy that = (RolapHierarchy)o;
        return this.getUniqueName().equals(that.getUniqueName());
    }

    @Override
    public Larder getLarder() {
        return this.larder;
    }

    @Override
    public RolapDimension getDimension() {
        return (RolapDimension)this.dimension;
    }

    public final RolapSchema getRolapSchema() {
        return ((RolapDimension)this.dimension).schema;
    }

    @Override
    public RolapMember getDefaultMember() {
        throw new UnsupportedOperationException();
    }

    @Override
    public RolapMember getNullMember() {
        return this.nullMember;
    }

    @Override
    public RolapMember getAllMember() {
        return this.allMember;
    }

    @Override
    public Member createMember(Member parent, Level level, String name, Formula formula) {
        throw new UnsupportedOperationException();
    }

    void addToFromInverse(SqlQuery query, RolapSchema.PhysExpr expression) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Member> getLowestMembersForAccess(Evaluator evaluator, Role.HierarchyAccess hAccess, List<Member> currentList) {
        if (currentList == null) {
            currentList = FunUtil.getNonEmptyMemberChildren(evaluator, ((RolapEvaluator)evaluator).getExpanding());
        }
        boolean goesLower = false;
        for (Member member : currentList) {
            if (hAccess.getAccess(member) == Access.ALL) continue;
            goesLower = true;
            break;
        }
        if (goesLower) {
            ArrayList<Member> newList = new ArrayList<Member>();
            for (Member member : currentList) {
                int savepoint = evaluator.savepoint();
                try {
                    evaluator.setContext(member);
                    newList.addAll(FunUtil.getNonEmptyMemberChildren(evaluator, member));
                }
                finally {
                    evaluator.restore(savepoint);
                }
            }
            return this.getLowestMembersForAccess(evaluator, hAccess, newList);
        }
        return currentList;
    }

    @Override
    public boolean isRagged() {
        for (RolapLevel level : this.levelList) {
            if (level.getHideMemberCondition() == RolapLevel.HideMemberCondition.Never) continue;
            return true;
        }
        return false;
    }

    public synchronized Exp getAggregateChildrenExpression() {
        if (this.aggregateChildrenExpression == null) {
            UnresolvedFunCall fc = new UnresolvedFunCall("$AggregateChildren", Syntax.Internal, new Exp[]{new HierarchyExpr(this)});
            Validator validator = Util.createSimpleValidator(BuiltinFunTable.instance());
            this.aggregateChildrenExpression = fc.accept(validator);
        }
        return this.aggregateChildrenExpression;
    }

    public List<? extends RolapLevel> getLevelList() {
        return Util.cast(this.levelList);
    }

    static class DummyElement
    implements OlapElement {
        private final RolapHierarchy hierarchy;

        DummyElement(RolapHierarchy hierarchy) {
            this.hierarchy = hierarchy;
        }

        public String getUniqueName() {
            throw new UnsupportedOperationException();
        }

        public String getName() {
            return "$";
        }

        public String getDescription() {
            throw new UnsupportedOperationException();
        }

        public OlapElement lookupChild(SchemaReader schemaReader, Id.Segment s, MatchType matchType) {
            if (!(s instanceof Id.NameSegment)) {
                return null;
            }
            Id.NameSegment nameSegment = (Id.NameSegment)s;
            if (Util.equalName(nameSegment.name, this.hierarchy.dimension.getName())) {
                return this.hierarchy.dimension;
            }
            return null;
        }

        public String getQualifiedName() {
            throw new UnsupportedOperationException();
        }

        public String getCaption() {
            throw new UnsupportedOperationException();
        }

        public Hierarchy getHierarchy() {
            throw new UnsupportedOperationException();
        }

        public Dimension getDimension() {
            throw new UnsupportedOperationException();
        }

        public boolean isVisible() {
            throw new UnsupportedOperationException();
        }

        public String getLocalized(LocalizedProperty prop, Locale locale) {
            throw new UnsupportedOperationException();
        }
    }

    static class LimitedRollupAggregateCalc
    extends AggregateFunDef.AggregateCalc {
        public LimitedRollupAggregateCalc(Type returnType, ListCalc listCalc) {
            super(new DummyExp(returnType), listCalc, new ValueCalc(new DummyExp(returnType)));
        }
    }

    static class LimitedRollupSubstitutingMemberReader
    extends SubstitutingMemberReader {
        private final Role.HierarchyAccess hierarchyAccess;
        private final Exp exp;

        public LimitedRollupSubstitutingMemberReader(MemberReader memberReader, Role role, Role.HierarchyAccess hierarchyAccess, Exp exp) {
            super(new RestrictedMemberReader(memberReader, role));
            this.hierarchyAccess = hierarchyAccess;
            this.exp = exp;
        }

        public RolapMember substitute(RolapMember member) {
            if (member == null) {
                return null;
            }
            if (member instanceof RestrictedMemberReader.MultiCardinalityDefaultMember) {
                return new LimitedRollupMember(member.getParentMember(), this.exp);
            }
            if (this.hierarchyAccess.getAccess(member) == Access.CUSTOM || this.hierarchyAccess.hasInaccessibleDescendants(member)) {
                return new LimitedRollupMember(member, this.exp);
            }
            return member;
        }

        public RolapMember desubstitute(RolapMember member) {
            if (member instanceof LimitedRollupMember) {
                return ((LimitedRollupMember)member).member;
            }
            return member;
        }
    }

    public static class LimitedRollupMember
    extends DelegatingRolapMember {
        public final RolapMember member;
        private final Exp exp;

        LimitedRollupMember(RolapMember member, Exp exp) {
            super(member);
            assert (!(member instanceof LimitedRollupMember));
            this.member = member;
            this.exp = exp;
        }

        public boolean equals(Object o) {
            return o instanceof LimitedRollupMember && ((LimitedRollupMember)o).member.equals(this.member);
        }

        public int hashCode() {
            return this.member.hashCode();
        }

        public Exp getExpression() {
            return this.exp;
        }

        public Calc getCompiledExpression(RolapEvaluatorRoot root) {
            return root.getCompiled(this.getExpression(), true, null);
        }

        public boolean isCalculated() {
            return false;
        }

        public boolean isEvaluated() {
            return true;
        }
    }

    protected static class RolapCalculatedMeasure
    extends RolapCalculatedMember
    implements RolapMeasure {
        private RolapResult.ValueFormatter cellFormatter;

        public RolapCalculatedMeasure(RolapMember parent, RolapCubeLevel level, String name, Formula formula) {
            super(parent, level, name, formula);
        }

        public synchronized void setProperty(Property property, Object value) {
            if (property == Property.CELL_FORMATTER) {
                String cellFormatterClass = (String)value;
                try {
                    CellFormatter formatter = RolapSchemaLoader.getFormatter(cellFormatterClass, CellFormatter.class, null);
                    this.cellFormatter = new RolapResult.CellFormatterValueFormatter(formatter);
                }
                catch (Exception e) {
                    throw MondrianResource.instance().CellFormatterLoadFailed.ex(cellFormatterClass, this.getUniqueName(), e);
                }
            }
            if (property == Property.CELL_FORMATTER_SCRIPT) {
                String language = (String)this.getPropertyValue(Property.CELL_FORMATTER_SCRIPT_LANGUAGE);
                String scriptText = (String)value;
                try {
                    Scripts.ScriptDefinition script = new Scripts.ScriptDefinition(scriptText, Scripts.ScriptLanguage.lookup(language));
                    CellFormatter formatter = RolapSchemaLoader.getFormatter(null, CellFormatter.class, script);
                    this.cellFormatter = new RolapResult.CellFormatterValueFormatter(formatter);
                }
                catch (Exception e) {
                    throw MondrianResource.instance().CellFormatterLoadFailed.ex(scriptText, this.getUniqueName(), e);
                }
            }
            super.setProperty(property, value);
        }

        public RolapResult.ValueFormatter getFormatter() {
            return this.cellFormatter;
        }
    }

    static class RolapNullMember
    extends RolapMemberBase {
        RolapNullMember(RolapCubeLevel level) {
            super(null, level, Util.COMPARABLE_EMPTY_LIST, Member.MemberType.NULL, Util.makeFqName(level.getHierarchy(), RolapUtil.mdxNullLiteral()), Larders.ofName(RolapUtil.mdxNullLiteral()));
        }
    }
}

