/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import mondrian.olap.Id;
import mondrian.olap.Larders;
import mondrian.olap.Level;
import mondrian.olap.MatchType;
import mondrian.olap.OlapElement;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.rolap.RolapCacheRegion;
import mondrian.rolap.RolapClosure;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeDimension;
import mondrian.rolap.RolapCubeHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMeasureGroup;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapMemberBase;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapSchemaLoader;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.agg.MemberColumnPredicate;
import mondrian.rolap.agg.MemberPredicate;
import mondrian.rolap.agg.MemberTuplePredicate;
import mondrian.rolap.agg.PredicateColumn;
import mondrian.rolap.agg.Predicates;
import mondrian.rolap.agg.RangeColumnPredicate;
import mondrian.rolap.agg.ValueColumnPredicate;
import mondrian.spi.MemberFormatter;
import org.olap4j.metadata.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolapCubeLevel
extends RolapLevel {
    private final RolapLevel rolapLevel;
    private final RolapCubeLevel closedPeerCubeLevel;
    protected LevelReader levelReader;
    final RolapCubeHierarchy cubeHierarchy;
    final RolapCubeDimension cubeDimension;
    final RolapCube cube;
    private final RolapCubeLevel parentCubeLevel;
    private RolapCubeLevel childCubeLevel;

    public RolapCubeLevel(RolapLevel level, RolapCubeHierarchy cubeHierarchy, Map<String, List<Larders.Resource>> resourceMap, RolapClosure closure) {
        super(cubeHierarchy, level.getName(), level.isVisible(), level.getDepth(), level.attribute, level.parentAttribute, level.getOrderByList(), level.nullParentValue, closure, level.getHideMemberCondition(), level.getLarder(), resourceMap);
        this.rolapLevel = level;
        this.cubeHierarchy = cubeHierarchy;
        this.cubeDimension = cubeHierarchy.getDimension();
        this.cube = this.cubeDimension.getCube();
        this.parentCubeLevel = (RolapCubeLevel)super.getParentLevel();
        if (this.parentCubeLevel != null) {
            this.parentCubeLevel.childCubeLevel = this;
        }
        this.attribute = level.getAttribute();
        RolapCubeLevel rolapCubeLevel = this.closedPeerCubeLevel = closure == null ? null : (RolapCubeLevel)closure.closedPeerLevel;
        assert (closure == null || ((RolapCubeLevel)closure.closedPeerLevel).getRolapLevel() == level.closure.closedPeerLevel);
    }

    @Override
    void initLevel(RolapSchemaLoader schemaLoader) {
        super.initLevel(schemaLoader);
        this.levelReader = this.isAll() ? new AllLevelReaderImpl() : (this.getLevelType() == Level.Type.NULL ? new NullLevelReader() : (this.hasClosedPeer() ? new ParentChildLevelReaderImpl(this) : new RegularLevelReader(this)));
    }

    LevelReader getLevelReader() {
        return this.levelReader;
    }

    public boolean isMeasure() {
        return this.cubeHierarchy.getOrdinalInCube() == 0;
    }

    protected boolean isTooRagged() {
        if (this.getDepth() == this.getHierarchy().getLevelList().size() - 1) {
            switch (this.getHideMemberCondition()) {
                case Never: 
                case IfBlankName: {
                    return false;
                }
            }
            return true;
        }
        return this.getHierarchy().isRagged();
    }

    public boolean isSimple() {
        if (this.isTooRagged()) {
            return false;
        }
        if (this.isParentChild()) {
            return false;
        }
        return !this.isMeasure();
    }

    public RolapStar.Column getBaseStarKeyColumn(RolapMeasureGroup measureGroup) {
        assert (measureGroup != null);
        throw new UnsupportedOperationException();
    }

    public final RolapCube getCube() {
        return this.cube;
    }

    @Override
    public final RolapCubeDimension getDimension() {
        return this.cubeDimension;
    }

    @Override
    public final RolapCubeHierarchy getHierarchy() {
        return this.cubeHierarchy;
    }

    @Override
    public final RolapCubeLevel getChildLevel() {
        return this.childCubeLevel;
    }

    @Override
    public final RolapCubeLevel getParentLevel() {
        return this.parentCubeLevel;
    }

    @Override
    public String getCaption() {
        return this.rolapLevel.getCaption();
    }

    public RolapLevel getRolapLevel() {
        return this.rolapLevel;
    }

    public boolean equals(RolapCubeLevel level) {
        if (this == level) {
            return true;
        }
        return super.equals(level) && this.getCube().equals(level.getCube());
    }

    boolean hasClosedPeer() {
        return this.closedPeerCubeLevel != null;
    }

    public RolapCubeLevel getClosedPeer() {
        return this.closedPeerCubeLevel;
    }

    @Override
    public MemberFormatter getMemberFormatter() {
        return this.rolapLevel.getMemberFormatter();
    }

    @Override
    public OlapElement lookupChild(SchemaReader schemaReader, Id.Segment name, MatchType matchType) {
        if (name instanceof Id.KeySegment) {
            Id.KeySegment keySegment = (Id.KeySegment)name;
            ArrayList<Comparable> keyValues = new ArrayList<Comparable>();
            for (Id.NameSegment nameSegment : keySegment.getKeyParts()) {
                String keyValue = nameSegment.name;
                if (RolapUtil.mdxNullLiteral().equalsIgnoreCase(keyValue)) {
                    keyValues.add(RolapUtil.sqlNullValue);
                    continue;
                }
                keyValues.add((Comparable)((Object)keyValue));
            }
            Collections.reverse(keyValues);
            final List<RolapSchema.PhysColumn> keyExps = this.attribute.getKeyList();
            if (keyExps.size() != keyValues.size()) {
                throw Util.newError("Wrong number of values in member key; " + keySegment + " has " + keyValues.size() + " values, whereas level's key has " + keyExps.size() + " columns " + new AbstractList<String>(){

                    @Override
                    public String get(int index) {
                        return ((RolapSchema.PhysColumn)keyExps.get(keyExps.size() - 1 - index)).toSql();
                    }

                    @Override
                    public int size() {
                        return keyExps.size();
                    }
                } + ".");
            }
            return this.cubeHierarchy.getMemberReader().getMemberByKey(this, keyValues);
        }
        List<RolapMember> levelMembers = Util.cast(schemaReader.getLevelMembers((Level)this, true));
        if (levelMembers.size() > 0) {
            RolapMember parent = ((RolapMember)levelMembers.get(0)).getParentMember();
            return RolapUtil.findBestMemberMatch(levelMembers, parent, this, name, matchType);
        }
        return null;
    }

    static final class NullLevelReader
    implements LevelReader {
        NullLevelReader() {
        }

        public boolean constrainRequest(RolapMember member, RolapMeasureGroup measureGroup, CellRequest request) {
            return true;
        }

        public void constrainRegion(StarPredicate predicate, RolapMeasureGroup measureGroup, RolapCacheRegion cacheRegion) {
        }
    }

    static final class AllLevelReaderImpl
    implements LevelReader {
        AllLevelReaderImpl() {
        }

        public boolean constrainRequest(RolapMember member, RolapMeasureGroup measureGroup, CellRequest request) {
            return false;
        }

        public void constrainRegion(StarPredicate predicate, RolapMeasureGroup measureGroup, RolapCacheRegion cacheRegion) {
        }
    }

    static final class ParentChildLevelReaderImpl
    implements LevelReader {
        private final RegularLevelReader regularLevelReader;
        private final RolapCubeLevel closedPeerLevel;
        private final RolapMember wrappedAllMember;

        ParentChildLevelReaderImpl(RolapCubeLevel cubeLevel) {
            this.regularLevelReader = new RegularLevelReader(cubeLevel);
            this.closedPeerLevel = cubeLevel.closedPeerCubeLevel;
            this.wrappedAllMember = this.closedPeerLevel.getHierarchy().allMember;
        }

        public boolean constrainRequest(RolapMember member, RolapMeasureGroup measureGroup, CellRequest request) {
            if (member.getDataMember() == null) {
                return this.regularLevelReader.constrainRequest(member, measureGroup, request);
            }
            if (request.drillThrough) {
                return this.regularLevelReader.constrainRequest(member.getDataMember(), measureGroup, request);
            }
            RolapMemberBase wrappedMember = new RolapMemberBase(this.wrappedAllMember, this.closedPeerLevel, member.getKeyCompact(), member.getMemberType(), Util.makeFqName(this.wrappedAllMember.getHierarchy(), member.getName()), Larders.ofName(member.getName()));
            return this.closedPeerLevel.getLevelReader().constrainRequest(wrappedMember, measureGroup, request);
        }

        public void constrainRegion(StarPredicate predicate, RolapMeasureGroup measureGroup, RolapCacheRegion cacheRegion) {
            throw new UnsupportedOperationException();
        }
    }

    static final class RegularLevelReader
    implements LevelReader {
        private RolapCubeLevel cubeLevel;

        RegularLevelReader(RolapCubeLevel cubeLevel) {
            this.cubeLevel = cubeLevel;
        }

        public boolean constrainRequest(RolapMember member, RolapMeasureGroup measureGroup, CellRequest request) {
            assert (member.getLevel() == this.cubeLevel);
            List<Comparable> key = member.getKeyAsList();
            if (key.isEmpty()) {
                if (member == member.getHierarchy().getNullMember()) {
                    return true;
                }
                if (member.isCalculated()) {
                    return false;
                }
                throw Util.newInternal("why is key empty?");
            }
            if (member.getDimension().hanger) {
                return false;
            }
            int keyOrdinal = 0;
            for (RolapSchema.PhysColumn column : this.cubeLevel.attribute.getKeyList()) {
                RolapStar.Column starColumn = measureGroup.getRolapStarColumn(this.cubeLevel.cubeDimension, column, false);
                if (starColumn == null) {
                    return member != this.cubeLevel.hierarchy.getDefaultMember() || this.cubeLevel.hierarchy.hasAll();
                }
                ValueColumnPredicate predicate = member.isCalculated() && !member.isParentChildLeaf() ? null : new ValueColumnPredicate(new PredicateColumn(new RolapSchema.CubeRouter(measureGroup, this.cubeLevel.cubeDimension), column), key.get(keyOrdinal));
                request.addConstrainedColumn(starColumn, predicate);
                ++keyOrdinal;
            }
            return false;
        }

        public void constrainRegion(StarPredicate predicate, RolapMeasureGroup measureGroup, RolapCacheRegion cacheRegion) {
            if (!measureGroup.existsLink(this.cubeLevel.cubeDimension)) {
                return;
            }
            if (predicate instanceof MemberPredicate) {
                MemberColumnPredicate memberColumnPredicate = (MemberColumnPredicate)predicate;
                RolapMember member = memberColumnPredicate.getMember();
                assert (member.getLevel() == this.cubeLevel);
                assert (!member.isCalculated());
                assert (memberColumnPredicate.getMember().getKey() != null);
                assert (!member.isNull());
                Util.deprecated("adding predicate multiple times?", false);
                for (RolapSchema.PhysColumn physColumn : this.cubeLevel.attribute.getKeyList()) {
                    cacheRegion.addPredicate(predicate);
                }
                return;
            }
            if (predicate instanceof RangeColumnPredicate) {
                RolapMember upperMember;
                RolapMember lowerMember;
                RangeColumnPredicate rangeColumnPredicate = (RangeColumnPredicate)predicate;
                ValueColumnPredicate lowerBound = rangeColumnPredicate.getLowerBound();
                if (lowerBound == null) {
                    lowerMember = null;
                } else if (lowerBound instanceof MemberColumnPredicate) {
                    MemberColumnPredicate memberColumnPredicate = (MemberColumnPredicate)lowerBound;
                    lowerMember = memberColumnPredicate.getMember();
                } else {
                    throw new UnsupportedOperationException();
                }
                ValueColumnPredicate upperBound = rangeColumnPredicate.getUpperBound();
                if (upperBound == null) {
                    upperMember = null;
                } else if (upperBound instanceof MemberColumnPredicate) {
                    MemberColumnPredicate memberColumnPredicate = (MemberColumnPredicate)upperBound;
                    upperMember = memberColumnPredicate.getMember();
                } else {
                    throw new UnsupportedOperationException();
                }
                MemberTuplePredicate predicate2 = Predicates.range(measureGroup.getStar().getSchema().physicalSchema, new RolapSchema.CubeRouter(measureGroup, this.cubeLevel.cubeDimension), lowerMember, !rangeColumnPredicate.getLowerInclusive(), upperMember, !rangeColumnPredicate.getUpperInclusive());
                cacheRegion.addPredicate(predicate2);
                return;
            }
            throw new UnsupportedOperationException();
        }
    }

    static interface LevelReader {
        public boolean constrainRequest(RolapMember var1, RolapMeasureGroup var2, CellRequest var3);

        public void constrainRegion(StarPredicate var1, RolapMeasureGroup var2, RolapCacheRegion var3);
    }
}

