/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.sql.DataSource;
import mondrian.olap.Util;
import org.apache.commons.dbcp.AbandonedConfig;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DataSourceConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;

class RolapConnectionPool {
    private static final RolapConnectionPool instance = new RolapConnectionPool();
    private final Map<Object, ObjectPool> mapConnectKeyToPool = new HashMap<Object, ObjectPool>();
    private final Map<DataSourceKey, DataSource> dataSourceMap = new WeakHashMap<DataSourceKey, DataSource>();

    public static RolapConnectionPool instance() {
        return instance;
    }

    private RolapConnectionPool() {
    }

    synchronized DataSource getPoolingDataSource(PoolKey key, ConnectionFactory connectionFactory, boolean mysql) {
        ObjectPool connectionPool = this.getPool(key, connectionFactory, mysql);
        return new PoolingDataSource(connectionPool);
    }

    void clearPool() {
        this.mapConnectKeyToPool.clear();
    }

    public synchronized DataSource getDriverManagerPoolingDataSource(String jdbcConnectString, Properties jdbcProperties, boolean mysql) {
        DataSourceKey key = DataSourceKey.of(jdbcConnectString, jdbcProperties);
        DataSource dataSource = this.dataSourceMap.get(key);
        if (dataSource != null) {
            return dataSource;
        }
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(jdbcConnectString, jdbcProperties);
        try {
            dataSource = this.getPoolingDataSource(PoolKey.of(jdbcConnectString, jdbcProperties), (ConnectionFactory)connectionFactory, mysql);
        }
        catch (Throwable e) {
            throw Util.newInternal(e, "Error while creating connection pool (with URI " + jdbcConnectString + ")");
        }
        this.dataSourceMap.put(key, dataSource);
        return dataSource;
    }

    public synchronized DataSource getDataSourcePoolingDataSource(DataSource dataSource, String dataSourceName, String jdbcUser, String jdbcPassword) {
        DataSourceKey key = DataSourceKey.of(dataSource, jdbcUser, jdbcPassword);
        DataSource pooledDataSource = this.dataSourceMap.get(key);
        if (pooledDataSource != null) {
            return pooledDataSource;
        }
        DataSourceConnectionFactory connectionFactory = jdbcUser != null || jdbcPassword != null ? new DataSourceConnectionFactory(dataSource, jdbcUser, jdbcPassword) : new DataSourceConnectionFactory(dataSource);
        try {
            pooledDataSource = this.getPoolingDataSource(PoolKey.of(dataSourceName), (ConnectionFactory)connectionFactory, false);
        }
        catch (Exception e) {
            throw Util.newInternal(e, "Error while creating connection pool (with URI " + dataSourceName + ")");
        }
        this.dataSourceMap.put(key, pooledDataSource);
        return dataSource;
    }

    private synchronized ObjectPool getPool(PoolKey key, ConnectionFactory connectionFactory, boolean mysql) {
        ObjectPool connectionPool = this.mapConnectKeyToPool.get(key);
        if (connectionPool == null) {
            connectionPool = new GenericObjectPool(null, 5000, 2, 3000L, 10, mysql, false, 60000L, 5, 30000L, true);
            AbandonedConfig abandonedConfig = new AbandonedConfig();
            abandonedConfig.setRemoveAbandoned(true);
            abandonedConfig.setRemoveAbandonedTimeout(300);
            abandonedConfig.setLogAbandoned(true);
            PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory(connectionFactory, connectionPool, null, mysql ? "SELECT 1" : null, false, true, abandonedConfig);
            Util.discard((Object)poolableConnectionFactory);
            this.mapConnectKeyToPool.put(key, connectionPool);
        }
        return connectionPool;
    }

    private static class PoolKey
    extends ListKey {
        private PoolKey(Object[] values) {
            super(values);
        }

        public String toString() {
            return "PoolKey" + super.toString();
        }

        public static PoolKey of(String dataSourceName) {
            return new PoolKey(new String[]{dataSourceName});
        }

        public static PoolKey of(String jdbcConnectString, Properties properties) {
            Properties map = properties;
            Object[] values = new String[properties.size() * 2 + 1];
            int i = 0;
            values[i++] = jdbcConnectString;
            for (Map.Entry entry : map.entrySet()) {
                values[i++] = (String)entry.getKey();
                values[i++] = (String)entry.getValue();
            }
            return new PoolKey(values);
        }
    }

    private static class DataSourceKey
    extends ListKey {
        private DataSourceKey(Object[] values) {
            super(values);
        }

        public String toString() {
            return "DataSourceKey" + super.toString();
        }

        public static DataSourceKey of(String jdbcConnectString, Properties jdbcProperties) {
            Properties map = jdbcProperties;
            Object[] values = new String[jdbcProperties.size() * 2 + 1];
            int i = 0;
            values[i++] = jdbcConnectString;
            for (Map.Entry entry : map.entrySet()) {
                values[i++] = (String)entry.getKey();
                values[i++] = (String)entry.getValue();
            }
            return new DataSourceKey(values);
        }

        public static DataSourceKey of(DataSource dataSource, String jdbcUser, String jdbcPassword) {
            Object[] values1 = new Object[]{dataSource, jdbcUser, jdbcPassword};
            return new DataSourceKey(values1);
        }
    }

    private static abstract class ListKey {
        private final int hashCode;
        private final Object[] values;

        protected ListKey(Object[] values) {
            this.values = values;
            this.hashCode = Arrays.hashCode(values);
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof ListKey && this.hashCode == ((ListKey)obj).hashCode && this.getClass() == obj.getClass() && Arrays.equals(this.values, ((ListKey)obj).values);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return Arrays.toString(this.values) + "#" + this.hashCode;
        }
    }
}

