/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.DataSource;
import mondrian.calc.TupleCollections;
import mondrian.calc.TupleCursor;
import mondrian.calc.TupleList;
import mondrian.olap.Axis;
import mondrian.olap.CacheControl;
import mondrian.olap.Cell;
import mondrian.olap.ConnectionBase;
import mondrian.olap.Exp;
import mondrian.olap.FunTable;
import mondrian.olap.MondrianServer;
import mondrian.olap.Position;
import mondrian.olap.Query;
import mondrian.olap.QueryAxis;
import mondrian.olap.QueryPart;
import mondrian.olap.Result;
import mondrian.olap.ResultBase;
import mondrian.olap.ResultLimitExceededException;
import mondrian.olap.Role;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.parser.MdxParserValidator;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapAxis;
import mondrian.rolap.RolapCell;
import mondrian.rolap.RolapConnectionProperties;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapResult;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapSchemaPool;
import mondrian.rolap.RolapSchemaReader;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.ScenarioImpl;
import mondrian.server.Execution;
import mondrian.server.Locus;
import mondrian.server.StatementImpl;
import mondrian.spi.DataServicesLocator;
import mondrian.spi.DataServicesProvider;
import mondrian.spi.Dialect;
import mondrian.spi.DialectManager;
import mondrian.util.LockBox;
import mondrian.util.MemoryMonitor;
import mondrian.util.MemoryMonitorFactory;
import mondrian.util.Pair;
import org.apache.log4j.Logger;
import org.olap4j.Scenario;

public class RolapConnection
extends ConnectionBase {
    private static final Logger LOGGER = Logger.getLogger(RolapConnection.class);
    private static final AtomicInteger ID_GENERATOR = new AtomicInteger();
    private final MondrianServer server;
    private final Util.PropertyList connectInfo;
    private final DataSource dataSource;
    private final String catalogUrl;
    private final RolapSchema schema;
    private SchemaReader schemaReader;
    protected Role role;
    private Locale locale = Locale.getDefault();
    private Scenario scenario;
    private boolean closed = false;
    private final int id;
    private final mondrian.server.Statement internalStatement;
    final Dialect dialect;

    public RolapConnection(MondrianServer server, Util.PropertyList connectInfo, DataSource dataSource) {
        this(server, connectInfo, null, dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    RolapConnection(MondrianServer server, Util.PropertyList connectInfo, RolapSchema schema, DataSource dataSource) {
        String localeString;
        assert (server != null);
        this.server = server;
        this.id = ID_GENERATOR.getAndIncrement();
        assert (connectInfo != null);
        String provider = connectInfo.get(RolapConnectionProperties.Provider.name(), "mondrian");
        Util.assertTrue(provider.equalsIgnoreCase("mondrian"));
        this.connectInfo = connectInfo;
        this.catalogUrl = connectInfo.get(RolapConnectionProperties.Catalog.name());
        String jdbcUser = connectInfo.get(RolapConnectionProperties.JdbcUser.name());
        String jdbcConnectString = connectInfo.get(RolapConnectionProperties.Jdbc.name());
        String strDataSource = connectInfo.get(RolapConnectionProperties.DataSource.name());
        StringBuilder buf = new StringBuilder();
        DataServicesProvider dataServicesProvider = DataServicesLocator.getDataServicesProvider(connectInfo.get(RolapConnectionProperties.DataServicesProvider.name()));
        this.dataSource = dataServicesProvider.createDataSource(dataSource, connectInfo, buf);
        RolapSchema.RoleFactory roleFactory = null;
        server.addConnection(this);
        if (schema == null) {
            this.dialect = null;
            mondrian.server.Statement bootstrapStatement = this.createInternalStatement(false);
            Locus locus = new Locus(new Execution(bootstrapStatement, 0L), null, "Initializing connection");
            Locus.push(locus);
            try {
                if (dataSource == null) {
                    String connectionKey = jdbcConnectString + RolapConnection.getJdbcProperties(connectInfo).toString();
                    schema = RolapSchemaPool.instance().get(this.catalogUrl, connectionKey, jdbcUser, strDataSource, connectInfo);
                } else {
                    schema = RolapSchemaPool.instance().get(this.catalogUrl, dataSource, connectInfo);
                }
            }
            finally {
                Locus.pop(locus);
                bootstrapStatement.close();
            }
            this.internalStatement = schema.getInternalConnection().getInternalStatement();
            String roleNameList = connectInfo.get(RolapConnectionProperties.Role.name());
            if (roleNameList != null) {
                List<String> roleNames = Util.parseCommaList(roleNameList);
                ArrayList<RolapSchema.RoleFactory> roleList = new ArrayList<RolapSchema.RoleFactory>();
                for (String roleName : roleNames) {
                    roleList.add(this.getRoleFactory(server, schema, roleName));
                }
                switch (roleList.size()) {
                    case 0: {
                        roleFactory = null;
                        break;
                    }
                    case 1: {
                        roleFactory = (RolapSchema.RoleFactory)roleList.get(0);
                        break;
                    }
                    default: {
                        roleFactory = new RolapSchema.UnionRoleFactory(roleList);
                        break;
                    }
                }
            }
        } else {
            this.internalStatement = this.createInternalStatement(true);
            Connection conn = null;
            Statement statement = null;
            Dialect dialect = null;
            try {
                block28: {
                    conn = this.dataSource.getConnection();
                    String dialectClassName = connectInfo.get(RolapConnectionProperties.Dialect.name());
                    dialect = DialectManager.createDialect(this.dataSource, conn, dialectClassName);
                    if (dialect.getDatabaseProduct() == Dialect.DatabaseProduct.DERBY) {
                        statement = conn.createStatement();
                        try {
                            statement.executeQuery("select * from bogustable");
                        }
                        catch (SQLException e) {
                            if (e.getMessage().equals("Table/View 'BOGUSTABLE' does not exist.")) break block28;
                            throw e;
                        }
                    }
                }
                this.dialect = dialect;
            }
            catch (SQLException e) {
                try {
                    throw Util.newError(e, "Error while creating SQL connection: " + buf);
                }
                catch (Throwable throwable) {
                    this.dialect = dialect;
                    Util.close(null, statement, conn);
                    throw throwable;
                }
            }
            Util.close(null, statement, conn);
        }
        if (roleFactory == null) {
            roleFactory = schema.getDefaultRole();
        }
        if ((localeString = connectInfo.get(RolapConnectionProperties.Locale.name())) != null) {
            this.locale = Util.parseLocale(localeString);
            assert (this.locale != null);
        }
        this.schema = schema;
        HashMap<String, Object> context = new HashMap<String, Object>();
        Iterator<Pair<String, String>> i$ = connectInfo.iterator();
        while (true) {
            if (!i$.hasNext()) {
                Role role = roleFactory.create(context);
                this.setRole(role);
                return;
            }
            Pair<String, String> pair = i$.next();
            if (!((String)pair.left).startsWith("session.")) continue;
            context.put(((String)pair.left).substring("session.".length()), pair.right);
        }
    }

    private RolapSchema.RoleFactory getRoleFactory(MondrianServer server, RolapSchema schema, String roleName) {
        RolapSchema.RoleFactory factory;
        LockBox.Entry entry = server.getLockBox().get(roleName);
        if (entry != null) {
            try {
                Object value = entry.getValue();
                if (value instanceof RolapSchema.RoleFactory) {
                    return (RolapSchema.RoleFactory)value;
                }
                return new RolapSchema.ConstantRoleFactory((Role)value);
            }
            catch (ClassCastException value) {
                // empty catch block
            }
        }
        if ((factory = schema.mapNameToRole.get(roleName)) != null) {
            return factory;
        }
        throw Util.newError("Role '" + roleName + "' not found");
    }

    protected void finalize() throws Throwable {
        try {
            super.finalize();
            this.close();
        }
        catch (Throwable t) {
            LOGGER.info((Object)MondrianResource.instance().FinalizerErrorRolapConnection.baseMessage, t);
        }
    }

    public int getId() {
        return this.id;
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    static Properties getJdbcProperties(Util.PropertyList connectInfo) {
        Properties jdbcProperties = new Properties();
        for (Pair<String, String> entry : connectInfo) {
            if (!((String)entry.left).startsWith("jdbc.")) continue;
            jdbcProperties.put(((String)entry.left).substring("jdbc.".length()), entry.right);
        }
        return jdbcProperties;
    }

    public Util.PropertyList getConnectInfo() {
        return this.connectInfo;
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.server.removeConnection(this);
        }
    }

    public RolapSchema getSchema() {
        return this.schema;
    }

    public String getConnectString() {
        return this.connectInfo.toString();
    }

    public String getCatalogName() {
        return this.catalogUrl;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("locale must not be null");
        }
        this.locale = locale;
    }

    public SchemaReader getSchemaReader() {
        return this.schemaReader;
    }

    public Object getProperty(String name) {
        if (name.equals(RolapConnectionProperties.JdbcPassword.name()) || name.equals(RolapConnectionProperties.CatalogContent.name())) {
            return "";
        }
        return this.connectInfo.get(name);
    }

    public CacheControl getCacheControl(PrintWriter pw) {
        return this.getServer().getAggregationManager().getCacheControl(this, pw);
    }

    public Result execute(Query query) {
        mondrian.server.Statement statement = query.getStatement();
        Execution execution = new Execution(statement, statement.getQueryTimeoutMillis());
        return this.execute(execution);
    }

    public Result execute(final Execution execution) {
        execution.copyMDC();
        return this.server.getResultShepherd().shepherdExecution(execution, new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return RolapConnection.this.executeInternal(execution);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result executeInternal(final Execution execution) {
        mondrian.server.Statement statement;
        execution.setContextMap();
        mondrian.server.Statement statement2 = statement = execution.getMondrianStatement();
        synchronized (statement2) {
            Execution previousExecution = statement.getCurrentExecution();
            if (previousExecution != null) {
                statement.end(previousExecution);
            }
        }
        Query query = statement.getQuery();
        MemoryMonitor.Listener listener = new MemoryMonitor.Listener(){

            public void memoryUsageNotification(long used, long max) {
                execution.setOutOfMemory("OutOfMemory used=" + used + ", max=" + max + " for connection: " + RolapConnection.this.getConnectString());
            }
        };
        MemoryMonitor mm = MemoryMonitorFactory.getMemoryMonitor();
        long currId = execution.getId();
        try {
            ResultBase result;
            mm.addListener(listener);
            execution.checkCancelOrTimeout();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)Util.unparse(query));
            }
            if (RolapUtil.MDX_LOGGER.isDebugEnabled()) {
                RolapUtil.MDX_LOGGER.debug((Object)(currId + ": " + Util.unparse(query)));
            }
            Locus locus = new Locus(execution, null, "Loading cells");
            Locus.push(locus);
            RolapCube cube = (RolapCube)query.getCube();
            try {
                statement.start(execution);
                for (RolapStar star : cube.getStars()) {
                    star.clearCachedAggregations(true);
                }
                result = new RolapResult(execution, true);
                int i = 0;
                for (QueryAxis axis : query.getAxes()) {
                    if (axis.isNonEmpty()) {
                        result = new NonEmptyResult(result, execution, i);
                    }
                    ++i;
                }
            }
            finally {
                Locus.pop(locus);
                for (RolapStar star : cube.getStars()) {
                    star.clearCachedAggregations(true);
                }
            }
            statement.end(execution);
            ResultBase resultBase = result;
            return resultBase;
        }
        catch (ResultLimitExceededException e) {
            throw e;
        }
        catch (Exception e) {
            String queryString;
            try {
                statement.end(execution);
            }
            catch (Exception result) {
                // empty catch block
            }
            try {
                queryString = Util.unparse(query);
            }
            catch (Exception e1) {
                queryString = "?";
            }
            throw Util.newError(e, "Error while executing query [" + queryString + "]");
        }
        finally {
            mm.removeListener(listener);
            if (RolapUtil.MDX_LOGGER.isDebugEnabled()) {
                long elapsed = execution.getElapsedMillis();
                RolapUtil.MDX_LOGGER.debug((Object)(currId + ": exec: " + elapsed + " ms"));
            }
        }
    }

    public void setRole(Role role) {
        assert (role != null);
        this.role = role;
        this.schemaReader = new RolapSchemaReader(role, this.schema);
    }

    public Role getRole() {
        Util.assertPostcondition(this.role != null, "role != null");
        return this.role;
    }

    public void setScenario(Scenario scenario) {
        this.scenario = scenario;
    }

    public Scenario getScenario() {
        return this.scenario;
    }

    public MondrianServer getServer() {
        return this.server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryPart parseStatement(String query) {
        mondrian.server.Statement statement = this.createInternalStatement(false);
        Locus locus = new Locus(new Execution(statement, 0L), "Parse/validate MDX statement", null);
        Locus.push(locus);
        try {
            QueryPart queryPart = this.parseStatement(statement, query, null, false);
            if (queryPart instanceof Query) {
                ((Query)queryPart).setOwnStatement(true);
                statement = null;
            }
            QueryPart queryPart2 = queryPart;
            return queryPart2;
        }
        finally {
            Locus.pop(locus);
            if (statement != null) {
                statement.close();
            }
        }
    }

    public Exp parseExpression(String expr) {
        boolean debug = false;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(Util.nl + expr));
        }
        mondrian.server.Statement statement = this.getInternalStatement();
        try {
            MdxParserValidator parser = this.createParser();
            FunTable funTable = this.getSchema().getFunTable();
            return parser.parseExpression(statement, expr, debug, funTable);
        }
        catch (Throwable exception) {
            throw MondrianResource.instance().FailedToParseQuery.ex(expr, exception);
        }
    }

    public mondrian.server.Statement getInternalStatement() {
        if (this.internalStatement == null) {
            return this.schema.getInternalConnection().getInternalStatement();
        }
        return this.internalStatement;
    }

    private mondrian.server.Statement createInternalStatement(boolean reentrant) {
        InternalStatement statement = reentrant ? new ReentrantInternalStatement() : new InternalStatement();
        this.server.addStatement(statement);
        return statement;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public ScenarioImpl createScenario() {
        return Locus.execute(this, "createScenario", new Locus.Action<ScenarioImpl>(){

            @Override
            public ScenarioImpl execute() {
                ScenarioImpl scenario = new ScenarioImpl();
                scenario.register(RolapConnection.this.schema);
                return scenario;
            }
        });
    }

    private class ReentrantInternalStatement
    extends InternalStatement {
        private ReentrantInternalStatement() {
        }

        public void start(Execution execution) {
            execution.start();
        }

        public void end(Execution execution) {
            execution.end();
        }

        public void close() {
        }
    }

    private class InternalStatement
    extends StatementImpl {
        private boolean closed = false;

        private InternalStatement() {
        }

        public void close() {
            if (!this.closed) {
                this.closed = true;
                RolapConnection.this.server.removeStatement(this);
            }
        }

        public RolapConnection getMondrianConnection() {
            return RolapConnection.this;
        }
    }

    static class NonEmptyResult
    extends ResultBase {
        final Result underlying;
        private final int axis;
        private final Map<Integer, Integer> map;
        private final int[] pos;

        NonEmptyResult(Result result, Execution execution, int axis) {
            super(execution, (Axis[])result.getAxes().clone());
            this.underlying = result;
            this.axis = axis;
            this.map = new HashMap<Integer, Integer>();
            int axisCount = this.underlying.getAxes().length;
            this.pos = new int[axisCount];
            this.slicerAxis = this.underlying.getSlicerAxis();
            TupleList tupleList = ((RolapAxis)this.underlying.getAxes()[axis]).getTupleList();
            TupleList filteredTupleList = TupleCollections.createList(tupleList.getArity());
            int i = -1;
            TupleCursor tupleCursor = tupleList.tupleCursor();
            while (tupleCursor.forward()) {
                if (this.isEmpty(++i, axis)) continue;
                this.map.put(filteredTupleList.size(), i);
                filteredTupleList.addCurrent(tupleCursor);
            }
            this.axes[axis] = new RolapAxis(filteredTupleList);
        }

        protected Logger getLogger() {
            return LOGGER;
        }

        private boolean isEmpty(int offset, int fixedAxis) {
            int axisCount = this.getAxes().length;
            this.pos[fixedAxis] = offset;
            return this.isEmptyRecurse(fixedAxis, axisCount - 1);
        }

        private boolean isEmptyRecurse(int fixedAxis, int axis) {
            if (axis < 0) {
                RolapCell cell = (RolapCell)this.underlying.getCell(this.pos);
                return cell.isNull();
            }
            if (axis == fixedAxis) {
                return this.isEmptyRecurse(fixedAxis, axis - 1);
            }
            List<Position> positions = this.getAxes()[axis].getPositions();
            int positionCount = positions.size();
            int i = 0;
            while (i < positionCount) {
                this.pos[axis] = i++;
                if (this.isEmptyRecurse(fixedAxis, axis - 1)) continue;
                return false;
            }
            return true;
        }

        public synchronized Cell getCell(int[] externalPos) {
            try {
                int mappedOffset;
                System.arraycopy(externalPos, 0, this.pos, 0, externalPos.length);
                int offset = externalPos[this.axis];
                this.pos[this.axis] = mappedOffset = this.mapOffsetToUnderlying(offset);
                return this.underlying.getCell(this.pos);
            }
            catch (NullPointerException npe) {
                return this.underlying.getCell(externalPos);
            }
        }

        private int mapOffsetToUnderlying(int offset) {
            return this.map.get(offset);
        }

        public void close() {
            this.underlying.close();
        }
    }
}

