/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import mondrian.olap.CalculatedMember;
import mondrian.olap.Exp;
import mondrian.olap.Formula;
import mondrian.olap.Larder;
import mondrian.olap.Larders;
import mondrian.olap.Member;
import mondrian.olap.Property;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapMemberBase;

public class RolapCalculatedMember
extends RolapMemberBase
implements CalculatedMember {
    private final Formula formula;

    RolapCalculatedMember(RolapMember parentMember, RolapCubeLevel level, String name, Formula formula) {
        super(parentMember, level, null, Member.MemberType.FORMULA, RolapCalculatedMember.deriveUniqueName(parentMember, level, name, true), Larders.ofName(name));
        this.formula = formula;
    }

    public int getSolveOrder() {
        Number solveOrder = this.formula.getSolveOrder();
        return solveOrder == null ? 0 : solveOrder.intValue();
    }

    public Object getPropertyValue(Property property) {
        if (property == Property.FORMULA) {
            return this.formula;
        }
        if (property == Property.CHILDREN_CARDINALITY) {
            return 0;
        }
        return super.getPropertyValue(property);
    }

    protected boolean computeCalculated(Member.MemberType memberType) {
        return true;
    }

    public boolean isCalculatedInQuery() {
        String memberScope = (String)this.getPropertyValue(Property.MEMBER_SCOPE);
        return memberScope == null || memberScope.equals("QUERY");
    }

    public Exp getExpression() {
        return this.formula.getExpression();
    }

    public Formula getFormula() {
        return this.formula;
    }

    void setLarder(Larder larder) {
        assert (larder != null);
        this.larder = larder;
    }
}

