/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mondrian.olap.Access;
import mondrian.olap.Role;
import mondrian.olap.RoleImpl;
import mondrian.resource.MondrianResource;
import mondrian.rolap.DelegatingMemberReader;
import mondrian.rolap.DelegatingRolapMember;
import mondrian.rolap.MemberCache;
import mondrian.rolap.MemberReader;
import mondrian.rolap.RolapCubeHierarchy;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.SqlConstraintFactory;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.TupleConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RestrictedMemberReader
extends DelegatingMemberReader {
    private final Role.HierarchyAccess hierarchyAccess;
    private final boolean ragged;
    private final SqlConstraintFactory sqlConstraintFactory = SqlConstraintFactory.instance();

    RestrictedMemberReader(MemberReader memberReader, Role role) {
        super(memberReader);
        RolapCubeHierarchy hierarchy = memberReader.getHierarchy();
        this.ragged = hierarchy.isRagged();
        if (role.getAccessDetails(hierarchy) == null) {
            assert (this.ragged);
            this.hierarchyAccess = RoleImpl.createAllAccess(hierarchy);
        } else {
            this.hierarchyAccess = role.getAccessDetails(hierarchy);
        }
    }

    @Override
    public boolean setCache(MemberCache cache) {
        return false;
    }

    @Override
    public RolapMember getLeadMember(RolapMember member, int n) {
        int i = 0;
        int increment = 1;
        if (n < 0) {
            increment = -1;
            n = -n;
        }
        while (i < n) {
            if ((member = this.memberReader.getLeadMember(member, increment)).isNull()) {
                return member;
            }
            if (!this.canSee(member)) continue;
            ++i;
        }
        return member;
    }

    @Override
    public void getMemberChildren(RolapMember parentMember, List<RolapMember> children) {
        MemberChildrenConstraint constraint = this.sqlConstraintFactory.getMemberChildrenConstraint(null);
        this.getMemberChildren(parentMember, children, constraint);
    }

    @Override
    public void getMemberChildren(RolapMember parentMember, List<RolapMember> children, MemberChildrenConstraint constraint) {
        ArrayList<RolapMember> fullChildren = new ArrayList<RolapMember>();
        this.memberReader.getMemberChildren(parentMember, fullChildren, constraint);
        this.processMemberChildren(fullChildren, children, constraint);
    }

    private void processMemberChildren(List<RolapMember> fullChildren, List<RolapMember> children, MemberChildrenConstraint constraint) {
        ArrayList<RolapMember> grandChildren = null;
        block3: for (int i = 0; i < fullChildren.size(); ++i) {
            RolapMember member = fullChildren.get(i);
            if (this.ragged && member.isHidden()) {
                fullChildren.remove(i);
                if (grandChildren == null) {
                    grandChildren = new ArrayList<RolapMember>();
                } else {
                    grandChildren.clear();
                }
                this.memberReader.getMemberChildren(member, grandChildren, constraint);
                fullChildren.addAll(i, grandChildren);
                --i;
                continue;
            }
            Access access = this.hierarchyAccess != null ? this.hierarchyAccess.getAccess(member) : Access.ALL;
            switch (access) {
                case NONE: {
                    continue block3;
                }
                default: {
                    children.add(member);
                }
            }
        }
    }

    private void filterMembers(List<RolapMember> members, List<RolapMember> filteredMembers) {
        for (RolapMember member : members) {
            if (!this.canSee(member)) continue;
            filteredMembers.add(member);
        }
    }

    private boolean canSee(RolapMember member) {
        if (this.ragged && member.isHidden()) {
            return false;
        }
        if (this.hierarchyAccess != null) {
            Access access = this.hierarchyAccess.getAccess(member);
            return access != Access.NONE;
        }
        return true;
    }

    @Override
    public void getMemberChildren(List<RolapMember> parentMembers, List<RolapMember> children) {
        MemberChildrenConstraint constraint = this.sqlConstraintFactory.getMemberChildrenConstraint(null);
        this.getMemberChildren(parentMembers, children, constraint);
    }

    @Override
    public synchronized void getMemberChildren(List<RolapMember> parentMembers, List<RolapMember> children, MemberChildrenConstraint constraint) {
        ArrayList<RolapMember> fullChildren = new ArrayList<RolapMember>();
        super.getMemberChildren(parentMembers, fullChildren, constraint);
        this.processMemberChildren(fullChildren, children, constraint);
    }

    @Override
    public List<RolapMember> getRootMembers() {
        List<RolapMember> memberList;
        int topLevelDepth = this.hierarchyAccess.getTopLevelDepth();
        if (topLevelDepth > 0) {
            RolapCubeLevel topLevel = this.getHierarchy().getLevelList().get(topLevelDepth);
            memberList = this.getMembersInLevel(topLevel);
        } else {
            List<RolapMember> unfilteredMemberList = super.getRootMembers();
            memberList = new ArrayList<RolapMember>();
            this.filterMembers(unfilteredMemberList, memberList);
        }
        if (memberList.isEmpty()) {
            throw MondrianResource.instance().HierarchyHasNoAccessibleMembers.ex(this.getHierarchy().getUniqueName());
        }
        return memberList;
    }

    @Override
    public List<RolapMember> getMembersInLevel(RolapCubeLevel level) {
        TupleConstraint constraint = this.sqlConstraintFactory.getLevelMembersConstraint(null);
        return this.getMembersInLevel(level, constraint);
    }

    @Override
    public List<RolapMember> getMembersInLevel(RolapCubeLevel level, TupleConstraint constraint) {
        if (this.hierarchyAccess != null) {
            int depth = level.getDepth();
            if (depth < this.hierarchyAccess.getTopLevelDepth()) {
                return Collections.emptyList();
            }
            if (depth > this.hierarchyAccess.getBottomLevelDepth()) {
                return Collections.emptyList();
            }
        }
        List<RolapMember> membersInLevel = this.memberReader.getMembersInLevel(level, constraint);
        ArrayList<RolapMember> filteredMembers = new ArrayList<RolapMember>();
        this.filterMembers(membersInLevel, filteredMembers);
        return filteredMembers;
    }

    @Override
    public RolapMember getDefaultMember() {
        Access i;
        RolapMember defaultMember = this.getHierarchy().getDefaultMember();
        if (defaultMember != null && (i = this.hierarchyAccess.getAccess(defaultMember)) != Access.NONE) {
            return defaultMember;
        }
        List<RolapMember> rootMembers = this.getRootMembers();
        RolapMember rootMember = rootMembers.get(0);
        if (rootMembers.size() == 1) {
            return rootMembers.get(0);
        }
        return new MultiCardinalityDefaultMember(rootMember);
    }

    @Override
    public RolapMember getMemberParent(RolapMember member) {
        RolapMember parentMember;
        for (parentMember = member.getParentMember(); parentMember != null && parentMember.isHidden(); parentMember = parentMember.getParentMember()) {
        }
        if (parentMember != null && this.hierarchyAccess.getAccess(parentMember) == Access.NONE) {
            return null;
        }
        return parentMember;
    }

    static class MultiCardinalityDefaultMember
    extends DelegatingRolapMember {
        protected MultiCardinalityDefaultMember(RolapMember member) {
            super(member);
        }
    }
}

