/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import mondrian.olap.MondrianDef;
import mondrian.olap.Util;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapSchemaLoader;
import mondrian.rolap.sql.SqlQuery;
import org.eigenbase.xom.ElementDef;
import org.eigenbase.xom.NodeDef;
import org.eigenbase.xom.TextDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PhysSchemaConverter
extends RolapSchemaLoader.PhysSchemaBuilder {
    final Map<ElementDef, ElementDef> legacyMap = new HashMap<ElementDef, ElementDef>();
    Map<String, MondrianDef.Relation> xmlTables = new HashMap<String, MondrianDef.Relation>();
    private final Map<RolapSchema.PhysCalcColumn, MondrianDef.Expression> calcColumnExprMap = new IdentityHashMap<RolapSchema.PhysCalcColumn, MondrianDef.Expression>();

    PhysSchemaConverter(RolapSchemaLoader loader, RolapSchema.PhysSchema physSchema) {
        super(loader, physSchema);
    }

    @Override
    RolapSchema.PhysExpr toPhysExpr(RolapSchema.PhysRelation physRelation, MondrianDef.Expression exp) {
        RolapSchema.PhysExpr physExpr = super.toPhysExpr(physRelation, exp);
        if (physExpr instanceof RolapSchema.PhysCalcColumn) {
            RolapSchema.PhysCalcColumn physCalcColumn = (RolapSchema.PhysCalcColumn)physExpr;
            this.calcColumnExprMap.put(physCalcColumn, exp);
            assert (physCalcColumn.relation.getColumn(physCalcColumn.name, false) != null) : "column isn't registered in its own table: " + physCalcColumn;
        }
        return physExpr;
    }

    public MondrianDef.PhysicalSchema toDef(RolapSchema.PhysSchema physSchema) {
        MondrianDef.PhysicalSchema xmlPhysSchema = new MondrianDef.PhysicalSchema();
        for (RolapSchema.PhysRelation relation : physSchema.tablesByName.values()) {
            this.toDef(relation, xmlPhysSchema.children);
        }
        for (RolapSchema.PhysLink physLink : physSchema.linkSet) {
            this.toDef(physLink, xmlPhysSchema.children);
        }
        return xmlPhysSchema;
    }

    private void toDef(RolapSchema.PhysLink physLink, MondrianDef.Children<MondrianDef.PhysicalSchemaElement> physSchemaChildren) {
        MondrianDef.Link xmlLink = new MondrianDef.Link();
        xmlLink.target = physLink.targetRelation.getAlias();
        xmlLink.source = physLink.sourceKey.relation.getAlias();
        xmlLink.key = physLink.sourceKey.name;
        xmlLink.foreignKey = new MondrianDef.ForeignKey();
        ArrayList<MondrianDef.Column> xmlColumnList = new ArrayList<MondrianDef.Column>();
        this.toDef(physLink.columnList, xmlColumnList);
        xmlLink.foreignKey.array = xmlColumnList.toArray(new MondrianDef.Column[xmlColumnList.size()]);
        physSchemaChildren.add(xmlLink);
    }

    private void toDef(RolapSchema.PhysRelation physRelation, MondrianDef.Children<MondrianDef.PhysicalSchemaElement> physSchemaChildren) {
        MondrianDef.Relation xmlRelation;
        if (physRelation instanceof RolapSchema.PhysInlineTable) {
            xmlRelation = this.toDef((RolapSchema.PhysInlineTable)physRelation);
        } else if (physRelation instanceof RolapSchema.PhysTable) {
            xmlRelation = this.toDef((RolapSchema.PhysTable)physRelation);
        } else if (physRelation instanceof RolapSchema.PhysView) {
            xmlRelation = this.toDef((RolapSchema.PhysView)physRelation);
        } else {
            throw Util.newInternal("unknown relation type " + physRelation);
        }
        physSchemaChildren.add(xmlRelation);
    }

    private MondrianDef.Relation toDef(RolapSchema.PhysView physView) {
        MondrianDef.Query xmlQuery = new MondrianDef.Query();
        xmlQuery.alias = physView.getAlias();
        for (RolapSchema.PhysKey physKey : physView.getKeyList()) {
            MondrianDef.Key key = new MondrianDef.Key();
            key.name = physKey.name;
            ArrayList<MondrianDef.Column> list = new ArrayList<MondrianDef.Column>();
            for (RolapSchema.PhysColumn physColumn : physKey.columnList) {
                list.add(new MondrianDef.Column(null, physColumn.name));
            }
            key.array = list.toArray(new MondrianDef.Column[list.size()]);
            xmlQuery.children.add(key);
        }
        MondrianDef.ExpressionView expressionView = new MondrianDef.ExpressionView();
        MondrianDef.SQL sql = new MondrianDef.SQL();
        sql.children = new NodeDef[]{new TextDef(physView.getSqlString())};
        sql.dialect = SqlQuery.getBestName(physView.physSchema.dialect);
        expressionView.expressions = new MondrianDef.SQL[]{sql};
        xmlQuery.children.add(expressionView);
        this.xmlTables.put(physView.getAlias(), xmlQuery);
        return xmlQuery;
    }

    private MondrianDef.Table toDef(RolapSchema.PhysTable physTable) {
        MondrianDef.Table xmlTable = new MondrianDef.Table();
        xmlTable.name = physTable.name;
        xmlTable.alias = physTable.alias;
        List<MondrianDef.RealOrCalcColumnDef> columnDefs = xmlTable.children.holder(new MondrianDef.ColumnDefs()).list();
        for (RolapSchema.PhysColumn physColumn : physTable.columnsByName.values()) {
            this.toDef(physColumn, columnDefs);
        }
        for (RolapSchema.PhysKey physKey : physTable.keysByName.values()) {
            this.toDef(physKey, xmlTable);
        }
        this.xmlTables.put(physTable.getAlias(), xmlTable);
        return xmlTable;
    }

    private void toDef(RolapSchema.PhysKey physKey, MondrianDef.Table xmlTable) {
        MondrianDef.Key xmlKey = new MondrianDef.Key();
        xmlKey.name = physKey.name;
        ArrayList<MondrianDef.Column> xmlColumnList = new ArrayList<MondrianDef.Column>();
        this.toDef(physKey.columnList, xmlColumnList);
        xmlKey.array = xmlColumnList.toArray(new MondrianDef.Column[xmlColumnList.size()]);
        xmlTable.children.add(xmlKey);
    }

    private void toDef(List<RolapSchema.PhysColumn> physColumnList, List<MondrianDef.Column> xmlColumnList) {
        for (RolapSchema.PhysColumn physColumn : physColumnList) {
            xmlColumnList.add(this.toRefDef(physColumn));
        }
    }

    private MondrianDef.Column toRefDef(RolapSchema.PhysColumn physColumn) {
        MondrianDef.Column xmlColumn = new MondrianDef.Column();
        xmlColumn.name = physColumn.name;
        xmlColumn.table = physColumn.relation.getAlias();
        return xmlColumn;
    }

    private void toDef(RolapSchema.PhysColumn physColumn, List<MondrianDef.RealOrCalcColumnDef> columnDefs) {
        if (physColumn instanceof RolapSchema.PhysCalcColumn) {
            RolapSchema.PhysCalcColumn column = (RolapSchema.PhysCalcColumn)physColumn;
            MondrianDef.CalculatedColumnDef xmlCalcColumnDef = new MondrianDef.CalculatedColumnDef();
            xmlCalcColumnDef.name = column.name;
            xmlCalcColumnDef.expression = this.calcColumnExprMap.get(column);
            assert (xmlCalcColumnDef.expression != null);
            columnDefs.add(xmlCalcColumnDef);
        }
    }

    private MondrianDef.InlineTable toDef(RolapSchema.PhysInlineTable physInlineTable) {
        MondrianDef.InlineTable xmlInlineTable = new MondrianDef.InlineTable();
        xmlInlineTable.alias = physInlineTable.getAlias();
        List<MondrianDef.RealOrCalcColumnDef> xmlColumnDefs = xmlInlineTable.children.holder(new MondrianDef.ColumnDefs()).list();
        for (RolapSchema.PhysColumn elementDef : physInlineTable.columnsByName.values()) {
            MondrianDef.ColumnDef xmlColumn = new MondrianDef.ColumnDef();
            xmlColumn.name = elementDef.name;
            xmlColumn.type = elementDef.datatype.name();
            xmlColumnDefs.add(xmlColumn);
        }
        for (RolapSchema.PhysKey pKey : physInlineTable.getKeyList()) {
            MondrianDef.Key key = new MondrianDef.Key();
            ArrayList<MondrianDef.Column> columns = new ArrayList<MondrianDef.Column>();
            for (RolapSchema.PhysColumn pColumn : pKey.columnList) {
                MondrianDef.Column column = new MondrianDef.Column();
                column.name = pColumn.name;
                column.table = pColumn.relation.getAlias();
                columns.add(column);
            }
            key.array = columns.toArray(new MondrianDef.Column[columns.size()]);
            key.name = pKey.name;
            xmlInlineTable.children.add(key);
        }
        List<MondrianDef.Row> xmlRows = xmlInlineTable.children.holder(new MondrianDef.Rows()).list();
        for (String[] values : physInlineTable.rowList) {
            MondrianDef.Row xmlRow = new MondrianDef.Row();
            ArrayList<MondrianDef.Value> valueList = new ArrayList<MondrianDef.Value>();
            for (int i = 0; i < values.length; ++i) {
                String value = values[i];
                MondrianDef.Value xmlValue = new MondrianDef.Value();
                xmlValue.column = xmlColumnDefs.get((int)i).name;
                xmlValue.cdata = value;
                valueList.add(xmlValue);
            }
            xmlRow.values = valueList.toArray(new MondrianDef.Value[valueList.size()]);
            xmlRows.add(xmlRow);
        }
        this.xmlTables.put(physInlineTable.getAlias(), xmlInlineTable);
        return xmlInlineTable;
    }

    public RolapSchema.PhysCalcColumn toPhysColumn(RolapSchema.PhysExpr expr, NodeDef legacyExpression, MondrianDef.ExpressionView xmlExpressionview, RolapSchema.PhysRelation relation) {
        HashSet<RolapSchema.PhysRelation> relationSet = new HashSet<RolapSchema.PhysRelation>();
        RolapSchemaLoader.PhysSchemaBuilder.collectRelations(expr, relation, relationSet);
        if (relationSet.size() != 1) {
            this.getHandler().error("Expression must belong to one and only one relation", legacyExpression, null);
            return null;
        }
        RolapSchema.PhysRelation relation1 = (RolapSchema.PhysRelation)relationSet.iterator().next();
        if (!(relation1 instanceof RolapSchema.PhysTable)) {
            this.getHandler().error("Cannot define an expression in a relation that it is not a table; relation '" + relation1.getAlias() + "' is a " + relation1.getClass(), legacyExpression, null);
            return null;
        }
        RolapSchema.PhysTable physTable = (RolapSchema.PhysTable)relation1;
        for (Map.Entry entry : physTable.columnsByName.entrySet()) {
            RolapSchema.PhysCalcColumn physCalcColumn;
            if (!(entry.getValue() instanceof RolapSchema.PhysCalcColumn) || !(physCalcColumn = (RolapSchema.PhysCalcColumn)entry.getValue()).getList().equals(Collections.singletonList(expr))) continue;
            return physCalcColumn;
        }
        RolapSchema.PhysCalcColumn physCalcColumn = new RolapSchema.PhysCalcColumn(this.loader, legacyExpression, physTable, "calc$" + physTable.columnsByName.size(), expr.getDatatype(), expr.getInternalType(), Collections.singletonList(expr));
        physTable.addColumn(physCalcColumn);
        this.calcColumnExprMap.put(physCalcColumn, xmlExpressionview);
        return physCalcColumn;
    }
}

