/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;
import mondrian.rolap.MemberReader;
import mondrian.rolap.RolapConnection;
import mondrian.rolap.RolapConnectionPool;
import mondrian.rolap.RolapConnectionProperties;
import mondrian.rolap.RolapCubeHierarchy;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.SqlMemberSource;
import mondrian.rolap.SqlTupleReader;
import mondrian.rolap.TupleReader;
import mondrian.rolap.agg.SegmentCacheManager;
import mondrian.rolap.agg.SegmentLoader;
import mondrian.rolap.aggmatcher.JdbcSchema;
import mondrian.rolap.sql.TupleConstraint;
import mondrian.spi.DataServicesProvider;
import mondrian.spi.DataSourceResolver;
import mondrian.spi.impl.JndiDataSourceResolver;
import mondrian.util.ClassResolver;
import org.apache.commons.dbcp.DelegatingConnection;
import org.eigenbase.util.property.StringProperty;

public class DefaultDataServicesProvider
implements DataServicesProvider {
    private static DataSourceResolver dataSourceResolver;
    private static JdbcSchema.Factory factory;
    private static final MondrianResource mres;

    public MemberReader getMemberReader(RolapCubeHierarchy hierarchy) {
        return new SqlMemberSource(hierarchy);
    }

    public SegmentLoader getSegmentLoader(SegmentCacheManager cacheMgr) {
        return new SegmentLoader(cacheMgr);
    }

    public TupleReader getTupleReader(TupleConstraint constraint) {
        return new SqlTupleReader(constraint);
    }

    public synchronized JdbcSchema.Factory getJdbcSchemaFactory() {
        if (factory != null) {
            return factory;
        }
        String className = MondrianProperties.instance().JdbcFactoryClass.get();
        if (className == null) {
            factory = new StdFactory();
        } else {
            try {
                Class clz = ClassResolver.INSTANCE.forName(className, true);
                factory = (JdbcSchema.Factory)clz.newInstance();
            }
            catch (ClassNotFoundException ex) {
                throw DefaultDataServicesProvider.mres.BadJdbcFactoryClassName.ex(className);
            }
            catch (InstantiationException ex) {
                throw DefaultDataServicesProvider.mres.BadJdbcFactoryInstantiation.ex(className);
            }
            catch (IllegalAccessException ex) {
                throw DefaultDataServicesProvider.mres.BadJdbcFactoryAccess.ex(className);
            }
        }
        return factory;
    }

    public DataSource createDataSource(DataSource dataSource, Util.PropertyList connectInfo, StringBuilder buf) {
        assert (buf != null);
        String jdbcConnectString = connectInfo.get(RolapConnectionProperties.Jdbc.name());
        String jdbcUser = connectInfo.get(RolapConnectionProperties.JdbcUser.name());
        String jdbcPassword = connectInfo.get(RolapConnectionProperties.JdbcPassword.name());
        String dataSourceName = connectInfo.get(RolapConnectionProperties.DataSource.name());
        if (dataSource != null) {
            DefaultDataServicesProvider.appendKeyValue(buf, "Anonymous data source", dataSource);
            DefaultDataServicesProvider.appendKeyValue(buf, RolapConnectionProperties.JdbcUser.name(), jdbcUser);
            DefaultDataServicesProvider.appendKeyValue(buf, RolapConnectionProperties.JdbcPassword.name(), jdbcPassword);
            if (jdbcUser != null || jdbcPassword != null) {
                dataSource = new UserPasswordDataSource(dataSource, jdbcUser, jdbcPassword);
            }
            return dataSource;
        }
        if (jdbcConnectString != null) {
            boolean poolNeeded;
            DefaultDataServicesProvider.appendKeyValue(buf, RolapConnectionProperties.Jdbc.name(), jdbcConnectString);
            DefaultDataServicesProvider.appendKeyValue(buf, RolapConnectionProperties.JdbcUser.name(), jdbcUser);
            DefaultDataServicesProvider.appendKeyValue(buf, RolapConnectionProperties.JdbcPassword.name(), jdbcPassword);
            String jdbcDrivers = connectInfo.get(RolapConnectionProperties.JdbcDrivers.name());
            if (jdbcDrivers != null) {
                RolapUtil.loadDrivers(jdbcDrivers);
            }
            String jdbcDriversProp = MondrianProperties.instance().JdbcDrivers.get();
            RolapUtil.loadDrivers(jdbcDriversProp);
            Properties jdbcProperties = RolapConnection.getJdbcProperties(connectInfo);
            Map<String, String> map = Util.toMap(jdbcProperties);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                DefaultDataServicesProvider.appendKeyValue(buf, entry.getKey(), entry.getValue());
            }
            if (jdbcUser != null) {
                jdbcProperties.put("user", jdbcUser);
            }
            if (jdbcPassword != null) {
                jdbcProperties.put("password", jdbcPassword);
            }
            if (!(poolNeeded = connectInfo.get(RolapConnectionProperties.PoolNeeded.name(), "true").equalsIgnoreCase("true"))) {
                return new DriverManagerDataSource(jdbcConnectString, jdbcProperties);
            }
            return RolapConnectionPool.instance().getDriverManagerPoolingDataSource(jdbcConnectString, jdbcProperties, jdbcConnectString.toLowerCase().indexOf("mysql") > -1);
        }
        if (dataSourceName != null) {
            DefaultDataServicesProvider.appendKeyValue(buf, RolapConnectionProperties.DataSource.name(), dataSourceName);
            DefaultDataServicesProvider.appendKeyValue(buf, RolapConnectionProperties.JdbcUser.name(), jdbcUser);
            DefaultDataServicesProvider.appendKeyValue(buf, RolapConnectionProperties.JdbcPassword.name(), jdbcPassword);
            boolean poolNeeded = connectInfo.get(RolapConnectionProperties.PoolNeeded.name(), "false").equalsIgnoreCase("true");
            DataSourceResolver dataSourceResolver = DefaultDataServicesProvider.getDataSourceResolver();
            try {
                dataSource = dataSourceResolver.lookup(dataSourceName);
            }
            catch (Exception e) {
                throw Util.newInternal(e, "Error while looking up data source (" + dataSourceName + ")");
            }
            if (poolNeeded) {
                dataSource = RolapConnectionPool.instance().getDataSourcePoolingDataSource(dataSource, dataSourceName, jdbcUser, jdbcPassword);
            } else if (jdbcUser != null || jdbcPassword != null) {
                dataSource = new UserPasswordDataSource(dataSource, jdbcUser, jdbcPassword);
            }
            return dataSource;
        }
        throw Util.newInternal("Connect string '" + connectInfo.toString() + "' must contain either '" + (Object)((Object)RolapConnectionProperties.Jdbc) + "' or '" + (Object)((Object)RolapConnectionProperties.DataSource) + "'");
    }

    private static synchronized DataSourceResolver getDataSourceResolver() {
        if (dataSourceResolver == null) {
            StringProperty property = MondrianProperties.instance().DataSourceResolverClass;
            String className = property.get(JndiDataSourceResolver.class.getName());
            try {
                dataSourceResolver = (DataSourceResolver)ClassResolver.INSTANCE.instantiateSafe(className, new Object[0]);
            }
            catch (ClassCastException e) {
                throw Util.newInternal(e, "Plugin class specified by property " + property.getPath() + " must implement " + DataSourceResolver.class.getName());
            }
        }
        return dataSourceResolver;
    }

    private static void appendKeyValue(StringBuilder buf, String key, Object value) {
        if (value != null) {
            if (buf.length() > 0) {
                buf.append("; ");
            }
            buf.append(key).append('=').append(value);
        }
    }

    static {
        mres = MondrianResource.instance();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class DelegatingDataSource
    implements DataSource {
        protected final DataSource dataSource;

        public DelegatingDataSource(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        @Override
        public Connection getConnection() throws SQLException {
            return this.dataSource.getConnection();
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            return this.dataSource.getConnection(username, password);
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            return this.dataSource.getLogWriter();
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
            this.dataSource.setLogWriter(out);
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
            this.dataSource.setLoginTimeout(seconds);
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return this.dataSource.getLoginTimeout();
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            if (Util.JdbcVersion >= 1024) {
                try {
                    Method method = DataSource.class.getMethod("unwrap", Class.class);
                    return iface.cast(method.invoke((Object)this.dataSource, iface));
                }
                catch (IllegalAccessException e) {
                    throw Util.newInternal(e, "While invoking unwrap");
                }
                catch (InvocationTargetException e) {
                    throw Util.newInternal(e, "While invoking unwrap");
                }
                catch (NoSuchMethodException e) {
                    throw Util.newInternal(e, "While invoking unwrap");
                }
            }
            if (iface.isInstance(this.dataSource)) {
                return iface.cast(this.dataSource);
            }
            return null;
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            if (Util.JdbcVersion >= 1024) {
                try {
                    Method method = DataSource.class.getMethod("isWrapperFor", Boolean.TYPE);
                    return (Boolean)method.invoke((Object)this.dataSource, iface);
                }
                catch (IllegalAccessException e) {
                    throw Util.newInternal(e, "While invoking isWrapperFor");
                }
                catch (InvocationTargetException e) {
                    throw Util.newInternal(e, "While invoking isWrapperFor");
                }
                catch (NoSuchMethodException e) {
                    throw Util.newInternal(e, "While invoking isWrapperFor");
                }
            }
            return iface.isInstance(this.dataSource);
        }

        @Override
        public Logger getParentLogger() {
            if (Util.JdbcVersion >= 1025) {
                try {
                    Method method = DataSource.class.getMethod("getParentLogger", new Class[0]);
                    return (Logger)method.invoke((Object)this.dataSource, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    throw Util.newInternal(e, "While invoking getParentLogger");
                }
                catch (InvocationTargetException e) {
                    throw Util.newInternal(e, "While invoking getParentLogger");
                }
                catch (NoSuchMethodException e) {
                    throw Util.newInternal(e, "While invoking getParentLogger");
                }
            }
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DriverManagerDataSource
    implements DataSource {
        private final String jdbcConnectString;
        private PrintWriter logWriter;
        private int loginTimeout;
        private Properties jdbcProperties;

        public DriverManagerDataSource(String jdbcConnectString, Properties properties) {
            this.jdbcConnectString = jdbcConnectString;
            this.jdbcProperties = properties;
        }

        public int hashCode() {
            int h = this.loginTimeout;
            h = Util.hash(h, this.jdbcConnectString);
            h = Util.hash(h, this.jdbcProperties);
            return h;
        }

        public boolean equals(Object obj) {
            if (obj instanceof DriverManagerDataSource) {
                DriverManagerDataSource that = (DriverManagerDataSource)obj;
                return this.loginTimeout == that.loginTimeout && this.jdbcConnectString.equals(that.jdbcConnectString) && this.jdbcProperties.equals(that.jdbcProperties);
            }
            return false;
        }

        @Override
        public Connection getConnection() throws SQLException {
            return new DelegatingConnection(DriverManager.getConnection(this.jdbcConnectString, this.jdbcProperties));
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            if (this.jdbcProperties == null) {
                return DriverManager.getConnection(this.jdbcConnectString, username, password);
            }
            Properties temp = (Properties)this.jdbcProperties.clone();
            temp.put("user", username);
            temp.put("password", password);
            return DriverManager.getConnection(this.jdbcConnectString, temp);
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            return this.logWriter;
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
            this.logWriter = out;
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
            this.loginTimeout = seconds;
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return this.loginTimeout;
        }

        @Override
        public Logger getParentLogger() {
            return Logger.getLogger("");
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            throw new SQLException("not a wrapper");
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return false;
        }
    }

    private static class UserPasswordDataSource
    extends DelegatingDataSource {
        private final String jdbcUser;
        private final String jdbcPassword;

        public UserPasswordDataSource(DataSource dataSource, String jdbcUser, String jdbcPassword) {
            super(dataSource);
            this.jdbcUser = jdbcUser;
            this.jdbcPassword = jdbcPassword;
        }

        public Connection getConnection() throws SQLException {
            return this.dataSource.getConnection(this.jdbcUser, this.jdbcPassword);
        }
    }

    protected static class StdFactory
    implements JdbcSchema.Factory {
        StdFactory() {
        }

        public JdbcSchema loadDatabase(DataSource dataSource) {
            return new JdbcSchema(dataSource);
        }
    }
}

