/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap4j;

import java.util.Map;
import mondrian.olap.Access;
import mondrian.olap.OlapElement;
import mondrian.olap4j.MondrianOlap4jConnection;
import mondrian.olap4j.MondrianOlap4jDatabase;
import mondrian.olap4j.MondrianOlap4jDatabaseMetaData;
import mondrian.olap4j.MondrianOlap4jMetadataElement;
import mondrian.olap4j.MondrianOlap4jSchema;
import mondrian.rolap.RolapSchema;
import org.olap4j.OlapDatabaseMetaData;
import org.olap4j.OlapException;
import org.olap4j.impl.Named;
import org.olap4j.impl.NamedListImpl;
import org.olap4j.impl.Olap4jUtil;
import org.olap4j.metadata.Catalog;
import org.olap4j.metadata.Database;
import org.olap4j.metadata.NamedList;
import org.olap4j.metadata.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MondrianOlap4jCatalog
extends MondrianOlap4jMetadataElement
implements Catalog,
Named {
    final MondrianOlap4jDatabaseMetaData olap4jDatabaseMetaData;
    final String name;
    final Map<String, RolapSchema> schemaMap;
    final MondrianOlap4jDatabase olap4jDatabase;

    MondrianOlap4jCatalog(MondrianOlap4jDatabaseMetaData olap4jDatabaseMetaData, String name, MondrianOlap4jDatabase database, Map<String, RolapSchema> schemaMap) {
        assert (database != null);
        this.olap4jDatabaseMetaData = olap4jDatabaseMetaData;
        this.name = name;
        this.olap4jDatabase = database;
        this.schemaMap = schemaMap;
        for (Map.Entry<String, RolapSchema> entry : schemaMap.entrySet()) {
            String schemaName = entry.getKey();
            RolapSchema schema = entry.getValue();
            if (schemaName == null) {
                schemaName = schema.getName();
            }
            MondrianOlap4jSchema olap4jSchema = new MondrianOlap4jSchema(this, schemaName, schema);
            olap4jDatabaseMetaData.olap4jConnection.schemaMap.put(schema, olap4jSchema);
        }
    }

    public NamedList<Schema> getSchemas() throws OlapException {
        NamedListImpl list = new NamedListImpl();
        for (Map.Entry<String, RolapSchema> entry : this.schemaMap.entrySet()) {
            String schemaName = entry.getKey();
            RolapSchema schema = entry.getValue();
            MondrianOlap4jConnection oConn = (MondrianOlap4jConnection)this.olap4jDatabase.getOlapConnection();
            if (oConn.getMondrianConnection().getRole().getAccess(schema) == Access.NONE) continue;
            if (schemaName == null) {
                schemaName = schema.getName();
            }
            MondrianOlap4jSchema olap4jSchema = new MondrianOlap4jSchema(this, schemaName, schema);
            list.add((Object)olap4jSchema);
        }
        return Olap4jUtil.cast((NamedList)list);
    }

    public String getName() {
        return this.name;
    }

    public String getUniqueName() {
        return this.name;
    }

    public String getCaption() {
        return this.name;
    }

    public String getDescription() {
        return "";
    }

    public boolean isVisible() {
        return true;
    }

    public OlapDatabaseMetaData getMetaData() {
        return this.olap4jDatabaseMetaData;
    }

    public Database getDatabase() {
        return this.olap4jDatabase;
    }

    @Override
    protected OlapElement getOlapElement() {
        return null;
    }
}

