/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.type;

import mondrian.olap.Dimension;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Util;
import mondrian.olap.type.Type;

public class HierarchyType
implements Type {
    private final Dimension dimension;
    private final Hierarchy hierarchy;
    private final String digest;
    public static final HierarchyType Unknown = new HierarchyType(null, null);

    public HierarchyType(Dimension dimension, Hierarchy hierarchy) {
        this.dimension = dimension;
        this.hierarchy = hierarchy;
        StringBuilder buf = new StringBuilder("HierarchyType<");
        if (hierarchy != null) {
            buf.append("hierarchy=").append(hierarchy.getUniqueName());
        } else if (dimension != null) {
            buf.append("dimension=").append(dimension.getUniqueName());
        }
        buf.append(">");
        this.digest = buf.toString();
    }

    public static HierarchyType forHierarchy(Hierarchy hierarchy) {
        return new HierarchyType(hierarchy.getDimension(), hierarchy);
    }

    public static HierarchyType forType(Type type) {
        return new HierarchyType(type.getDimension(), type.getHierarchy());
    }

    public boolean usesDimension(Dimension dimension, boolean definitely) {
        return this.dimension == dimension || !definitely && this.dimension == null;
    }

    public boolean usesHierarchy(Hierarchy hierarchy, boolean definitely) {
        return this.hierarchy == hierarchy || !definitely && this.hierarchy == null && (this.dimension == null || this.dimension == hierarchy.getDimension());
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public Hierarchy getHierarchy() {
        return this.hierarchy;
    }

    public Level getLevel() {
        return null;
    }

    public String toString() {
        return this.digest;
    }

    public int hashCode() {
        return this.digest.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof HierarchyType) {
            HierarchyType that = (HierarchyType)obj;
            return Util.equals(this.hierarchy, that.hierarchy) && Util.equals(this.dimension, that.dimension);
        }
        return false;
    }

    public Type computeCommonType(Type type, int[] conversionCount) {
        if (!(type instanceof HierarchyType)) {
            return null;
        }
        HierarchyType that = (HierarchyType)type;
        if (this.getHierarchy() != null && this.getHierarchy().equals(that.getHierarchy())) {
            return this;
        }
        if (this.getDimension() != null && this.getDimension().equals(that.getDimension())) {
            return new HierarchyType(this.getDimension(), null);
        }
        return Unknown;
    }

    public boolean isInstance(Object value) {
        return !(!(value instanceof Hierarchy) || this.hierarchy != null && !value.equals(this.hierarchy) || this.dimension != null && !((Hierarchy)value).getDimension().equals(this.dimension));
    }

    public int getArity() {
        return 1;
    }
}

