/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.DummyExp;
import mondrian.calc.ExpCompiler;
import mondrian.calc.LevelCalc;
import mondrian.calc.MemberCalc;
import mondrian.calc.impl.AbstractMemberCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.SchemaReader;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.HierarchyCurrentMemberFunDef;
import mondrian.olap.fun.MultiResolver;
import mondrian.olap.fun.Resolver;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.Type;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapHierarchy;

class OpeningClosingPeriodFunDef
extends FunDefBase {
    private final boolean opening;
    static final Resolver OpeningPeriodResolver = new MultiResolver("OpeningPeriod", "OpeningPeriod([<Level>[, <Member>]])", "Returns the first descendant of a member at a level.", new String[]{"fm", "fml", "fmlm"}){

        protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
            return new OpeningClosingPeriodFunDef(dummyFunDef, true);
        }
    };
    static final Resolver ClosingPeriodResolver = new MultiResolver("ClosingPeriod", "ClosingPeriod([<Level>[, <Member>]])", "Returns the last descendant of a member at a level.", new String[]{"fm", "fml", "fmlm", "fmm"}){

        protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
            return new OpeningClosingPeriodFunDef(dummyFunDef, false);
        }
    };

    public OpeningClosingPeriodFunDef(FunDef dummyFunDef, boolean opening) {
        super(dummyFunDef);
        this.opening = opening;
    }

    public Type getResultType(Validator validator, Exp[] args) {
        if (args.length == 0) {
            RolapHierarchy defaultTimeHierarchy = ((RolapCube)validator.getQuery().getCube()).getTimeHierarchy(this.getName());
            return MemberType.forHierarchy(defaultTimeHierarchy);
        }
        return super.getResultType(validator, args);
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        Hierarchy levelHierarchy;
        Hierarchy memberHierarchy;
        LevelCalc levelCalc;
        MemberCalc memberCalc;
        Exp[] args = call.getArgs();
        RolapHierarchy defaultTimeHierarchy = null;
        switch (args.length) {
            case 0: {
                defaultTimeHierarchy = ((RolapCube)compiler.getEvaluator().getCube()).getTimeHierarchy(this.getName());
                memberCalc = new HierarchyCurrentMemberFunDef.FixedCalcImpl((Exp)new DummyExp(MemberType.forHierarchy(defaultTimeHierarchy)), defaultTimeHierarchy);
                levelCalc = null;
                break;
            }
            case 1: {
                defaultTimeHierarchy = ((RolapCube)compiler.getEvaluator().getCube()).getTimeHierarchy(this.getName());
                levelCalc = compiler.compileLevel(call.getArg(0));
                memberCalc = new HierarchyCurrentMemberFunDef.FixedCalcImpl((Exp)new DummyExp(MemberType.forHierarchy(defaultTimeHierarchy)), defaultTimeHierarchy);
                break;
            }
            default: {
                levelCalc = compiler.compileLevel(call.getArg(0));
                memberCalc = compiler.compileMember(call.getArg(1));
            }
        }
        if (levelCalc != null && !(memberHierarchy = memberCalc.getType().getHierarchy()).equals(levelHierarchy = levelCalc.getType().getHierarchy())) {
            throw MondrianResource.instance().FunctionMbrAndLevelHierarchyMismatch.ex(this.opening ? "OpeningPeriod" : "ClosingPeriod", levelHierarchy.getUniqueName(), memberHierarchy.getUniqueName());
        }
        return new AbstractMemberCalc(call, new Calc[]{levelCalc, memberCalc}){

            public Member evaluateMember(Evaluator evaluator) {
                Level level;
                Member member = memberCalc.evaluateMember(evaluator);
                if (levelCalc == null) {
                    int targetDepth = member.getLevel().getDepth() + 1;
                    List<? extends Level> levels = member.getHierarchy().getLevelList();
                    if (levels.size() <= targetDepth) {
                        return member.getHierarchy().getNullMember();
                    }
                    level = levels.get(targetDepth);
                } else {
                    level = levelCalc.evaluateLevel(evaluator);
                }
                if (level.getDepth() < member.getLevel().getDepth()) {
                    return member.getHierarchy().getNullMember();
                }
                if (level == member.getLevel()) {
                    return member;
                }
                return OpeningClosingPeriodFunDef.getDescendant(evaluator.getSchemaReader(), member, level, OpeningClosingPeriodFunDef.this.opening);
            }
        };
    }

    static Member getDescendant(SchemaReader schemaReader, Member member, Level targetLevel, boolean returnFirstDescendant) {
        int index;
        List<Member> children;
        int targetLevelDepth = targetLevel.getDepth();
        OpeningClosingPeriodFunDef.assertPrecondition(member.getLevel().getDepth() < targetLevelDepth, "member.getLevel().getDepth() < targetLevel.getDepth()");
        do {
            if ((children = schemaReader.getMemberChildren(member)).size() != 0) continue;
            return targetLevel.getHierarchy().getNullMember();
        } while ((member = children.get(index = returnFirstDescendant ? 0 : children.size() - 1)).getLevel().getDepth() != targetLevelDepth);
        if (member.isHidden()) {
            return member.getHierarchy().getNullMember();
        }
        return member;
    }
}

