/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.impl.AbstractMemberCalc;
import mondrian.calc.impl.AbstractTupleCalc;
import mondrian.mdx.NamedSetExpr;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Member;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.resource.MondrianResource;

public class NamedSetCurrentFunDef
extends FunDefBase {
    static final NamedSetCurrentFunDef instance = new NamedSetCurrentFunDef();

    private NamedSetCurrentFunDef() {
        super("Current", "Returns the current member or tuple of a named set.", "ptx");
    }

    public Exp createCall(Validator validator, Exp[] args) {
        assert (args.length == 1);
        Exp arg0 = args[0];
        if (!(arg0 instanceof NamedSetExpr)) {
            throw MondrianResource.instance().NotANamedSet.ex();
        }
        return super.createCall(validator, args);
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        Exp arg0 = call.getArg(0);
        assert (arg0 instanceof NamedSetExpr) : "checked this in createCall";
        final NamedSetExpr namedSetExpr = (NamedSetExpr)arg0;
        if (arg0.getType().getArity() == 1) {
            return new AbstractMemberCalc(call, new Calc[0]){

                public Member evaluateMember(Evaluator evaluator) {
                    return namedSetExpr.getEval(evaluator).currentMember();
                }
            };
        }
        return new AbstractTupleCalc(call, new Calc[0]){

            public Member[] evaluateTuple(Evaluator evaluator) {
                return namedSetExpr.getEval(evaluator).currentTuple();
            }
        };
    }
}

