/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.Map;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.impl.ConstantCalc;
import mondrian.mdx.MdxVisitor;
import mondrian.olap.Category;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.type.NullType;
import mondrian.olap.type.NumericType;
import mondrian.olap.type.StringType;
import mondrian.olap.type.SymbolType;
import mondrian.olap.type.Type;
import org.olap4j.impl.UnmodifiableArrayMap;

public class Literal
extends ExpBase {
    public final int category;
    private final Object o;
    public static final Literal nullValue = new Literal(16, null);
    public static final Literal emptyString = new Literal(9, "");
    public static final Literal zero = new Literal(7, BigDecimal.ZERO);
    public static final Literal one = new Literal(7, BigDecimal.ONE);
    public static final Literal negativeOne = new Literal(7, BigDecimal.ONE.negate());
    public static final Literal doubleZero = zero;
    public static final Literal doubleOne = one;
    public static final Literal doubleNegativeOne = negativeOne;
    private static final Map<BigDecimal, Literal> MAP = UnmodifiableArrayMap.of((Object)BigDecimal.ZERO, (Object)zero, (Object[])new Object[]{BigDecimal.ONE, one, BigDecimal.ONE.negate(), negativeOne});

    private Literal(int type, Object o) {
        this.category = type;
        this.o = o;
    }

    public static Literal createString(String s) {
        return s.equals("") ? emptyString : new Literal(9, s);
    }

    public static Literal createSymbol(String s) {
        return new Literal(11, s);
    }

    public static Literal create(Double d) {
        return new Literal(7, new BigDecimal(d));
    }

    public static Literal create(Integer i) {
        return new Literal(7, new BigDecimal(i));
    }

    public static Literal create(BigDecimal d) {
        Literal literal = MAP.get(d);
        if (literal != null) {
            return literal;
        }
        return new Literal(7, d);
    }

    public Literal clone() {
        return this;
    }

    public void unparse(PrintWriter pw) {
        switch (this.category) {
            case 7: 
            case 11: {
                pw.print(this.o);
                break;
            }
            case 9: {
                pw.print(Util.quoteForMdx((String)this.o));
                break;
            }
            case 16: {
                pw.print("NULL");
                break;
            }
            default: {
                throw Util.newInternal("bad literal type " + this.category);
            }
        }
    }

    public int getCategory() {
        return this.category;
    }

    public Type getType() {
        switch (this.category) {
            case 11: {
                return new SymbolType();
            }
            case 7: {
                return new NumericType();
            }
            case 9: {
                return new StringType();
            }
            case 16: {
                return new NullType();
            }
        }
        throw Category.instance.badValue(this.category);
    }

    public Exp accept(Validator validator) {
        return this;
    }

    public Calc accept(ExpCompiler compiler) {
        return new ConstantCalc(this.getType(), this.o);
    }

    public Object accept(MdxVisitor visitor) {
        return visitor.visit(this);
    }

    public Object getValue() {
        return this.o;
    }

    public int getIntValue() {
        if (this.o instanceof Number) {
            return ((Number)this.o).intValue();
        }
        throw Util.newInternal("cannot convert " + this.o + " to int");
    }
}

