/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import mondrian.olap.Connection;
import mondrian.olap.FunTable;
import mondrian.olap.Query;
import mondrian.olap.QueryPart;
import mondrian.olap.Util;
import mondrian.parser.JavaccParserValidatorImpl;
import mondrian.parser.MdxParserValidator;
import mondrian.resource.MondrianResource;
import mondrian.server.Statement;
import org.apache.log4j.Logger;

public abstract class ConnectionBase
implements Connection {
    protected ConnectionBase() {
    }

    protected abstract Logger getLogger();

    public String getFullConnectString() {
        String s = this.getConnectString();
        String catalogName = this.getCatalogName();
        if (catalogName != null) {
            int len = s.length() + catalogName.length() + 32;
            StringBuilder buf = new StringBuilder(len);
            buf.append(s);
            if (!s.endsWith(";")) {
                buf.append(';');
            }
            buf.append("Initial Catalog=");
            buf.append(catalogName);
            buf.append(';');
            s = buf.toString();
        }
        return s;
    }

    public abstract Statement getInternalStatement();

    public Query parseQuery(String query) {
        return (Query)this.parseStatement(query);
    }

    public QueryPart parseStatement(Statement statement, String query, FunTable funTable, boolean strictValidation) {
        MdxParserValidator parser = this.createParser();
        boolean debug = false;
        if (funTable == null) {
            funTable = this.getSchema().getFunTable();
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(Util.nl + query));
        }
        try {
            return parser.parseInternal(statement, query, debug, funTable, strictValidation);
        }
        catch (Exception e) {
            throw MondrianResource.instance().FailedToParseQuery.ex(query, e);
        }
    }

    protected MdxParserValidator createParser() {
        return new JavaccParserValidatorImpl();
    }
}

