/*
 * Decompiled with CFR 0.152.
 */
package mondrian.calc;

import java.io.PrintWriter;
import java.util.IdentityHashMap;
import java.util.Map;
import mondrian.calc.Calc;
import mondrian.olap.Util;
import mondrian.util.Bug;
import org.apache.commons.collections.map.CompositeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalcWriter {
    private static final int INDENT = 4;
    private static String BIG_STRING = "                ";
    private final PrintWriter writer;
    private final boolean profiling;
    private int linePrefixLength;
    private final Map<Calc, Map<String, Object>> parentArgMap = new IdentityHashMap<Calc, Map<String, Object>>();

    public CalcWriter(PrintWriter writer, boolean profiling) {
        this.writer = writer;
        this.profiling = profiling;
    }

    public PrintWriter getWriter() {
        return this.writer;
    }

    public void visitChild(int ordinal, Calc calc) {
        this.indent();
        calc.accept(this);
        this.outdent();
    }

    public void visitCalc(Calc calc, String name, Map<String, Object> arguments, Calc[] childCalcs) {
        int k;
        this.writer.print(this.getLinePrefix());
        this.writer.print(name);
        Map<String, Object> parentArgs = this.parentArgMap.get(calc);
        if (parentArgs != null && !parentArgs.isEmpty()) {
            arguments = new CompositeMap(arguments, parentArgs);
        }
        if (!arguments.isEmpty()) {
            this.writer.print("(");
            k = 0;
            for (Map.Entry entry : arguments.entrySet()) {
                if (k++ > 0) {
                    this.writer.print(", ");
                }
                this.writer.print((String)entry.getKey());
                this.writer.print("=");
                this.writer.print(entry.getValue());
            }
            this.writer.print(")");
        }
        this.writer.println();
        k = 0;
        for (Calc childCalc : childCalcs) {
            this.visitChild(k++, childCalc);
        }
    }

    public void indent() {
        this.linePrefixLength += 4;
    }

    public void outdent() {
        this.linePrefixLength -= 4;
    }

    private String getLinePrefix() {
        return CalcWriter.spaces(this.linePrefixLength);
    }

    private static synchronized String spaces(int n) {
        Util.discard((boolean)Bug.olap4jUpgrade("1.0.1.553"));
        while (n > BIG_STRING.length()) {
            BIG_STRING = BIG_STRING + BIG_STRING;
        }
        return BIG_STRING.substring(0, n);
    }

    public void setParentArgs(Calc calc, Map<String, Object> argumentMap) {
        this.parentArgMap.put(calc, argumentMap);
    }

    public boolean enableProfiling() {
        return this.profiling;
    }
}

