/*
 * Decompiled with CFR 0.152.
 */
package com.bitmechanic.maxq;

import com.bitmechanic.maxq.HttpRequestHeader;
import com.bitmechanic.maxq.ProxyServer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;

public class RequestHandler
implements Runnable {
    private InputStream clientIn;
    private InputStream serverIn;
    private OutputStream clientOut;
    private OutputStream serverOut;
    private HttpRequestHeader header;
    private ProxyServer proxyServer;
    private Socket clientSocket;
    private ByteArrayOutputStream buffer;

    RequestHandler(ProxyServer proxyServer, Socket s) {
        this.clientSocket = s;
        this.buffer = new ByteArrayOutputStream();
        this.proxyServer = proxyServer;
    }

    private boolean initClientServerConnections(Socket s) throws IOException {
        this.clientIn = s.getInputStream();
        this.clientOut = s.getOutputStream();
        this.header = new HttpRequestHeader();
        this.header.parse(this.clientIn);
        if (this.header.url == null || !this.header.url.startsWith("http")) {
            this.clientIn.close();
            this.clientOut.close();
            return false;
        }
        URL url = new URL(this.header.url);
        int port = url.getPort();
        if (port < 1) {
            port = 80;
        }
        Socket sock = new Socket(InetAddress.getByName(url.getHost()), port);
        this.serverIn = sock.getInputStream();
        this.serverOut = sock.getOutputStream();
        return true;
    }

    private String stripProxyInfoFromRequestHeader() {
        String res = "";
        try {
            String origUrl = this.header.url;
            URL url = new URL(origUrl);
            this.header.url = url.getFile();
            res = this.header.toString();
            this.header.url = origUrl;
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
        return res;
    }

    public void run() {
        block6: {
            try {
                byte[] requestBody;
                int rs = this.clientSocket.getReceiveBufferSize();
                int ss = this.clientSocket.getSendBufferSize();
                int BUF_SIZE = rs < ss ? ss : rs;
                byte[] buf = new byte[BUF_SIZE];
                if (!this.initClientServerConnections(this.clientSocket)) break block6;
                String headerStr = this.stripProxyInfoFromRequestHeader();
                byte[] bytes = headerStr.getBytes();
                this.serverOut.write(bytes, 0, bytes.length);
                if (this.header.contentLength > 0) {
                    this.buffer.reset();
                    this.moveAvailableBytes(this.clientIn, this.serverOut, buf, this.header.contentLength);
                    requestBody = this.buffer.toByteArray();
                } else {
                    requestBody = new byte[]{};
                }
                this.proxyServer.processRequest(this.header, requestBody);
                this.buffer.reset();
                try {
                    this.moveAvailableBytes(this.serverIn, this.clientOut, buf);
                    this.proxyServer.processResponse(this.header, this.buffer.toByteArray());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.clientSocket.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void moveAvailableBytes(InputStream src, OutputStream dest, byte[] buf) throws IOException {
        this.moveAvailableBytes(src, dest, buf, -1);
    }

    private void moveAvailableBytes(InputStream src, OutputStream dest, byte[] buf, int max) throws IOException {
        int len = 0;
        for (int num = 0; (max == -1 || num < max) && 0 < (len = src.read(buf, 0, buf.length)); num += len) {
            dest.write(buf, 0, len);
            this.buffer.write(buf, 0, len);
        }
    }
}

