/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.xml;

import java.util.Arrays;
import java.util.Set;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.Transform;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;

public class XMLLayout
extends Layout {
    private final int DEFAULT_SIZE = 256;
    private final int UPPER_LIMIT = 2048;
    private StringBuffer buf = new StringBuffer(256);
    private boolean locationInfo = false;
    private boolean properties = false;

    public void setLocationInfo(boolean bl) {
        this.locationInfo = bl;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public void setProperties(boolean bl) {
        this.properties = bl;
    }

    public boolean getProperties() {
        return this.properties;
    }

    @Override
    public void activateOptions() {
    }

    @Override
    public String format(LoggingEvent loggingEvent) {
        Set set;
        String[] stringArray;
        if (this.buf.capacity() > 2048) {
            this.buf = new StringBuffer(256);
        } else {
            this.buf.setLength(0);
        }
        this.buf.append("<log4j:event logger=\"");
        this.buf.append(Transform.escapeTags(loggingEvent.getLoggerName()));
        this.buf.append("\" timestamp=\"");
        this.buf.append(loggingEvent.timeStamp);
        this.buf.append("\" level=\"");
        this.buf.append(Transform.escapeTags(String.valueOf(loggingEvent.getLevel())));
        this.buf.append("\" thread=\"");
        this.buf.append(Transform.escapeTags(loggingEvent.getThreadName()));
        this.buf.append("\">\r\n");
        this.buf.append("<log4j:message><![CDATA[");
        Transform.appendEscapingCDATA(this.buf, loggingEvent.getRenderedMessage());
        this.buf.append("]]></log4j:message>\r\n");
        String string = loggingEvent.getNDC();
        if (string != null) {
            this.buf.append("<log4j:NDC><![CDATA[");
            Transform.appendEscapingCDATA(this.buf, string);
            this.buf.append("]]></log4j:NDC>\r\n");
        }
        if ((stringArray = loggingEvent.getThrowableStrRep()) != null) {
            this.buf.append("<log4j:throwable><![CDATA[");
            for (int i = 0; i < stringArray.length; ++i) {
                Transform.appendEscapingCDATA(this.buf, stringArray[i]);
                this.buf.append("\r\n");
            }
            this.buf.append("]]></log4j:throwable>\r\n");
        }
        if (this.locationInfo) {
            LocationInfo locationInfo = loggingEvent.getLocationInformation();
            this.buf.append("<log4j:locationInfo class=\"");
            this.buf.append(Transform.escapeTags(locationInfo.getClassName()));
            this.buf.append("\" method=\"");
            this.buf.append(Transform.escapeTags(locationInfo.getMethodName()));
            this.buf.append("\" file=\"");
            this.buf.append(Transform.escapeTags(locationInfo.getFileName()));
            this.buf.append("\" line=\"");
            this.buf.append(locationInfo.getLineNumber());
            this.buf.append("\"/>\r\n");
        }
        if (this.properties && (set = loggingEvent.getPropertyKeySet()).size() > 0) {
            this.buf.append("<log4j:properties>\r\n");
            Object[] objectArray = set.toArray();
            Arrays.sort(objectArray);
            for (int i = 0; i < objectArray.length; ++i) {
                String string2 = objectArray[i].toString();
                Object object = loggingEvent.getMDC(string2);
                if (object == null) continue;
                this.buf.append("<log4j:data name=\"");
                this.buf.append(Transform.escapeTags(string2));
                this.buf.append("\" value=\"");
                this.buf.append(Transform.escapeTags(String.valueOf(object)));
                this.buf.append("\"/>\r\n");
            }
            this.buf.append("</log4j:properties>\r\n");
        }
        this.buf.append("</log4j:event>\r\n\r\n");
        return this.buf.toString();
    }

    @Override
    public boolean ignoresThrowable() {
        return false;
    }
}

