/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www.jaxrs;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import javax.xml.bind.annotation.XmlRootElement;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.xml.XMLHandler;
import org.w3c.dom.Node;

@XmlRootElement
public class ServerStatus {
    private String statusDescription;
    private String errorDescription;
    private long memoryFree;
    private long memoryTotal;
    private int cpuCores;
    private long cpuProcessTime;
    private long uptime;
    private int threadCount;
    private double loadAvg;
    private String osName;
    private String osVersion;
    private String osArchitecture;

    public ServerStatus() {
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        int cores = Runtime.getRuntime().availableProcessors();
        long freeMemory = Runtime.getRuntime().freeMemory();
        long totalMemory = Runtime.getRuntime().totalMemory();
        String osArch = operatingSystemMXBean.getArch();
        String osName = operatingSystemMXBean.getName();
        String osVersion = operatingSystemMXBean.getVersion();
        double loadAvg = operatingSystemMXBean.getSystemLoadAverage();
        int threadCount = threadMXBean.getThreadCount();
        long allThreadsCpuTime = 0L;
        long[] threadIds = threadMXBean.getAllThreadIds();
        for (int i = 0; i < threadIds.length; ++i) {
            allThreadsCpuTime += threadMXBean.getThreadCpuTime(threadIds[i]);
        }
        long uptime = runtimeMXBean.getUptime();
        this.setCpuCores(cores);
        this.setCpuProcessTime(allThreadsCpuTime);
        this.setUptime(uptime);
        this.setThreadCount(threadCount);
        this.setLoadAvg(loadAvg);
        this.setOsName(osName);
        this.setOsVersion(osVersion);
        this.setOsArchitecture(osArch);
        this.setMemoryFree(freeMemory);
        this.setMemoryTotal(totalMemory);
    }

    public ServerStatus(String statusDescription) {
        this();
        this.statusDescription = statusDescription;
    }

    public ServerStatus(Node statusNode) throws KettleException {
        this();
        this.statusDescription = XMLHandler.getTagValue((Node)statusNode, (String)"statusdesc");
        this.memoryFree = Const.toLong((String)XMLHandler.getTagValue((Node)statusNode, (String)"memory_free"), (long)-1L);
        this.memoryTotal = Const.toLong((String)XMLHandler.getTagValue((Node)statusNode, (String)"memory_total"), (long)-1L);
        String cpuCoresStr = XMLHandler.getTagValue((Node)statusNode, (String)"cpu_cores");
        this.cpuCores = Const.toInt((String)cpuCoresStr, (int)-1);
        String cpuProcessTimeStr = XMLHandler.getTagValue((Node)statusNode, (String)"cpu_process_time");
        this.cpuProcessTime = Utils.isEmpty((CharSequence)cpuProcessTimeStr) ? 0L : Long.valueOf(cpuProcessTimeStr);
        this.uptime = Const.toLong((String)XMLHandler.getTagValue((Node)statusNode, (String)"uptime"), (long)-1L);
        this.threadCount = Const.toInt((String)XMLHandler.getTagValue((Node)statusNode, (String)"thread_count"), (int)-1);
        this.loadAvg = Const.toDouble((String)XMLHandler.getTagValue((Node)statusNode, (String)"load_avg"), (double)-1.0);
        this.osName = XMLHandler.getTagValue((Node)statusNode, (String)"os_name");
        this.osVersion = XMLHandler.getTagValue((Node)statusNode, (String)"os_version");
        this.osArchitecture = XMLHandler.getTagValue((Node)statusNode, (String)"os_arch");
    }

    public String getStatusDescription() {
        return this.statusDescription;
    }

    public void setStatusDescription(String statusDescription) {
        this.statusDescription = statusDescription;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    public double getMemoryFree() {
        return this.memoryFree;
    }

    public void setMemoryFree(long memoryFree) {
        this.memoryFree = memoryFree;
    }

    public double getMemoryTotal() {
        return this.memoryTotal;
    }

    public void setMemoryTotal(long memoryTotal) {
        this.memoryTotal = memoryTotal;
    }

    public int getCpuCores() {
        return this.cpuCores;
    }

    public void setCpuCores(int cpuCores) {
        this.cpuCores = cpuCores;
    }

    public long getCpuProcessTime() {
        return this.cpuProcessTime;
    }

    public void setCpuProcessTime(long cpuProcessTime) {
        this.cpuProcessTime = cpuProcessTime;
    }

    public void setUptime(long uptime) {
        this.uptime = uptime;
    }

    public long getUptime() {
        return this.uptime;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setLoadAvg(double loadAvg) {
        this.loadAvg = loadAvg;
    }

    public double getLoadAvg() {
        return this.loadAvg;
    }

    public void setOsName(String osName) {
        this.osName = osName;
    }

    public String getOsName() {
        return this.osName;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public void setOsArchitecture(String osArch) {
        this.osArchitecture = osArch;
    }

    public String getOsArchitecture() {
        return this.osArchitecture;
    }
}

