/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.www.BaseHttpServlet;
import org.pentaho.di.www.CartePluginInterface;
import org.pentaho.di.www.SlaveServerDetection;
import org.pentaho.di.www.WebResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class RegisterSlaveServlet
extends BaseHttpServlet
implements CartePluginInterface {
    private static final long serialVersionUID = 8513820270964866132L;
    public static final String CONTEXT_PATH = "/kettle/registerSlave";

    public RegisterSlaveServlet() {
    }

    public RegisterSlaveServlet(List<SlaveServerDetection> detections) {
        super(detections);
    }

    public RegisterSlaveServlet(List<SlaveServerDetection> detections, boolean isJetty) {
        super(detections, isJetty);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isJettyMode() && !request.getRequestURI().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug("Slave Server registration requested");
        }
        PrintWriter out = response.getWriter();
        if (this.log.isDetailed()) {
            this.logDetailed("Encoding: " + request.getCharacterEncoding());
        }
        response.setContentType("text/xml");
        out.print(XMLHandler.getXMLHeader());
        response.setStatus(200);
        try {
            String message;
            Document document = XMLHandler.loadXMLFile((InputStream)request.getInputStream());
            Node node = XMLHandler.getSubNode((Node)document, (String)"SlaveServerDetection");
            SlaveServerDetection slaveServerDetection = new SlaveServerDetection(node);
            int index = this.getDetections().indexOf(slaveServerDetection);
            if (index < 0) {
                this.getDetections().add(slaveServerDetection);
                message = "Slave server detection '" + slaveServerDetection.getSlaveServer().getName() + "' was replaced in the list.";
            } else {
                SlaveServerDetection old = this.getDetections().get(index);
                old.setSlaveServer(slaveServerDetection.getSlaveServer());
                old.setActive(slaveServerDetection.isActive());
                if (old.isActive()) {
                    old.setLastActiveDate(slaveServerDetection.getLastActiveDate());
                } else {
                    old.setLastInactiveDate(slaveServerDetection.getLastInactiveDate());
                }
                message = "Slave server detection '" + slaveServerDetection.getSlaveServer().getName() + "' was added to the list.";
            }
            out.println(new WebResult("OK", message));
        }
        catch (Exception ex) {
            out.println(new WebResult("ERROR", Const.getStackTracker((Throwable)ex)));
        }
    }

    public String toString() {
        return "Register slave server";
    }

    @Override
    public String getService() {
        return "/kettle/registerSlave (" + this.toString() + ")";
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }
}

