/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import org.owasp.encoder.Encode;
import org.pentaho.di.www.BaseHttpServlet;
import org.pentaho.di.www.CartePluginInterface;
import org.pentaho.di.www.SocketPortAllocation;
import org.pentaho.di.www.TransformationMap;

public class ListServerSocketServlet
extends BaseHttpServlet
implements CartePluginInterface {
    private static final long serialVersionUID = 3634806745372015720L;
    public static final String CONTEXT_PATH = "/kettle/listSocket";
    public static final String PARAM_HOSTNAME = "host";
    public static final String PARAM_ONLY_OPEN = "onlyOpen";

    public ListServerSocketServlet() {
    }

    public ListServerSocketServlet(TransformationMap transformationMap) {
        super(transformationMap);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug("List of ports for a server requested");
        }
        response.setStatus(200);
        String hostname = request.getParameter(PARAM_HOSTNAME);
        boolean onlyOpen = "Y".equalsIgnoreCase(request.getParameter(PARAM_ONLY_OPEN));
        response.setContentType("text/html");
        PrintStream out = new PrintStream((OutputStream)response.getOutputStream());
        out.println("<HTML>");
        out.println("<HEAD><TITLE>List of server sockets on server " + Encode.forHtml((String)("'" + hostname + "'")) + "</TITLE></HEAD>");
        out.println("<BODY>");
        out.println("<H1>Ports for host " + Encode.forHtml((String)("'" + hostname + "'")) + "</H1>");
        List<SocketPortAllocation> allocations = this.getTransformationMap().getHostServerSocketPorts(hostname);
        if (allocations == null) {
            out.println("No port allocations found for host " + Encode.forHtml((String)("'" + hostname + "'")));
            return;
        }
        out.println("Found " + allocations.size() + " ports for host " + Encode.forHtml((String)("'" + hostname + "'")) + "<p>");
        for (SocketPortAllocation allocation : allocations) {
            if (onlyOpen && (!onlyOpen || !allocation.isAllocated())) continue;
            out.println(allocation.getPort() + " : Transformation=" + allocation.getTransformationName() + ", " + allocation.getSourceSlaveName() + "/" + allocation.getSourceStepName() + "." + allocation.getSourceStepCopy());
            out.println(" --> " + allocation.getTargetSlaveName() + "/" + allocation.getTargetStepName() + "." + allocation.getTargetStepCopy());
            out.println(" id=" + allocation.getClusterRunId() + ", allocated=" + allocation.isAllocated());
            out.println(" time=" + allocation.getLastRequested());
            out.println("<br>");
        }
        out.println("<p>");
        out.println("</BODY>");
        out.println("</HTML>");
    }

    public String toString() {
        return "Server socket port information request";
    }

    @Override
    public String getService() {
        return "/kettle/listSocket (" + this.toString() + ")";
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }
}

